local S = minetest.get_translator(minetest.get_current_modname())

mobs:register_arrow("throwable_bombs:bomb", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"transparent.png"},
	velocity = 8,
        hit_player = function(self, player)
	end,

	on_step = function(self, dtime)

		local pos = self.object:get_pos()

		if minetest.is_protected(pos, "") then
			return
		end

		local n = minetest.get_node(pos).name

		if self.timer == 0 then
			self.timer = os.time()
		end

		if os.time() - self.timer > 5 or minetest.is_protected(pos, "")
		or ((n ~= "air") and (n ~= "tnt:tnt_burning")) then
			self.object:remove()
		end

		if math.random(2) == 2 then
			minetest.set_node(pos, {name = "tnt:tnt_burning"})
		end

		if math.random(6) == 1 then

			local p = {
				x = pos.x + math.random(-1, 1),
				y = pos.y + math.random(-1, 1),
				z = pos.z + math.random(-1, 1)
			}

			local n = minetest.get_node(p).name

			if n == "air" then
				minetest.set_node(p, {name = "tnt:tnt_burning"})
			end
		end
	end
})
--if minetest.get_modpath("special_nether_swords") then
mobs:register_arrow("throwable_bombs:bomb_arrow", {
	visual = "sprite",
	visual_size = { x = 0.5, y = 0.5 },
	textures = { "tnt_tnt_stick.png" },
	velocity = 18, -- Nodes per second
	physical = true,
	collide_with_objects = true,
	
		on_step = function(self, dtime)

		local pos = self.object:get_pos()

		if minetest.is_protected(pos, "") then
			return
		end

		local n = minetest.get_node(pos).name

		if self.timer == 0 then
			self.timer = os.time()
		end

		if os.time() - self.timer > 5 or minetest.is_protected(pos, "")
		or ((n ~= "air") and (n ~= "tnt:tnt_burning")) then
			self.object:remove()
		end

		if math.random(2) == 2 then
			minetest.set_node(pos, {name = "tnt:tnt_burning"})
		end

		if math.random(6) == 1 then

			local p = {
				x = pos.x + math.random(-1, 1),
				y = pos.y + math.random(-1, 1),
				z = pos.z + math.random(-1, 1)
			}

			local n = minetest.get_node(p).name

			if n == "air" then
				minetest.set_node(p, {name = "tnt:tnt_burning"})
			end
		end
	end
})

minetest.register_tool("throwable_bombs:bomb_gun", {
	description = "tnt gun (shoots tnt)",
	short_description = "Bombs gun",
	inventory_image = "default_stick.png",
	groups = { not_in_creative_inventory = 1 },
	on_use = function(itemstack, user, pointed_thing)
		if not minetest.is_player(user) then
			return
		end

		local pos = user:get_pos()
		local dir = user:get_look_dir()
		local vel = user:get_velocity()

		local epos = vector.add(pos, vector.add({ x = 0, y = 1, z = 0 }, vector.multiply(dir, 2)))

		local obj = minetest.add_entity(epos, "throwable_bombs:bomb_arrow")
		if not obj then
			return
		end

		obj:set_velocity(vector.add(vel, vector.multiply(dir, 18)))

		local ent = obj:get_luaentity()
		if not ent then
			obj:remove()
			return
		end

		ent.switch = 1

		local yaw = user:get_look_horizontal()
		obj:set_yaw(yaw + math.pi / 2)
	end,
})
--end
