local S = minetest.get_translator(minetest.get_current_modname())

mobs:register_arrow("throwable_bombs:bomb", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"transparent.png"},
	velocity = 8,
        hit_player = function(self, player)
	end,

	on_step = function(self, dtime)

		local pos = self.object:get_pos()

		if minetest.is_protected(pos, "") then
			return
		end

		local n = minetest.get_node(pos).name

		if self.timer == 0 then
			self.timer = os.time()
		end

		if os.time() - self.timer > 5 or minetest.is_protected(pos, "")
		or ((n ~= "air") and (n ~= "tnt:tnt_burning")) then
			self.object:remove()
		end

		if math.random(2) == 2 then
			minetest.set_node(pos, {name = "tnt:tnt_burning"})
		end

		if math.random(6) == 1 then

			local p = {
				x = pos.x + math.random(-1, 1),
				y = pos.y + math.random(-1, 1),
				z = pos.z + math.random(-1, 1)
			}

			local n = minetest.get_node(p).name

			if n == "air" then
				minetest.set_node(p, {name = "tnt:tnt_burning"})
			end
		end
	end
})
--if minetest.get_modpath("special_nether_swords") then
mobs:register_arrow("throwable_bombs:bomb_arrow", {
	visual = "sprite",
	visual_size = { x = 0.5, y = 0.5 },
	textures = { "tnt_tnt_stick.png" },
	velocity = 18, -- Nodes per second
	physical = true,
	collide_with_objects = true,
	
		on_step = function(self, dtime)

		local pos = self.object:get_pos()

		if minetest.is_protected(pos, "") then
			return
		end

		local n = minetest.get_node(pos).name

		if self.timer == 0 then
			self.timer = os.time()
		end

		if os.time() - self.timer > 5 or minetest.is_protected(pos, "")
		or ((n ~= "air") and (n ~= "tnt:tnt_burning")) then
			self.object:remove()
		end

		if math.random(2) == 2 then
			minetest.set_node(pos, {name = "tnt:tnt_burning"})
		end

		if math.random(6) == 1 then

			local p = {
				x = pos.x + math.random(-1, 1),
				y = pos.y + math.random(-1, 1),
				z = pos.z + math.random(-1, 1)
			}

			local n = minetest.get_node(p).name

			if n == "air" then
				minetest.set_node(p, {name = "tnt:tnt_burning"})
			end
		end
	end
})

minetest.register_tool("throwable_bombs:bomb_gun", {
	description = "tnt gun (shoots tnt)",
	short_description = "Bombs gun",
	inventory_image = "default_stick.png",
	groups = { not_in_creative_inventory = 1 },
	on_use = function(itemstack, user, pointed_thing)
		if not minetest.is_player(user) then
			return
		end

		local pos = user:get_pos()
		local dir = user:get_look_dir()
		local vel = user:get_velocity()

		local epos = vector.add(pos, vector.add({ x = 0, y = 1, z = 0 }, vector.multiply(dir, 2)))

		local obj = minetest.add_entity(epos, "throwable_bombs:bomb_arrow")
		if not obj then
			return
		end

		obj:set_velocity(vector.add(vel, vector.multiply(dir, 18)))

		local ent = obj:get_luaentity()
		if not ent then
			obj:remove()
			return
		end

		ent.switch = 1

		local yaw = user:get_look_horizontal()
		obj:set_yaw(yaw + math.pi / 2)
	end,
})

minetest.register_craftitem("throwable_bombs:throwable_tnt_spawner", {
	description = "Throwable Tnt Spawner",
	range = 0,
	stack_max= 16,
	inventory_image = "tnt_stick.png",
	on_use = function(itemstack, user, pointed_thing)
			if not minetest.setting_getbool("creative_mode") then itemstack:take_item()
		end
		if pointed_thing.type ~= "nothing" then
			local pointed = minetest.get_pointed_thing_position(pointed_thing)
			if vector.distance(user:getpos(), pointed) < 8 then
				return itemstack
			end
		end
		local pos = user:getpos()
		local dir = user:get_look_dir()
		local yaw = user:get_look_yaw()
		if pos and dir then
			pos.y = pos.y + 1.5
			local obj = minetest.add_entity(pos, "throwable_bombs:bomb_arrow")
			if obj then
				obj:setvelocity({x=dir.x * 35, y=dir.y * 35, z=dir.z * 35})
				obj:setacceleration({x=dir.x * -3, y=-10, z=dir.z * -3})
				obj:setyaw(yaw + math.pi)
				local ent = obj:get_luaentity()
				if ent then
					ent.player = ent.player or user
				end
			end
		end
		return itemstack
	end,
})
