local modpath, modname = ...

mobs:register_arrow("grave:phantom_arrow", {
	visual = "sprite",
	visual_size = {x = 0.01, y = 0.01},
	textures = {"grave_lich_orb.png"},
	collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
	velocity = 32,
	tail = 0,
	glow = 0,
	expire = 0.1,

	on_activate = function(self, staticdata, dtime_s)
		self.object:set_armor_groups({immortal = 1, fleshy = 100})
        end,

	hit_player = function(self, player)
		player:punch(self.object, 1.0, {
			full_punch_interval = 1.0,
			damage_groups = {fleshy = 4},
                }, nil)
                local vel = self.object:get_velocity()
                player:add_player_velocity({x=0,y=38,z=0})
                minetest.after(3, function()
                        player:punch(self.object, 1.0, {
                                full_punch_interval = 1.0,
                                damage_groups = {fleshy = 4},
                        }, nil)
                        player:add_player_velocity({x=vel.x*3,y=-1,z=vel.z*3})
                end)
	end,

	hit_mob = function(self, player)
		player:punch(self.object, 1.0, {
			full_punch_interval = 1.0,
			damage_groups = {fleshy = 999},
                }, nil)
                local pos = self.object:get_pos()
                minetest.add_entity(pos, "grave:phantom")
	end,

	-- node hit
	hit_node = function(self, pos, node)
                local pos_above = {
                        x = pos.x,
                        y = pos.y + 1,
                        z = pos.z,
                }
                minetest.add_node(pos_above, {name="grave:grave_oak_sapling"})
	end
})

-- Lich

mobs:register_mob("grave:phantom", {
        type =  "monster",
        hp_min = 35,
        hp_max = 35,
        armor = 80,
        passive = false,
        walk_velocity = 3,
        run_velocity = 5,
        stand_chance = 30,
        walk_chance = 70,
        fly = true,
        fly_in = "air",
        jump = true,
        jump_height = 2.1,
        stepheight = 1.1,
        view_range = 18,
        knock_back = true,
        fear_height = 10,
        fall_damage = 1,
        water_damage = 0,
        lava_damage = 5,
        light_damage = 0,
        suffocation = true,
        floats = 1,
        reach = 2,
        attack_animals = false,
        attack_npcs = true,
        attack_players = true,
        group_attack = true,
        attack_type = "shoot",
	arrow = "grave:phantom_arrow",
	reach = 1,
	shoot_interval = 4,
        blood_amount = 0,
        pathfinding = 1,
        makes_footstep_sound = true,
        sounds = {
                random = "grave_phantom",
                shoot = "grave_phantom",
	},
	drops = {
		{name = "bonemeal:bone", chance = 1, min = 1, max = 6},
	},
        visual = "mesh",
        visual_size = {x = 1, y = 1},
        collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	textures = {
		{"grave_phantom.png"},
	},
        mesh = "grave_phantom.b3d",
	animation = {
		speed_normal = 15,
		speed_sprint = 20,
		stand_start = 60,
		stand_end = 80,
		walk_start = 60,
		walk_end = 80,
		run_start = 60,
		run_end = 80,
		punch_start = 90,
		punch_end = 100,
	},
})

mobs:spawn({
	name = "grave:phantom",
	nodes = "grave:grave_oak_leaves",
        neighbours = "grave:grave_oak_tree",
	min_light = 1,
	interval = 60,
	chance = 100,
	min_height = 2000,
	max_height = 2999,
	day_toggle = nil,
})
