-----------
-- Nodes -- v0.1
-----------

local modpath, modname = ...

assert(loadfile(modpath .. "/crafting.lua"))(modpath, modname)

-----------
-- Nodes --
-----------

-- Grave Dirt with Grave Grass --

minetest.register_node("grave:grave_dirt_with_grave_grass", {
	description = "Grave Dirt with Grave Grass",
	tiles = {"grave_grave_grass.png",
		"grave_grave_dirt.png",
		{name = "grave_grave_dirt.png^grave_grave_grass_side.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, soil = 1},
	drop = "grave:grave_dirt",
	sounds = default.node_sound_dirt_defaults({
		footstep = {name = "default_grass_footstep", gain = 0.4},
	}),
})

-- Grave Dirt --

minetest.register_node("grave:grave_dirt", {
	description = "Grave Dirt",
	tiles = {"grave_grave_dirt.png"},
	groups = {crumbly = 3, soil = 1},
	sounds = default.node_sound_dirt_defaults(),
})


-- Grave Oak Tree --

minetest.register_node("grave:grave_oak_tree", {
	description = "Grave Oak Tree",
	tiles = {"grave_grave_oak_tree_top.png", "grave_grave_oak_tree_top.png", "grave_grave_oak_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
	sounds = default.node_sound_wood_defaults(),
	on_place = minetest.rotate_node
})

-- Grave Oak Wood --

minetest.register_node("grave:grave_oak_wood", {
	description = "Grave Oak Wood Planks",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"grave_grave_oak_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1},
	sounds = default.node_sound_wood_defaults(),
})

-- Grave Oak Sapling --

minetest.register_node("grave:grave_oak_sapling", {
	description = "Grave Oak Tree Sapling",
	drawtype = "plantlike",
	tiles = {"grave_grave_oak_sapling.png"},
	inventory_image = "grave_grave_oak_sapling.png",
	wield_image = "grave_grave_oak_sapling.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	on_timer = grow_sapling,
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2,
		attached_node = 1, sapling = 1},
	sounds = default.node_sound_leaves_defaults(),

	on_construct = function(pos)
		minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,

	on_place = function(itemstack, placer, pointed_thing)
		itemstack = default.sapling_on_place(itemstack, placer, pointed_thing,
			"grave:grave_oak_sapling",
			-- minp, maxp to be checked, relative to sapling pos
			-- minp_relative.y = 1 because sapling pos has been checked
			{x = -3, y = 1, z = -3},
			{x = 3, y = 6, z = 3},
			-- maximum interval of interior volume check
			4)

		return itemstack
	end,
})

-- Grave Oak Leaves -- 

minetest.register_node("grave:grave_oak_leaves", {
	description = "Grave Oak Leaves",
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"grave_grave_oak_leaves.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1},
	drop = {
		max_items = 1,
		items = {
			{
				-- player will get sapling with 1/20 chance
				items = {"grave:grave_oak_sapling"},
				rarity = 20,
			},
			{
				-- player will get leaves only if he get no saplings,
				-- this is because max_items is 1
				items = {"grave:grave_oak_leaves"},
			}
		}
	},
	sounds = default.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})

-----------
-- Fence --
-----------

-- Grave Oak Wood Fence --

default.register_fence("grave:fence_grave_oak_wood", {
	description = "Grave Oak Wood Fence",
	texture = "grave_fence_grave_oak_wood.png",
	inventory_image = "default_fence_overlay.png^grave_grave_oak_wood.png^" ..
				"default_fence_overlay.png^[makealpha:255,126,126",
	wield_image = "default_fence_overlay.png^grave_grave_oak_wood.png^" ..
				"default_fence_overlay.png^[makealpha:255,126,126",
	material = "grave:grave_oak_wood",
	groups = {choppy = 3, oddly_breakable_by_hand = 2, flammable = 3},
	sounds = default.node_sound_wood_defaults()
})

-- Grave Oak Wood Fence Rail --

default.register_fence_rail("grave:fence_rail_grave_oak_wood", {
	description = "Grave Oak Wood Fence Rail",
	texture = "grave_fence_rail_grave_oak_wood.png",
	inventory_image = "default_fence_rail_overlay.png^grave_grave_oak_wood.png^" ..
				"default_fence_rail_overlay.png^[makealpha:255,126,126",
	wield_image = "default_fence_rail_overlay.png^grave_grave_oak_wood.png^" ..
				"default_fence_rail_overlay.png^[makealpha:255,126,126",
	material = "grave:grave_oak_wood",
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2},
	sounds = default.node_sound_wood_defaults()
})

--------------------
-- Advanced Nodes --
--------------------

-- Phantom Chest --

minetest.register_node("grave:phantom_chest", {
	description = "Phantom Chest",
	tiles = {"grave_phantom_chest.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "mesh",
	mesh = "grave_phantom_chest.obj",
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
	light_source = 1,
	on_construct = function(pos, itemstack)
			local meta = minetest.get_meta(pos)
			meta:set_string("formspec",
			        "size[8,7]"..
					"list[current_name;main;3.5,0.5;1,1;]"..
					"list[current_player;main;0,3;8,4;]")
			local inv = meta:get_inventory()
			local items = {'default:coal_lump 4', 'default:gold_lump 3', 'grave:phantom_diamond', 'default:apple 3', 'default:coal_lump 7', 'default:gold_lump 2', 'grave:phantom_diamond 2', 'default:apple 5'}
			inv:set_size("main", 8*7)
			local IStack = ItemStack(items[math.random(1, #items)])
			inv:add_item( 'main', IStack )
	end,
	on_metadata_inventory_take = function(pos)
		minetest.remove_node(pos)
		minetest.add_entity(pos, "grave:phantom")
		minetest.add_item(pos, "grave:grave_oak_wood 4")
		minetest.add_particlespawner(
			8,
			2,
			{x=pos.x-0.1, y=pos.y-0.25, z=pos.z-0.1}, -- minpos
			{x=pos.x+0.1, y=pos.y+0.25, z=pos.z+0.1}, -- maxpos
			{x=-0.2, y=-0.8, z=-0.2}, -- minvel
			{x=0, y=0.2, z=0}, -- maxvel
			{x=0,y=0,z=0}, -- minaccel
			{x=0,y=0,z=0}, -- maxaccel
			0.5, -- minexptime
			0.6, -- maxexptime
			1, -- minsize
			2, --  maxsize
			true,
			"grave_grave_dust.png"
		)
	end,
	after_dig_node = function()
		minetest.delete_particlespawner(1)
	end,
})

-- Cursed Gravestone --

minetest.register_node("grave:cursed_gravestone", {
	description = "Cursed Gravestone",
	tiles = {"grave_cursed_gravestone.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	drawtype = "mesh",
	mesh = "grave_cursed_gravestone.obj",
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
	light_source = 1,
	after_place_node = function(pos, placer, itemstack)
			local meta=minetest.get_meta(pos)
			meta:set_string("owner",placer:get_player_name())
			meta:set_string("infotext","A strange energy radiates from the grave...")
			minetest.add_particlespawner(
				8,
				0,
				{x=pos.x-0.1, y=pos.y-0.25, z=pos.z-0.1}, -- minpos
				{x=pos.x+0.1, y=pos.y+0.25, z=pos.z+0.1}, -- maxpos
				{x=-0.2, y=-0.8, z=-0.2}, -- minvel
				{x=0, y=0.2, z=0}, -- maxvel
				{x=0,y=0,z=0}, -- minaccel
				{x=0,y=0,z=0}, -- maxaccel
				0.5, -- minexptime
				0.6, -- maxexptime
				1, -- minsize
				2, --  maxsize
				true,
				"grave_grave_dust.png"
			)
	end,
	on_rightclick = function(pos, node, player, itemstack, pointed_thing)
			local owner=minetest.get_meta(pos):get_string("owner")
			local pos2={x=pos.x,y=2000+501+1+2,z=pos.z}
			if not minetest.is_protected(pos2, owner) then
				multidimensions.move(player,pos2)
			end
	end,
	after_dig_node = function()
		minetest.delete_particlespawner(1)
	end,
	drop = "grave:cursed_gravestone"
})