------------------
-- Spawn Schems -- v0.1
------------------

local modpath, modname = ...

-- Spawn Mansion --

minetest.register_node("grave:haunted_mansion", {drawtype="airlike",groups = {not_in_creative_inventory=1},})

minetest.register_lbm({
	name = "grave:haunted_mansion_lbm",
	run_at_every_load = true,
	nodenames = {"grave:haunted_mansion"},
	action = function(pos, node)
		minetest.set_node(pos, {name = "air"})
		local mansion=""
		if node.name=="grave:haunted_mansion" then
			mansion=minetest.get_modpath("grave") .. "/schems/grave_haunted_mansion.mts"
		end
		minetest.place_schematic({x=pos.x+11,y=pos.y,z=pos.z+8}, mansion, "random", {}, true)
	end,
})

minetest.register_node("grave:mansion_chest_abm", {drawtype="airlike",groups = {not_in_creative_inventory=1,},paramtype="facedir",})

minetest.register_abm({
	nodenames = {"grave:mansion_chest_abm"},
	interval = 1,
	chance = 1,
	action = function(pos, node, active_object_count, active_object_count_wider)
		minetest.set_node(pos, {name="default:chest"})
		local items = {'default:coal_lump 4', 'default:gold_lump 3', 'grave:phantom_diamond', 'default:apple 3', 'default:coal_lump 7', 'default:gold_lump 2', 'grave:phantom_diamond 2', 'default:apple 5', 'default:mese_crystal', '', '', '', '', '', '', '', ''}
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		inv:add_item("main", items[math.random(1, #items)])
		inv:add_item("main", items[math.random(1, #items)])
		inv:add_item("main", items[math.random(1, #items)])
		inv:add_item("main", items[math.random(1, #items)])
		inv:add_item("main", items[math.random(1, #items)])
		inv:add_item("main", items[math.random(1, #items)])
	end,
})

-- Spawn Ruins --

minetest.register_node("grave:stone_ruins", {drawtype="airlike",groups = {not_in_creative_inventory=1},})

minetest.register_lbm({
	name = "grave:stone_ruins_lbm",
	run_at_every_load = true,
	nodenames = {"grave:stone_ruins"},
	action = function(pos, node)
		minetest.set_node(pos, {name = "air"})
		local ruins=""
		if node.name=="grave:stone_ruins" then
			ruins=minetest.get_modpath("grave") .. "/schems/grave_stone_ruins.mts"
		end
		minetest.place_schematic({x=pos.x,y=pos.y,z=pos.z}, ruins, "random", {}, true)
	end,
})

minetest.register_abm({
	nodenames = {"grave:stone_ruins"},
	interval = 4,
	chance = 1,
	action = function(pos, node)
		minetest.set_node(pos, {name="air"}) -- If they stay for too long, get rid of them
	end,
})

-- Spawn Trees --

minetest.register_node("grave:grave_oak", {drawtype="airlike",groups = {not_in_creative_inventory=1},})

minetest.register_lbm({
	name = "grave:grave_oak_lbm",
	run_at_every_load = true,
	nodenames = {"grave:grave_oak"},
	action = function(pos, node)
		minetest.set_node(pos, {name = "air"})
		local tree=""
		if node.name=="grave:grave_oak" then
			tree=minetest.get_modpath("grave") .. "/schems/grave_grave_oak.mts"
		end
		minetest.place_schematic({x=pos.x-2,y=pos.y,z=pos.z-2}, tree, "random", {}, true)
	end,
})

minetest.register_abm({
	nodenames = {"grave:grave_oak"},
	interval = 4,
	chance = 1,
	action = function(pos, node)
		minetest.set_node(pos, {name="air"}) -- If they stay for too long, get rid of them
	end,
})

-- Spawn Phantom Chest --

minetest.register_node("grave:phantom_chest_abm", {drawtype="airlike",groups = {not_in_creative_inventory=1},})

minetest.register_abm({
	nodenames = {"grave:phantom_chest_abm"},
	interval = 1,
	chance = 1,
	action = function(pos, node)
		minetest.set_node(pos, {name="grave:phantom_chest", param2 = minetest.dir_to_facedir({x=0,y=0,z=-1})})
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec",
		        "size[8,7]"..
				"list[current_name;main;3.5,0.5;1,1;]"..
				"list[current_player;main;0,3;8,4;]")
		local inv = meta:get_inventory()
		local items = {'default:coal_lump 4', 'default:gold_lump 3', 'grave:phantom_diamond', 'default:apple 3', 'default:coal_lump 7', 'default:gold_lump 2', 'grave:phantom_diamond 2', 'default:apple 5'}
		inv:set_size("main", 8*7)
		local IStack = ItemStack(items[math.random(1, #items)])
		inv:add_item( 'main', IStack )
	end,
})

-- Spawn Headstones --

minetest.register_node("grave:headstone1", {drawtype="airlike",groups = {not_in_creative_inventory=1},})
minetest.register_node("grave:headstone2", {drawtype="airlike",groups = {not_in_creative_inventory=1},})

minetest.register_lbm({
	name = "grave:headstone_lbm",
	run_at_every_load = true,
	nodenames = {"grave:headstone1","grave:headstone2"},
	action = function(pos, node)
		minetest.set_node(pos, {name = "air"})
		local headstone=""
		if node.name=="grave:headstone1" then
           headstone=minetest.get_modpath("grave") .. "/schems/grave_headstone1.mts"
        elseif node.name=="grave:headstone2" then
            headstone=minetest.get_modpath("grave") .. "/schems/grave_headstone2.mts"
		end
		minetest.place_schematic({x=pos.x+1,y=pos.y,z=pos.z}, headstone, "random", {}, true)
	end,
})

-- Spawn Rocks --

minetest.register_node("grave:rock", {drawtype="airlike",groups = {not_in_creative_inventory=1},})

minetest.register_lbm({
	name = "grave:rock_lbm",
	run_at_every_load = true,
	nodenames = {"grave:rock"},
	action = function(pos, node)
		minetest.set_node(pos, {name = "air"})
		local rock=""
		if node.name=="grave:rock" then
			rock=minetest.get_modpath("grave") .. "/schems/grave_rock.mts"
		end
		minetest.place_schematic({x=pos.x-2,y=pos.y-1,z=pos.z-2}, rock, "random", {}, true)
	end,
})