grave = {}

local modname = "grave"
local modpath = minetest.get_modpath(modname)

assert(loadfile(modpath .. "/dimension.lua"))(modpath, modname)
assert(loadfile(modpath .. "/craftitems.lua"))(modpath, modname)
assert(loadfile(modpath .. "/mobs/lich.lua"))(modpath, modname)
assert(loadfile(modpath .. "/mobs/skeleton.lua"))(modpath, modname)
assert(loadfile(modpath .. "/mobs/phantom.lua"))(modpath, modname)

function grave:register_spawn_egg(mob_ref, desc, col1, col2)

	local tex = "(mobs_chicken_egg.png^[colorize:#"..col1..")^(mobs_chicken_egg_overlay.png^[colorize:#"..col2..")"

	minetest.register_craftitem("grave:spawn_".. mob_ref .."", {
		description = "Spawn ".. desc .."",
		inventory_image = tex,
		stack_max = 99,
		on_place = function(itemstack, placer, pointed_thing)

			local pos = minetest.get_pointed_thing_position(pointed_thing, true)

			local spawn_pos = { 
				x = pos.x,
				y = pos.y + 2,
				z = pos.z,
			}

            minetest.add_entity(spawn_pos, "grave:".. mob_ref .."")
            if not creative then
                itemstack:take_item()
			    return itemstack
			end
		end,
	})
end

grave:register_spawn_egg("skeleton", "Skeleton", "f4f4f4" ,"d6d6d6")
grave:register_spawn_egg("lich", "Lich", "f4f4f4" ,"ae77bd")
grave:register_spawn_egg("phantom", "Phantom", "cebbce" ,"b2a6b2")
