local modpath, modname = ...

mobs:register_arrow("grave:lich_orb", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"grave_lich_orb.png"},
	collisionbox = {-0.1, -0.1, -0.1, 0.1, 0.1, 0.1},
	velocity = 7,
	tail = 1,
	tail_texture = "grave_grave_dust.png",
	tail_size = 10,
	glow = 5,
	expire = 0.1,

	on_activate = function(self, staticdata, dtime_s)
		self.object:set_armor_groups({immortal = 1, fleshy = 100})
        end,

	hit_player = function(self, player)
		player:punch(self.object, 1.0, {
			full_punch_interval = 1.0,
			damage_groups = {fleshy = 18},
                }, nil)
                local pos = self.object:get_pos()

                local pos1 = {
                        x = pos.x + 1,
                        y = pos.y,
                        z = pos.z + 1,
                }

                local pos2 = {
                        x = pos.x + 1,
                        y = pos.y,
                        z = pos.z + 2,
                }

                local pos3 = {
                        x = pos.x + 2,
                        y = pos.y,
                        z = pos.z + 1,
                }

                minetest.add_entity(pos1, "grave:skeleton")
                minetest.add_entity(pos2, "grave:skeleton")
                minetest.add_entity(pos3, "grave:skeleton")
	end,

	hit_mob = function(self, player)
		player:punch(self.object, 1.0, {
			full_punch_interval = 1.0,
			damage_groups = {fleshy = 28},
                }, nil)
                local pos = self.object:get_pos()

                local pos1 = {
                        x = pos.x + 1,
                        y = pos.y,
                        z = pos.z + 1,
                }

                local pos2 = {
                        x = pos.x + 1,
                        y = pos.y,
                        z = pos.z + 2,
                }

                local pos3 = {
                        x = pos.x + 2,
                        y = pos.y,
                        z = pos.z + 1,
                }

                minetest.add_entity(pos1, "grave:skeleton")
                minetest.add_entity(pos2, "grave:skeleton")
                minetest.add_entity(pos3, "grave:skeleton")
	end,

	-- node hit
	hit_node = function(self, pos, node)

                local pos1 = {
                        x = pos.x + 1,
                        y = pos.y,
                        z = pos.z + 1,
                }

                local pos2 = {
                        x = pos.x + 1,
                        y = pos.y,
                        z = pos.z + 2,
                }

                local pos3 = {
                        x = pos.x + 2,
                        y = pos.y,
                        z = pos.z + 1,
                }

                minetest.add_entity(pos1, "grave:skeleton")
                minetest.add_entity(pos2, "grave:skeleton")
                minetest.add_entity(pos3, "grave:skeleton")
	end
})

-- Lich

mobs:register_mob("grave:lich", {
        type =  "monster",
        hp_min = 20,
        hp_max = 20,
        armor = 120,
        passive = false,
        walk_velocity = 2,
        run_velocity = 4,
        stand_chance = 60,
        walk_chance = 40,
        jump = true,
        jump_height = 2.1,
        stepheight = 1.1,
        view_range = 18,
        knock_back = true,
        fear_height = 10,
        fall_damage = 1,
        water_damage = 0,
        lava_damage = 5,
        light_damage = 0,
        suffocation = true,
        floats = 1,
        reach = 2,
        attack_animals = false,
        attack_npcs = true,
        attack_players = true,
        group_attack = true,
        attack_type = "shoot",
	arrow = "grave:lich_orb",
	reach = 1,
	shoot_interval = 4,
        blood_amount = 0,
        pathfinding = 1,
        makes_footstep_sound = true,
	drops = {
		{name = "bonemeal:bone", chance = 1, min = 1, max = 6},
	},
        visual = "mesh",
        visual_size = {x = 1, y = 1},
        collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	textures = {
		{"grave_lich.png", "grave_lich.png"},
	},
        mesh = "grave_lich.b3d",
	animation = {
		speed_normal = 15,
		speed_sprint = 20,
		stand_start = 1,
		stand_end = 20,
		walk_start = 30,
		walk_end = 50,
		run_start = 30,
		run_end = 50,
		punch_start = 90,
		punch_end = 100,
	},
})

mobs:spawn({
	name = "grave:lich",
	nodes = "grave:grave_dirt_with_grave_grass",
        neighbours = "default:dry_shrub",
	min_light = 1,
	interval = 15,
	chance = 450,
	min_height = 2000,
	max_height = 2999,
	day_toggle = nil,
})
