local modpath, modname = ...

-- Skeleton

mobs:register_mob("grave:skeleton", {
        type =  "monster",
        hp_min = 20,
        hp_max = 20,
        armor = 120,
        passive = false,
        walk_velocity = 2,
        run_velocity = 4,
        stand_chance = 60,
        walk_chance = 40,
        jump = true,
        jump_height = 2.1,
        stepheight = 1.1,
        view_range = 18,
        damage = 6,
        knock_back = true,
        fear_height = 10,
        fall_damage = 1,
        water_damage = 0,
        lava_damage = 5,
        light_damage = 0,
        suffocation = true,
        floats = 1,
        reach = 2,
        attack_animals = false,
        attack_npcs = true,
        attack_players = true,
        group_attack = true,
        attack_type = "dogfight",
        blood_amount = 0,
        pathfinding = 1,
        makes_footstep_sound = true,
	drops = {
		{name = "bonemeal:bone", chance = 1, min = 1, max = 6},
	},
        visual = "mesh",
        visual_size = {x = 1, y = 1},
        collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	textures = {
		{"grave_skeleton.png"},
	},
        mesh = "grave_skeleton.b3d",
	animation = {
		speed_normal = 15,
		speed_sprint = 20,
		stand_start = 1,
		stand_end = 20,
		walk_start = 30,
		walk_end = 50,
		run_start = 30,
		run_end = 50,
		punch_start = 90,
		punch_end = 100,
	},
})

mobs:spawn({
	name = "grave:skeleton",
	nodes = "grave:grave_dirt_with_grave_grass",
        neighbours = "default:dry_shrub",
	min_light = 1,
	interval = 10,
	chance = 100,
	min_height = 2000,
	max_height = 2999,
	day_toggle = nil,
})
