---------------
-- Dimension -- v0.1
---------------

multidimensions.clear_dimensions() -- clear all dimensions

local modpath, modname = ...

assert(loadfile(modpath .. "/nodes.lua"))(modpath, modname)

assert(loadfile(modpath .. "/spawn_schems.lua"))(modpath, modname)

-- The Grave

multidimensions.register_dimension("the_grave",{

   ground_ores = {
   ["default:dry_shrub"] = 32,
   ["grave:grave_oak"] = 512,
   ["grave:rock"] = 5500,
   ["grave:headstone1"] = 11000,
   ["grave:headstone2"] = 11000,
   ["grave:stone_ruins"] = 65000,
   ["grave:haunted_mansion"] = 65000,
   },
   stone_ores = {},     	     -- works as above, but in stone
   dirt_ores = {},
   grass_ores = {},
   air_ores = {},
   water_ores = {},
   sand_ores = {},
   
   self = {},		    -- can contain everything, var like dirt="default:dirt" will be remade to dirt=content_id
   
   dim_y = 2000,             -- dimension start (don't change if you don't know what you're doing)
   dim_height =  999,	    -- dimension height
   
   
   dirt_start = 501,           -- when dirt begins to appear (default is 501)
   dirt_depth = 3,	    -- dirt depth
   ground_limit = 530,	    -- ground y limit (ground ends here)
   water_depth = 8,	    -- depth fron ground and down
   enable_water = false,       -- (nil = true)
   terrain_density = 0.4,    -- or ground density
   flatland = nil,           -- (nil = false)
   teleporter = false,         -- (nil = true) dimension teleporter
   gravity = 1,		    -- (1 = default) dimension gravity
   
   stone = "default:stone",
   dirt = "grave:grave_dirt",
   grass = "grave:grave_dirt_with_grave_grass",
   air = "air",
   water = nil,
   sand = "grave:grave_dirt",
   bedrock = "multidimensions:bedrock", -- at dimension edges
   
   map = {
      offset = 0,
      scale = 1,
      spread = {x=100,y=18,z=100},
      seeddiff = 1,
      octaves = 1,
      persist = 1.3,
      lacunarity = 0.1,
      flags = "absvalue",
    },
    
    sky = {{r=64, g=56, b=64},"plain",{}}, -- same as:set_sky()
    
    on_enter=function(player) --on enter dimension
    end,
    
    on_leave=function(player) --on leave dimension
    end,
    
 })