# 🔮 Runethera - Rune Magic System

A comprehensive magic system for Minetest/Luanti where you build custom spells by combining runes!

## ✨ Features

- **50+ Effects:** Damage, healing, teleportation, explosions, and more
- **13 Triggers:** Projectiles, touch, traps, AoE, ground slam, and more  
- **15 Powerups:** Amplify, split, pierce, homing, multicast, and more
- **Custom Spell Building:** Combine runes to create unique spells
- **Balance System:** OP combinations cost more mana/cooldown
- **Progressive Unlocking:** Craft runes to unlock them permanently
- **Mana System:** Regenerating mana with cooldowns
- **Tutorial:** Built-in tutorial book for new players

## 🎮 Quick Start

1. **Join Game:** Tutorial appears automatically
2. **Craft Runes:** Use stone, steel, mese, etc.
3. **Unlock:** Left-click on crafted runes to unlock permanently
4. **Build Spell:** `/spellbook` → Select runes → Build spell
5. **Cast:** Left-click with spellbook to cast!

## 📖 Example Spells

```
projectile + damage
→ Basic magic missile

projectile + explosion + amplify
→ Powerful explosive projectile

gravity_burst + meteor
→ 5 meteors at 5 locations!

projectile + damage + split + split
→ 1 projectile splits into 8!

trap + poison + amplify
→ Powerful poison trap
```

## ⚖️ Balance System

**Duplicate Penalty:**
- Same rune 2× = 1.5× cost
- Same rune 3× = 2.0× cost

**OP Combinations:**
- pierce + meteor = 4× mana, 3× cooldown
- multicast + meteor = 5× mana, 4× cooldown
- See BALANCE.md for all combinations

## 🔧 Installation

1. Download `runethera.zip`
2. Extract to `mods/runethera/` 
3. Enable mod in world settings
4. Start playing!

## 📦 Dependencies

**Required:**
- default
- fire

**Optional:**
- tnt (for explosions)
- farming (for harvest spell)
- everness (for alternative crafting)
- mobs_animal (for summon spells)

## 🎯 Commands

- `/spellbook` - Open spellbook
- `/tutorialbook` - View tutorial again
- `/runehelp` - Show help

## 🌍 Translations

- English (en)
- German (de)

## 📋 TODO

See TODO.md for planned features and known issues.

## 📄 License

MIT License - See LICENSE.txt for details.

Textures: CC BY-SA 4.0

## 🤝 Contributing

Contributions welcome! Please:
1. Test your changes thoroughly
2. Follow existing code style
3. Document new features
4. Update BALANCE.md for new spells

## 🐛 Bug Reports

Report bugs with:
- Minetest/Luanti version
- Mod version
- Steps to reproduce
- Error messages (from debug.txt)

## 🎓 Credits

Created with assistance from Claude (Anthropic)

Special thanks to Minetest/Luanti community and all contributors!

---

**Enjoy creating your own magical spells!** 🔮✨
