# RUNETHERA - TODO LIST

## ✅ COMPLETED
1. Spellbook PNG over buttons
2. Trap is 2D (wallmounted)
3. Tree feller drops items
4. Code cleanup (English comments)
5. Translations (DE + EN)

## 🚧 IN PROGRESS

### Verzögerung (Delay System)
**Status:** Particles work, but delay doesn't affect next effect
**Need:** Rewrite spell execution to support effect chains with delays
**Workaround:** Use separate spells for now

### Mobs drop items
**Status:** Entities killed by spells don't drop loot
**Fix needed:** Hook into mob death event to trigger item drops

### Blocks drop when destroyed
**Status:** dig/break_block remove nodes but don't drop items
**Fix needed:** Call minetest.get_node_drops() before remove_node()

## 📋 TODO

### More Triggers
Current: 13 triggers
Planned: 20+ triggers
- ricochet (bounces off walls)
- delayed_projectile
- on_death (triggers when caster dies)
- on_damage_taken
- proximity (triggers near entities)

### Everness Integration - ALL Items
Current: 5 recipes
Needed: 50+ recipes using Everness blocks

### Build Effect Fix
**Bug:** Build doesn't place blocks correctly
**Fix:** Check wielded item, verify node definition

### Function Documentation
**Status:** Some functions documented
**Need:** Every function with:
- Purpose
- Parameters
- Return value
- Example usage

## 🎯 PRIORITY

1. **HIGH:** Blocks drop items (breaks game feel)
2. **HIGH:** Mobs drop loot (same issue)
3. **MEDIUM:** More triggers (adds variety)
4. **MEDIUM:** Build fix (core feature)
5. **LOW:** Delay system (complex, has workaround)
6. **LOW:** Full Everness integration
7. **LOW:** Complete documentation

## 📝 NOTES

### Delay System Design
```
Spell: meteor + wait_delay + meteor + wait_delay + meteor

Execution:
1. meteor() → BOOM
2. wait_delay(1) → Store delay=1
3. minetest.after(1, meteor()) → BOOM (1s later)
4. wait_delay(1) → Store delay=1
5. minetest.after(1, meteor()) → BOOM (1s later)
```

Needs: Effect chain executor that processes delays

### Item Drop Helper
```lua
local function safe_drop_items(pos, node_name, tool)
    local drops = minetest.get_node_drops(node_name, tool or "")
    for _, item in ipairs(drops) do
        minetest.add_item(pos, item)
    end
    minetest.remove_node(pos)
end
```

Add to all destruction effects!
