-- Crafting-Rezepte für Runethera
-- Everness-Kompatibilität (Mod heißt "Everness" mit großem E!)
local evernes = minetest.get_modpath("Everness") ~= nil

-- Hilfsfunktion: Item je nach verfügbarer Mod wählen
local function item(default_item, evernes_item)
    if evernes and evernes_item then
        return evernes_item
    end
    return default_item
end

-- PAPIER-UNTERLAGEN (Voraussetzung für Runen-Crafting)

-- Auslöser-Papier
minetest.register_craftitem("runethera:paper_trigger", {
    description = "Auslöser-Papier\nUnterlage für Auslöser-Runen",
    inventory_image = "runethera_paper_trigger.png",
    stack_max = 16,
    groups = {rune_paper = 1},
})

minetest.register_craft({
    output = "runethera:paper_trigger 3",
    recipe = {
        {"default:paper", "default:paper", "default:paper"},
        {"default:paper", item("default:diamond", "evernes:magic_gem"), "default:paper"},
        {"default:paper", "default:paper", "default:paper"},
    }
})

-- Effekt-Papier
minetest.register_craftitem("runethera:paper_effect", {
    description = "Effekt-Papier\nUnterlage für Effekt-Runen",
    inventory_image = "runethera_paper_effect.png",
    stack_max = 16,
    groups = {rune_paper = 1},
})

minetest.register_craft({
    output = "runethera:paper_effect 3",
    recipe = {
        {"default:paper", "default:paper", "default:paper"},
        {"default:paper", item("default:mese_crystal", "evernes:essence_crystal"), "default:paper"},
        {"default:paper", "default:paper", "default:paper"},
    }
})

-- Powerup-Papier
minetest.register_craftitem("runethera:paper_powerup", {
    description = "Powerup-Papier\nUnterlage für Powerup-Runen",
    inventory_image = "runethera_paper_powerup.png",
    stack_max = 16,
    groups = {rune_paper = 1},
})

minetest.register_craft({
    output = "runethera:paper_powerup 3",
    recipe = {
        {"default:paper", "default:paper", "default:paper"},
        {"default:paper", item("default:gold_ingot", "evernes:gold_essence"), "default:paper"},
        {"default:paper", "default:paper", "default:paper"},
    }
})

-- Customizable-Papier
minetest.register_craftitem("runethera:paper_custom", {
    description = "Anpassungs-Papier\nUnterlage für spezielle Runen",
    inventory_image = "runethera_paper_custom.png",
    stack_max = 16,
    groups = {rune_paper = 1},
})

minetest.register_craft({
    output = "runethera:paper_custom 3",
    recipe = {
        {"default:paper", "default:paper", "default:paper"},
        {"default:paper", item("default:obsidian_shard", "evernes:void_shard"), "default:paper"},
        {"default:paper", "default:paper", "default:paper"},
    }
})

-- Papier-Typ pro Runen-Typ
local rune_paper = {
    trigger = "runethera:paper_trigger",
    effect = "runethera:paper_effect",
    powerup = "runethera:paper_powerup",
    customizable = "runethera:paper_custom",
}

-- RUNEN CRAFTEN (alle aus runen.conf)
-- Rezepte werden automatisch nach dem Laden der Runen registriert

-- Runen-Rezept-Definitionen (Material basierend auf Funktion)
local rune_recipes = {
    -- TRIGGER
    projectile   = {item("default:mese_crystal_fragment","evernes:spark"), item("default:stick",""), item("default:mese_crystal_fragment","evernes:spark")},
    self         = {item("default:gold_lump","evernes:life_essence"), "", ""},
    touch        = {item("default:steel_ingot","evernes:iron_rune"), item("default:steel_ingot","evernes:iron_rune"), ""},
    trap         = {item("default:mese_crystal_fragment","evernes:spark"), item("default:obsidian_shard","evernes:void_shard"), item("default:mese_crystal_fragment","evernes:spark")},
    aoe          = {item("default:mese_crystal","evernes:essence_crystal"), item("default:diamond",""), item("default:mese_crystal","evernes:essence_crystal")},
    beam         = {item("default:diamond","evernes:magic_gem"), item("default:mese_crystal","evernes:essence_crystal"), item("default:diamond","evernes:magic_gem")},
    orbit        = {item("default:diamond","evernes:magic_gem"), item("default:gold_ingot","evernes:gold_essence"), item("default:diamond","evernes:magic_gem")},
    chain        = {item("default:steel_ingot","evernes:iron_rune"), item("default:mese_crystal","evernes:essence_crystal"), item("default:steel_ingot","evernes:iron_rune")},
    rain         = {item("default:mese_crystal","evernes:essence_crystal"), item("default:diamond","evernes:magic_gem"), item("default:mese_crystal","evernes:essence_crystal")},
    wall         = {item("default:stone",""), item("default:mese_crystal","evernes:essence_crystal"), item("default:stone","")},
    cone         = {item("default:mese_crystal_fragment","evernes:spark"), item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal_fragment","evernes:spark")},
    burst        = {item("default:mese_crystal_fragment","evernes:spark"), item("default:mese_crystal_fragment","evernes:spark"), item("default:mese_crystal_fragment","evernes:spark")},
    delayed      = {item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal","evernes:essence_crystal"), ""},
    rune_circle  = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    flurry       = {item("default:feather","evernes:wind_essence"), item("default:diamond","evernes:magic_gem"), item("default:feather","evernes:wind_essence")},
    spiral       = {item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_ingot","evernes:gold_essence"), item("default:mese_crystal","evernes:essence_crystal")},
    ground_slam  = {item("default:stone",""), item("default:mese","evernes:raw_mana"), item("default:stone","")},
    snipe        = {item("default:diamond","evernes:magic_gem"), item("default:feather","evernes:wind_essence"), ""},
    scatter      = {item("default:mese_crystal_fragment","evernes:spark"), item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal_fragment","evernes:spark")},
    blink_cast   = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    -- EFFECTS - Schaden
    damage         = {item("default:obsidian_shard","evernes:void_shard"), item("default:diamond","evernes:magic_gem"), ""},
    heavy_damage   = {item("default:diamond","evernes:magic_gem"), item("default:obsidian_shard","evernes:void_shard"), item("default:diamond","evernes:magic_gem")},
    true_damage    = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    lifesteal      = {item("default:gold_ingot","evernes:gold_essence"), item("default:obsidian_shard","evernes:void_shard"), item("default:gold_ingot","evernes:gold_essence")},
    execute        = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese","evernes:raw_mana"), item("default:obsidian_shard","evernes:void_shard")},
    smite          = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    lightning      = {item("default:diamond","evernes:magic_gem"), item("default:mese_crystal","evernes:essence_crystal"), item("default:diamond","evernes:magic_gem")},
    explosion      = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese","evernes:raw_mana"), item("default:obsidian_shard","evernes:void_shard")},
    chain_lightning= {item("default:diamond","evernes:magic_gem"), item("default:mese_crystal","evernes:essence_crystal"), item("default:steel_ingot","evernes:iron_rune")},
    shockwave      = {item("default:steel_ingot","evernes:iron_rune"), item("default:mese","evernes:raw_mana"), item("default:steel_ingot","evernes:iron_rune")},
    meteor         = {item("default:diamond","evernes:magic_gem"), item("default:obsidian_shard","evernes:void_shard"), item("default:diamond","evernes:magic_gem")},
    void_blast     = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese","evernes:raw_mana"), item("default:obsidian_shard","evernes:void_shard")},
    -- EFFECTS - Feuer/Eis/Gift
    ignite         = {item("default:lava_source","evernes:fire_essence"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    freeze         = {item("default:ice","evernes:frost_shard"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    poison         = {item("default:cactus","evernes:poison_herb"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    burn           = {item("default:lava_source","evernes:fire_essence"), item("default:mese_crystal","evernes:essence_crystal"), item("default:lava_source","evernes:fire_essence")},
    blizzard       = {item("default:ice","evernes:frost_shard"), item("default:mese","evernes:raw_mana"), item("default:ice","evernes:frost_shard")},
    acid           = {item("default:cactus","evernes:poison_herb"), item("default:mese_crystal","evernes:essence_crystal"), item("default:cactus","evernes:poison_herb")},
    frostbite      = {item("default:ice","evernes:frost_shard"), item("default:obsidian_shard","evernes:void_shard"), ""},
    place_fire     = {item("default:flint","evernes:fire_essence"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    -- EFFECTS - Heilung
    heal           = {item("default:gold_ingot","evernes:gold_essence"), item("default:mese_crystal","evernes:essence_crystal"), ""},
    strong_heal    = {item("default:gold_ingot","evernes:gold_essence"), item("default:mese","evernes:raw_mana"), item("default:gold_ingot","evernes:gold_essence")},
    regenerate     = {item("default:gold_ingot","evernes:gold_essence"), item("default:gold_ingot","evernes:gold_essence"), ""},
    cleanse        = {item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal","evernes:essence_crystal"), ""},
    revive         = {item("default:gold_ingot","evernes:gold_essence"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    mana_restore   = {item("default:mese_crystal_fragment","evernes:spark"), item("default:mese_crystal","evernes:essence_crystal"), ""},
    -- EFFECTS - Bewegung
    speed          = {item("default:feather","evernes:wind_essence"), item("default:gold_lump","evernes:life_essence"), ""},
    slow           = {item("default:ice","evernes:frost_shard"), item("default:obsidian_shard","evernes:void_shard"), ""},
    levitate       = {item("default:feather","evernes:wind_essence"), item("default:mese_crystal","evernes:essence_crystal"), ""},
    teleport       = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    dash           = {item("default:feather","evernes:wind_essence"), item("default:diamond","evernes:magic_gem"), item("default:feather","evernes:wind_essence")},
    pull           = {item("default:steel_ingot","evernes:iron_rune"), item("default:gold_lump","evernes:life_essence"), item("default:steel_ingot","evernes:iron_rune")},
    push           = {item("default:steel_ingot","evernes:iron_rune"), item("default:diamond","evernes:magic_gem"), item("default:steel_ingot","evernes:iron_rune")},
    knockback      = {item("default:steel_ingot","evernes:iron_rune"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    launch         = {item("default:steel_ingot","evernes:iron_rune"), item("default:mese","evernes:raw_mana"), ""},
    root           = {item("default:dirt","evernes:earth_rune"), item("default:mese_crystal_fragment","evernes:spark"), item("default:dirt","evernes:earth_rune")},
    swap           = {item("default:diamond","evernes:magic_gem"), item("default:gold_lump","evernes:life_essence"), item("default:diamond","evernes:magic_gem")},
    -- EFFECTS - Kontrolle
    blind          = {item("default:obsidian_shard","evernes:void_shard"), item("default:gold_lump","evernes:life_essence"), ""},
    wither         = {item("default:obsidian_shard","evernes:void_shard"), item("default:obsidian_shard","evernes:void_shard"), ""},
    stun           = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese_crystal","evernes:essence_crystal"), item("default:obsidian_shard","evernes:void_shard")},
    confuse        = {item("default:gold_lump","evernes:life_essence"), item("default:obsidian_shard","evernes:void_shard"), ""},
    silence_target = {item("default:obsidian_shard","evernes:void_shard"), item("default:gold_ingot","evernes:gold_essence"), ""},
    drain_mana     = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese_crystal","evernes:essence_crystal"), item("default:obsidian_shard","evernes:void_shard")},
    -- EFFECTS - Umgebung
    light          = {item("default:torch","evernes:light_crystal"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    break_block    = {item("default:pick_stone","evernes:earth_rune"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    grow           = {item("default:sapling","evernes:nature_seed"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    summon_wolf    = {item("default:bone","evernes:beast_rune"), item("default:mese_crystal","evernes:essence_crystal"), item("default:bone","evernes:beast_rune")},
    summon_golem   = {item("default:stone",""), item("default:mese","evernes:raw_mana"), item("default:stone","")},
    place_water    = {item("default:water_source","evernes:pure_water"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    quake          = {item("default:stone",""), item("default:mese","evernes:raw_mana"), item("default:cobble","")},
    -- EFFECTS - Sonstige
    mark           = {item("default:mese_crystal_fragment","evernes:spark"), item("default:gold_lump","evernes:life_essence"), ""},
    shield         = {item("default:steel_ingot","evernes:iron_rune"), item("default:gold_ingot","evernes:gold_essence"), item("default:steel_ingot","evernes:iron_rune")},
    mirror         = {item("default:glass",""), item("default:mese_crystal","evernes:essence_crystal"), item("default:glass","")},
    void_field     = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese","evernes:raw_mana"), item("default:obsidian_shard","evernes:void_shard")},
    empower        = {item("default:gold_ingot","evernes:gold_essence"), item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_ingot","evernes:gold_essence")},
    -- POWERUPS
    amplify        = {item("default:mese_crystal","evernes:essence_crystal"), item("default:mese_crystal","evernes:essence_crystal"), item("default:mese_crystal","evernes:essence_crystal")},
    duration       = {item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal_fragment","evernes:spark"), ""},
    split          = {item("default:diamond","evernes:magic_gem"), item("default:diamond","evernes:magic_gem"), ""},
    pierce         = {item("default:steel_ingot","evernes:iron_rune"), item("default:obsidian_shard","evernes:void_shard"), ""},
    bounce         = {item("default:stone",""), item("default:mese_crystal_fragment","evernes:spark"), ""},
    homing         = {item("default:diamond","evernes:magic_gem"), item("default:gold_lump","evernes:life_essence"), item("default:diamond","evernes:magic_gem")},
    range          = {item("default:mese_crystal","evernes:essence_crystal"), item("default:feather","evernes:wind_essence"), ""},
    cost_reduce    = {item("default:gold_ingot","evernes:gold_essence"), item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_ingot","evernes:gold_essence")},
    accelerate     = {item("default:feather","evernes:wind_essence"), item("default:mese_crystal_fragment","evernes:spark"), item("default:feather","evernes:wind_essence")},
    multicast      = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    chain_power    = {item("default:steel_ingot","evernes:iron_rune"), item("default:mese_crystal","evernes:essence_crystal"), ""},
    aoe_size       = {item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal","evernes:essence_crystal")},
    silence        = {item("default:obsidian_shard","evernes:void_shard"), item("default:gold_ingot","evernes:gold_essence"), ""},
    overcharge     = {item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana")},
    miniaturize    = {item("default:mese_crystal_fragment","evernes:spark"), item("default:gold_lump","evernes:life_essence"), ""},
    giant          = {item("default:mese_crystal","evernes:essence_crystal"), item("default:mese","evernes:raw_mana"), item("default:mese_crystal","evernes:essence_crystal")},
    ricochet       = {item("default:stone",""), item("default:mese_crystal_fragment","evernes:spark"), item("default:stone","")},
    twin           = {item("default:gold_lump","evernes:life_essence"), item("default:diamond","evernes:magic_gem"), item("default:gold_lump","evernes:life_essence")},
    sniper_scope   = {item("default:diamond","evernes:magic_gem"), item("default:feather","evernes:wind_essence"), item("default:diamond","evernes:magic_gem")},
    last_resort    = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    -- CUSTOMIZABLE
    fortune        = {item("default:gold_ingot","evernes:gold_essence"), item("default:diamond","evernes:magic_gem"), item("default:gold_ingot","evernes:gold_essence")},
    void           = {item("default:obsidian_shard","evernes:void_shard"), item("default:mese","evernes:raw_mana"), item("default:obsidian_shard","evernes:void_shard")},
    echo           = {item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal","evernes:essence_crystal")},
    gravity_field  = {item("default:stone","evernes:earth_rune"), item("default:mese","evernes:raw_mana"), item("default:stone","evernes:earth_rune")},
    time_slow      = {item("default:gold_ingot","evernes:gold_essence"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    soul_link      = {item("default:gold_lump","evernes:life_essence"), item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_lump","evernes:life_essence")},
    arcane_surge   = {item("default:mese_crystal","evernes:essence_crystal"), item("default:mese","evernes:raw_mana"), item("default:mese_crystal","evernes:essence_crystal")},
    nullify        = {item("default:obsidian_shard","evernes:void_shard"), item("default:diamond","evernes:magic_gem"), item("default:obsidian_shard","evernes:void_shard")},
    overload       = {item("default:mese","evernes:raw_mana"), item("default:mese","evernes:raw_mana"), item("default:mese","evernes:raw_mana")},
    transcend      = {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
}

-- Runen-Rezepte DIREKT registrieren (runes.lua wurde bereits geladen!)
-- Da crafting.lua NACH runes.lua geladen wird, sind runethera.runes bereits befüllt
for rune_name, rune_def in pairs(runethera.runes) do
    local paper = rune_paper[rune_def.type] or "runethera:paper_effect"
    local mats  = rune_recipes[rune_name] or {
        item("default:mese_crystal_fragment","evernes:spark"), "", ""
    }

    -- Leere Felder absichern
    for i = 1, 3 do
        if mats[i] == nil then mats[i] = "" end
    end

    -- Rezept: Materialien oben, Papier-Unterlage Mitte
    pcall(function()
        minetest.register_craft({
            output = "runethera:rune_" .. rune_name,
            recipe = {
                { mats[1], mats[2], mats[3] },
                { "",       paper,  ""       },
                { "",       "",     ""       },
            }
        })
    end)
end
minetest.log("action", "[Runethera] Alle Runen-Rezepte registriert!")

-- ZAUBERBUCH
minetest.register_craft({
    output = "runethera:spellbook",
    recipe = {
        {item("default:paper","evernes:magic_paper"), item("default:diamond","evernes:magic_gem"), item("default:paper","evernes:magic_paper")},
        {item("default:paper","evernes:magic_paper"), "default:book",                              item("default:paper","evernes:magic_paper")},
        {item("default:paper","evernes:magic_paper"), item("default:mese_crystal","evernes:essence_crystal"), item("default:paper","evernes:magic_paper")},
    }
})

-- MANA-ITEMS
minetest.register_craftitem("runethera:mana_potion", {
    description = "Mana-Trank\nStellt 50 Mana wieder her",
    inventory_image = "runethera_mana_potion.png",
    stack_max = 16,
    on_use = function(itemstack, player, pointed_thing)
        runethera.add_mana(player, 50)
        minetest.chat_send_player(player:get_player_name(), "+50 Mana!")
        itemstack:take_item()
        return itemstack
    end,
})
minetest.register_craft({
    output = "runethera:mana_potion 3",
    recipe = {
        {"", item("default:mese_crystal","evernes:essence_crystal"), ""},
        {"default:glass", item("default:water_source","evernes:pure_water"), "default:glass"},
        {"", item("default:mese_crystal_fragment","evernes:spark"), ""},
    }
})

-- UPGRADE-ITEMS

-- Mana-Kristall (+20 Max-Mana)
minetest.register_craftitem("runethera:mana_crystal", {
    description = "Mana-Kristall\n+20 Max-Mana",
    inventory_image = "runethera_mana_crystal.png",
    stack_max = 16,
    on_use = function(itemstack, player, pointed_thing)
        runethera.increase_max_mana(player, 20)
        local name = player:get_player_name()
        minetest.chat_send_player(name,
            "Max. Mana +20! Neues Maximum: " .. runethera.players[name].max_mana)
        itemstack:take_item()
        return itemstack
    end,
})
minetest.register_craft({
    output = "runethera:mana_crystal",
    recipe = {
        {item("default:diamond","evernes:magic_gem"),       item("default:mese_crystal","evernes:essence_crystal"), item("default:diamond","evernes:magic_gem")},
        {item("default:mese_crystal","evernes:essence_crystal"), item("default:mese","evernes:raw_mana"),          item("default:mese_crystal","evernes:essence_crystal")},
        {item("default:diamond","evernes:magic_gem"),       item("default:mese_crystal","evernes:essence_crystal"), item("default:diamond","evernes:magic_gem")},
    }
})

-- Regen-Boost (+0.5/s)
minetest.register_craftitem("runethera:regen_boost", {
    description = "Regenerations-Boost\n+0.5 Mana/Sekunde",
    inventory_image = "runethera_regen_boost.png",
    stack_max = 16,
    on_use = function(itemstack, player, pointed_thing)
        local name = player:get_player_name()
        local data = runethera.players[name]
        if data then
            data.mana_regen = data.mana_regen + 0.5
            runethera.save_player_data(name)
            minetest.chat_send_player(name,
                "Mana-Regen +0.5/s! Neue Rate: " .. data.mana_regen .. "/s")
            itemstack:take_item()
        end
        return itemstack
    end,
})
minetest.register_craft({
    output = "runethera:regen_boost",
    recipe = {
        {item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_ingot","evernes:gold_essence"), item("default:mese_crystal","evernes:essence_crystal")},
        {item("default:gold_ingot","evernes:gold_essence"),      "runethera:mana_crystal",                          item("default:gold_ingot","evernes:gold_essence")},
        {item("default:mese_crystal","evernes:essence_crystal"), item("default:gold_ingot","evernes:gold_essence"), item("default:mese_crystal","evernes:essence_crystal")},
    }
})

-- Runen-Slot Upgrade (+1 Runen-Slot, max 12)
minetest.register_craftitem("runethera:rune_slot_upgrade", {
    description = "Runen-Slot Upgrade\n+1 Runen-Slot (Max: 12)",
    inventory_image = "runethera_rune_upgrade.png",
    stack_max = 5,
    on_use = function(itemstack, player, pointed_thing)
        local name = player:get_player_name()
        local data = runethera.players[name]
        if data then
            if data.max_rune_slots < 12 then
                data.max_rune_slots = data.max_rune_slots + 1
                runethera.save_player_data(name)
                minetest.chat_send_player(name,
                    "Runen-Slot freigeschaltet! " .. data.max_rune_slots .. "/12")
                itemstack:take_item()
            else
                minetest.chat_send_player(name, "Maximum 12 Runen-Slots erreicht!")
            end
        end
        return itemstack
    end,
})
minetest.register_craft({
    output = "runethera:rune_slot_upgrade",
    recipe = {
        {item("default:diamond","evernes:magic_gem"),          item("default:diamond","evernes:magic_gem"),          item("default:diamond","evernes:magic_gem")},
        {item("default:mese_crystal","evernes:essence_crystal"), "default:book",                                     item("default:mese_crystal","evernes:essence_crystal")},
        {item("default:obsidian_shard","evernes:void_shard"),  item("default:obsidian_shard","evernes:void_shard"),   item("default:obsidian_shard","evernes:void_shard")},
    }
})

-- Zauber-Slot Upgrade (+1 Zauber-Slot, max 10)
minetest.register_craftitem("runethera:spell_slot_upgrade", {
    description = "Zauber-Slot Upgrade\n+1 Zauber-Slot (Max: 10)",
    inventory_image = "runethera_spell_upgrade.png",
    stack_max = 3,
    on_use = function(itemstack, player, pointed_thing)
        local name = player:get_player_name()
        local data = runethera.players[name]
        if data then
            if data.max_spell_slots < 10 then
                data.max_spell_slots = data.max_spell_slots + 1
                runethera.save_player_data(name)
                minetest.chat_send_player(name,
                    "Zauber-Slot freigeschaltet! " .. data.max_spell_slots .. "/10")
                itemstack:take_item()
            else
                minetest.chat_send_player(name, "Maximum 10 Zauber-Slots erreicht!")
            end
        end
        return itemstack
    end,
})
minetest.register_craft({
    output = "runethera:spell_slot_upgrade",
    recipe = {
        {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
        {item("default:mese","evernes:raw_mana"),     "runethera:spellbook",                   item("default:mese","evernes:raw_mana")},
        {item("default:diamond","evernes:magic_gem"), item("default:mese","evernes:raw_mana"), item("default:diamond","evernes:magic_gem")},
    }
})

print("[Runethera] Crafting-System geladen" .. (evernes and " (mit Evernes)" or " (Default-Items)"))

-- EVERNESS-INTEGRATION
-- Wenn Everness installiert ist, nutze Everness-Blöcke für Rezepte

if minetest.get_modpath("everness") then
    
    print("[Runethera] Everness gefunden - verwende Everness-Blöcke!")
    
    -- Alternative Rezepte mit Everness-Materialien
    
    -- Projektil-Rune mit Crystal
    minetest.register_craft({
        output = "runethera:rune_projectile",
        recipe = {
            {"everness:crystal_ore", "everness:crystal_ore", "everness:crystal_ore"},
            {"everness:crystal_ore", "default:mese_crystal", "everness:crystal_ore"},
            {"everness:crystal_ore", "everness:crystal_ore", "everness:crystal_ore"},
        }
    })
    
    -- Schaden-Rune mit Cursed Lands Material
    minetest.register_craft({
        output = "runethera:rune_damage",
        recipe = {
            {"everness:cursed_stone", "everness:cursed_stone", "everness:cursed_stone"},
            {"everness:cursed_stone", "default:steel_ingot", "everness:cursed_stone"},
            {"everness:cursed_stone", "everness:cursed_stone", "everness:cursed_stone"},
        }
    })
    
    -- Heilungs-Rune mit Coral
    minetest.register_craft({
        output = "runethera:rune_heal",
        recipe = {
            {"everness:coral_stone", "everness:coral_stone", "everness:coral_stone"},
            {"everness:coral_stone", "default:mese_crystal", "everness:coral_stone"},
            {"everness:coral_stone", "everness:coral_stone", "everness:coral_stone"},
        }
    })
    
    -- Feuer-Runen mit Volcanic Rock
    minetest.register_craft({
        output = "runethera:rune_ignite",
        recipe = {
            {"everness:volcanic_rock", "everness:volcanic_rock", "everness:volcanic_rock"},
            {"everness:volcanic_rock", "default:mese_crystal_fragment", "everness:volcanic_rock"},
            {"everness:volcanic_rock", "everness:volcanic_rock", "everness:volcanic_rock"},
        }
    })
    
    -- Eis-Runen mit Frosted Ice
    minetest.register_craft({
        output = "runethera:rune_freeze",
        recipe = {
            {"everness:frosted_ice", "everness:frosted_ice", "everness:frosted_ice"},
            {"everness:frosted_ice", "default:mese_crystal_fragment", "everness:frosted_ice"},
            {"everness:frosted_ice", "everness:frosted_ice", "everness:frosted_ice"},
        }
    })
    
    print("[Runethera] Everness-Rezepte registriert!")
end

