-- RUNETHERA - TRIGGER-EFFEKTE
-- Trigger bestimmen WIE der Zauber ausgelöst wird
-- Jeder Trigger gibt (typ, daten) zurück

runethera.effects = runethera.effects or {}

-- PROJECTILE: Feuert Projektil in Blickrichtung
runethera.effects.projectile = function(player, target, params)
    return "projectile", {}
end

-- SELF: Wirkt auf Spieler selbst
runethera.effects.self = function(player, target, params)
    return "self", {}
end

-- TOUCH: Wirkt auf angeklicktes Ziel
runethera.effects.touch = function(player, target, params)
    return "touch", {}
end

-- TRAP: Platziert Falle am Boden
runethera.effects.trap = function(player, target, params)
    return "trap", {}
end

-- AOE: Wirkt auf Bereich um Spieler
runethera.effects.aoe = function(player, target, params)
    local radius = params[1] or 5
    return "aoe", {radius=radius}
end

-- BEAM: Strahl in Blickrichtung
runethera.effects.beam = function(player, target, params)
    local length = params[1] or 20
    return "beam", {length=length}
end

-- ORBIT: Projektile kreisen um Spieler
runethera.effects.orbit = function(player, target, params)
    local count = params[1] or 3
    return "orbit", {count=count}
end

-- CHAIN: Springt von Ziel zu Ziel
runethera.effects.chain = function(player, target, params)
    local max_chains = params[1] or 3
    return "chain", {max_chains=max_chains}
end

-- RAIN: Projektile regnen von oben
runethera.effects.rain = function(player, target, params)
    local count = params[1] or 5
    return "rain", {count=count}
end

-- CONE: Kegel-förmiger Spray
runethera.effects.cone = function(player, target, params)
    local count = params[1] or 6
    return "cone", {count=count}
end

-- BURST: Projektile in alle Richtungen
runethera.effects.burst = function(player, target, params)
    local count = params[1] or 8
    return "burst", {count=count}
end

-- GROUND_SLAM: Schockwelle am Boden
runethera.effects.ground_slam = function(player, target, params)
    local radius = params[1] or 4
    return "ground_slam", {radius=radius}
end

-- WAIT: Verzögert Auslösung (wird in cast_spell behandelt)
runethera.effects.wait = function(player, target, params)
    local delay = params[1] or 2
    return "wait", {delay=delay}
end

print("[Runethera] Trigger-Effekte geladen")
