-- RUNETHERA - ENTITIES
-- Alle Entities die Effekte auslösen können

-- GRAVITY SHARD - Gravitations-Splitter mit Effekt-Auslösung
minetest.register_entity("runethera:gravity_shard", {
    initial_properties = {
        visual = "sprite",
        textures = {"runethera_particle_magic.png^[colorize:#b050ff:200"},
        visual_size = {x=0.6, y=0.6},
        collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
        physical = true,
        collide_with_objects = false,
        pointable = false,
        glow = 14,
    },
    
    -- Daten
    caster = nil,
    damage = 5,
    effects = {},  -- Liste von Effekten die ausgelöst werden
    spell_data = {},
    timer = 0,
    hit_ground = false,
    
    on_activate = function(self, staticdata)
        self.object:set_armor_groups({immortal=1})
        self.object:set_acceleration({x=0, y=-9.81, z=0})  -- Gravitation!
    end,
    
    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        
        -- Max. Lebensdauer
        if self.timer > 3 then
            self.object:remove()
            return
        end
        
        local pos = self.object:get_pos()
        if not pos then return end
        
        -- DISTANZ-CHECK: Stoppe nach max_distance Blöcken
        if self.start_pos and self.max_distance then
            local dist = vector.distance(self.start_pos, pos)
            if dist >= self.max_distance then
                -- ZIEL ERREICHT! EFFEKTE AUSLÖSEN!
                if self.caster and self.effects and #self.effects > 0 then
                    for _, eff_def in ipairs(self.effects) do
                        if eff_def and eff_def.on_cast then
                            -- Trigger effect at current position
                            eff_def.on_cast(self.caster, pos, {
                                effects = self.effects,
                                spell_data = self.spell_data or {}
                            })
                        end
                    end
                else
                    -- DEBUG: No effects passed, show warning particle
                    minetest.add_particle({
                        pos = pos,
                        velocity = {x=0, y=2, z=0},
                        expirationtime = 1.0,
                        size = 3,
                        texture = "runethera_particle_magic.png^[colorize:#ff0000:255",
                        glow = 14,
                    })
                end
                
                -- Partikel-Explosion
                minetest.add_particlespawner({
                    amount = 40,
                    time = 0.3,
                    minpos = vector.subtract(pos, 0.5),
                    maxpos = vector.add(pos, 0.5),
                    minvel = {x=-3, y=-3, z=-3},
                    maxvel = {x=3, y=3, z=3},
                    minexptime = 0.3,
                    maxexptime = 0.8,
                    minsize = 2,
                    maxsize = 4,
                    texture = "runethera_particle_magic.png^[colorize:#b050ff:200",
                    glow = 14,
                })
                
                minetest.sound_play("default_place_node", {pos=pos, gain=0.6, pitch=1.2}, true)
                self.object:remove()
                return
            end
        end
        
        -- Spur-Partikel
        if math.random() < 0.5 then
            minetest.add_particle({
                pos = pos,
                velocity = {x=0, y=0, z=0},
                expirationtime = 0.5,
                size = 2,
                texture = "runethera_particle_magic.png^[colorize:#b050ff:200",
                glow = 12,
            })
        end
        
        -- BODEN-KOLLISION prüfen
        local below = {x=pos.x, y=pos.y-0.3, z=pos.z}
        local node = minetest.get_node(below)
        
        if node.name ~= "air" and node.name ~= "ignore" and not self.hit_ground then
            self.hit_ground = true
            
            -- EFFEKTE AUSLÖSEN! (mit korrekten params)
            if self.caster and self.effects then
                for _, eff_def in ipairs(self.effects) do
                    if eff_def.on_cast then
                        -- Löse Effekt am Aufprallpunkt aus
                        -- WICHTIG: Übergebe effects + spell_data für Chains!
                        eff_def.on_cast(self.caster, below, {
                            effects = self.effects,
                            spell_data = self.spell_data or {}
                        })
                    end
                end
            end
            
            -- Explosion-Partikel
            minetest.add_particlespawner({
                amount = 40,
                time = 0.3,
                minpos = vector.subtract(pos, 0.5),
                maxpos = vector.add(pos, 0.5),
                minvel = {x=-3, y=0, z=-3},
                maxvel = {x=3, y=4, z=3},
                minexptime = 0.3,
                maxexptime = 0.8,
                minsize = 1.5,
                maxsize = 3,
                texture = "runethera_particle_magic.png^[colorize:#b050ff:200",
                glow = 12,
            })
            
            minetest.sound_play("default_place_node", {pos=pos, gain=0.5, pitch=0.8}, true)
            self.object:remove()
            return
        end
        
        -- ENTITY-KOLLISION prüfen
        local objs = minetest.get_objects_inside_radius(pos, 0.8)
        for _, obj in ipairs(objs) do
            if obj ~= self.object and obj ~= self.caster then
                if obj:is_player() or (obj:get_luaentity() and 
                   obj:get_luaentity().name ~= "runethera:gravity_shard") then
                    
                    -- EFFEKTE auf Entity auslösen (mit korrekten params)
                    if self.caster and self.effects then
                        for _, eff_def in ipairs(self.effects) do
                            if eff_def.on_cast then
                                eff_def.on_cast(self.caster, obj, {
                                    effects = self.effects,
                                    spell_data = self.spell_data or {}
                                })
                            end
                        end
                    end
                    
                    -- Partikel
                    minetest.add_particlespawner({
                        amount = 25,
                        time = 0.2,
                        minpos = pos,
                        maxpos = pos,
                        minvel = {x=-2, y=-2, z=-2},
                        maxvel = {x=2, y=2, z=2},
                        minexptime = 0.2,
                        maxexptime = 0.5,
                        minsize = 1,
                        maxsize = 2,
                        texture = "runethera_particle_magic.png^[colorize:#b050ff:200",
                        glow = 10,
                    })
                    
                    self.object:remove()
                    return
                end
            end
        end
    end,
})

print("[Runethera] Entities geladen (gravity_shard)")

-- METEOR ENTITY - Fällt vom Himmel und explodiert
minetest.register_entity("runethera:meteor_entity", {
    initial_properties = {
        visual = "sprite",
        textures = {"runethera_meteor.png"},
        visual_size = {x=2, y=2},
        collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
        physical = false,  -- Not affected by physics/explosions
        collide_with_objects = false,
        pointable = false,
        glow = 14,
        makes_footstep_sound = false,
    },
    
    caster = nil,
    radius = 5,
    damage = 25,
    timer = 0,
    
    on_activate = function(self, staticdata)
        self.object:set_armor_groups({immortal=1})
        self.object:set_acceleration({x=0, y=-20, z=0})  -- Fällt schnell!
    end,
    
    on_step = function(self, dtime)
        self.timer = self.timer + dtime
        
        if self.timer > 10 then
            self.object:remove()
            return
        end
        
        local pos = self.object:get_pos()
        if not pos then return end
        
        -- Feuerspur
        if math.random() < 0.5 then
            minetest.add_particle({
                pos = pos,
                velocity = {x=math.random(-2,2), y=math.random(-1,1), z=math.random(-2,2)},
                expirationtime = 1.0,
                size = 4,
                texture = "runethera_particle_fire.png",
                glow = 14,
            })
        end
        
        -- BODEN-KOLLISION (sehr großzügige Prüfung!)
        -- Prüfe mehrere Punkte um Meteor herum
        local check_points = {
            {x=pos.x, y=pos.y-1, z=pos.z},     -- Direkt unten
            {x=pos.x, y=pos.y-2, z=pos.z},     -- 2 Blöcke unten
            {x=pos.x+1, y=pos.y-1, z=pos.z},   -- Seitlich
            {x=pos.x-1, y=pos.y-1, z=pos.z},
        }
        
        local should_explode = false
        
        -- Prüfe alle Punkte
        for _, p in ipairs(check_points) do
            local node = minetest.get_node(p)
            if node.name ~= "air" and node.name ~= "ignore" then
                should_explode = true
                break
            end
        end
        
        if pos.y < 0 then
            should_explode = true
        end
        
        -- ODER: Zu lange geflogen (Failsafe)
        if self.timer > 5 then
            should_explode = true
        end
        
        if should_explode then
            -- AUFPRALL! 2× TNT-EXPLOSION
            
            -- DOPPEL-EXPLOSION (GLEICHZEITIG!)
            if minetest.get_modpath("tnt") and tnt and tnt.boom then
                -- Erste Explosion
                tnt.boom(pos, {radius=self.radius, damage_radius=self.radius*2})
                -- Zweite Explosion (leicht versetzt, SOFORT)
                local pos2 = {x=pos.x+2, y=pos.y, z=pos.z+2}
                tnt.boom(pos2, {radius=self.radius, damage_radius=self.radius*2})
            else
                -- Fallback: Große Partikel-Explosion
                minetest.add_particlespawner({
                    amount = 600,
                    time = 1.0,
                    minpos = vector.subtract(pos, 5),
                    maxpos = vector.add(pos, 5),
                    minvel = {x=-15, y=-15, z=-15},
                    maxvel = {x=15, y=15, z=15},
                    minexptime = 0.5,
                    maxexptime = 2.0,
                    minsize = 4,
                    maxsize = 10,
                    texture = "runethera_particle_fire.png",
                    glow = 14,
                })
            end
            
            minetest.sound_play("tnt_explode", {pos=pos, gain=1.5, pitch=0.8}, true)
            
            -- Entity-Schaden
            local objs = minetest.get_objects_inside_radius(pos, self.radius*2)
            for _, obj in ipairs(objs) do
                if obj ~= self.object and obj ~= self.caster then
                    local opos = obj:get_pos()
                    if opos then
                        local dist = vector.distance(pos, opos)
                        local dmg = self.damage * math.max(0, 1 - dist/(self.radius*2))
                        if obj.set_hp then
                            local hp = obj:get_hp()
                            if hp and hp > 0 then
                                obj:set_hp(math.max(0, hp - dmg))
                            end
                        end
                        
                        -- Knockback
                        local dir = vector.direction(pos, opos)
                        obj:add_velocity(vector.multiply(dir, 15))
                    end
                end
            end
            
            -- Krater graben
            for x = -self.radius, self.radius do
                for z = -self.radius, self.radius do
                    for y = 0, 2 do
                        local p = {x=pos.x+x, y=pos.y-y, z=pos.z+z}
                        if vector.distance(pos, p) <= self.radius then
                            local chance = (1 - y*0.3) * 0.6
                            if math.random() < chance then
                                local n = minetest.get_node(p)
                                if n.name ~= "air" and 
                                   minetest.get_item_group(n.name, "unbreakable") == 0 then
                                    minetest.remove_node(p)
                                end
                            end
                        end
                    end
                end
            end
            
            self.object:remove()
            return
        end
    end,
})

print("[Runethera] Entities komplett (gravity_shard + meteor)")
