-- Runethera - Magie-Mod
runethera = {}
runethera.modpath = minetest.get_modpath("runethera")
runethera.players = {}
runethera.hud_ids = {}

local storage = minetest.get_mod_storage()

dofile(runethera.modpath .. "/effects.lua")
dofile(runethera.modpath .. "/effects_triggers.lua")
dofile(runethera.modpath .. "/entities.lua")
dofile(runethera.modpath .. "/mana.lua")
dofile(runethera.modpath .. "/balance.lua")
dofile(runethera.modpath .. "/hud.lua")
dofile(runethera.modpath .. "/runes.lua")
dofile(runethera.modpath .. "/spellbook.lua")
dofile(runethera.modpath .. "/spells.lua")
dofile(runethera.modpath .. "/crafting.lua")
dofile(runethera.modpath .. "/tutorial.lua")

-- SPEICHERN / LADEN
function runethera.save_player_data(name)
    local data = runethera.players[name]
    if not data then return end

    local pool_save = {}
    for rname, val in pairs(data.rune_pool or {}) do
        if val and val ~= false then pool_save[rname] = true end
    end

    local save = {
        mana            = data.mana,
        max_mana        = data.max_mana,
        mana_regen      = data.mana_regen,
        max_rune_slots  = data.max_rune_slots,
        max_spell_slots = data.max_spell_slots,
        selected_spell  = data.selected_spell,
        rune_pool       = pool_save,
        spells          = {},
    }
    for i = 1, 10 do
        local sp = data.spells[i]
        if sp then save.spells[i] = {name=sp.name, runes=sp.runes} end
    end
    storage:set_string("player_" .. name, minetest.serialize(save))
end

function runethera.load_player_data(name)
    local raw = storage:get_string("player_" .. name)
    if raw and raw ~= "" then return minetest.deserialize(raw) end
    return nil
end

-- JOIN
minetest.register_on_joinplayer(function(player)
    local name = player:get_player_name()
    local data = {
        mana=100, max_mana=100, mana_regen=1.0,
        mana_cooldown=0, spell_cooldown=0, selected_spell=1,
        max_rune_slots=7, max_spell_slots=7,
        active_tab="trigger",
        category_page={trigger=0,effect=0,powerup=0,customizable=0},
        rune_pool={},
        spells={},
    }
    for i=1,10 do data.spells[i]={name="Zauber "..i, runes={}} end

    local saved = runethera.load_player_data(name)
    if saved then
        for _, k in ipairs({"mana","max_mana","mana_regen","max_rune_slots","max_spell_slots","selected_spell"}) do
            if saved[k] then data[k] = saved[k] end
        end
        if saved.rune_pool then
            for rname, val in pairs(saved.rune_pool) do
                if val and val ~= false and val ~= 0 then
                    data.rune_pool[rname] = true
                end
            end
        end
        if saved.spells then
            for i=1,10 do
                if saved.spells[i] then
                    data.spells[i]={
                        name  = saved.spells[i].name or ("Zauber "..i),
                        runes = saved.spells[i].runes or {}
                    }
                end
            end
        end
    end
    runethera.players[name] = data
    runethera.create_hud(player)
end)

-- LEAVE
minetest.register_on_leaveplayer(function(player)
    local name = player:get_player_name()
    runethera.save_player_data(name)
    runethera.hud_ids[name] = nil
    runethera.players[name] = nil
end)

-- GLOBALSTEP
-- spell_cooldown: Float, wird mit dtime runtergezaehlt (smooth, kein Ruckeln)
-- mana_cooldown:  Integer-Sekunden (nach Mana-Verbrauch)
-- HUD-Update:     jede Sekunde fuer Mana-Bar, sofort bei spell_cooldown
local mana_tick   = 0   -- fuer 1s Mana-Regen-Takt
local save_tick   = 0
local hud_tick    = 0   -- fuer HUD-Cooldown-Update (haeufiger)

minetest.register_globalstep(function(dtime)
    mana_tick   = mana_tick   + dtime
    save_tick   = save_tick   + dtime
    hud_tick    = hud_tick    + dtime

    -- Auto-Save alle 60s
    if save_tick >= 60 then
        for name in pairs(runethera.players) do runethera.save_player_data(name) end
        save_tick = 0
    end

    -- spell_cooldown smooth runterzaehlen (jedes Frame)
    for name, d in pairs(runethera.players) do
        if (d.spell_cooldown or 0) > 0 then
            d.spell_cooldown = d.spell_cooldown - dtime
            if d.spell_cooldown < 0 then d.spell_cooldown = 0 end
        end
    end

    -- HUD alle 0.1s aktualisieren (fuer fluessigen Cooldown-Timer)
    if hud_tick >= 0.1 then
        for name, d in pairs(runethera.players) do
            local p = minetest.get_player_by_name(name)
            if p then runethera.update_hud(p) end
        end
        hud_tick = 0
    end

    -- Mana-Regen und mana_cooldown: nur 1x pro Sekunde
    if mana_tick >= 1 then
        for name, d in pairs(runethera.players) do
            local p = minetest.get_player_by_name(name)
            if p then
                -- mana_cooldown runterzaehlen (ganzzahlig pro Sekunde)
                if (d.mana_cooldown or 0) > 0 then
                    d.mana_cooldown = d.mana_cooldown - 1
                end
                -- Mana regenerieren wenn kein cooldown
                if (d.mana_cooldown or 0) <= 0 and d.mana < d.max_mana then
                    d.mana = math.min(d.mana + d.mana_regen, d.max_mana)
                end
            end
        end
        mana_tick = 0
    end
end)

minetest.register_on_shutdown(function()
    for name in pairs(runethera.players) do runethera.save_player_data(name) end
end)

-- Debug-Befehle
minetest.register_chatcommand("givemana", {
    description = "Setzt Mana auf Maximum",
    func = function(name, _)
        local p = minetest.get_player_by_name(name)
        if p then
            runethera.set_mana(p, runethera.players[name].max_mana)
            runethera.update_hud(p)
            return true, "Mana aufgefuellt!"
        end
    end
})

minetest.register_chatcommand("unlockalrunes", {
    description = "Alle Runen freischalten (Test)",
    func = function(name, _)
        local data = runethera.players[name]
        if not data then return false, "Nicht eingeloggt" end
        for rname in pairs(runethera.runes) do
            data.rune_pool[rname] = true
        end
        runethera.save_player_data(name)
        local n = 0; for _ in pairs(runethera.runes) do n=n+1 end
        return true, n .. " Runen freigeschaltet!"
    end
})

minetest.register_chatcommand("resetcd", {
    description = "Cooldown zuruecksetzen",
    func = function(name, _)
        local d = runethera.players[name]
        if d then d.spell_cooldown=0; d.mana_cooldown=0 end
        local p = minetest.get_player_by_name(name)
        if p then runethera.update_hud(p) end
        return true, "Cooldown zurueckgesetzt!"
    end
})

print("[Runethera] Mod geladen!")
