-- Mana-System für Runethera

-- Mana verbrauchen
function runethera.consume_mana(player, amount)
    local name = player:get_player_name()
    local data = runethera.players[name]
    
    if not data then return false end
    
    if data.mana >= amount then
        data.mana = data.mana - amount
        -- Aktiviere Mana-Cooldown nach Zauber-Nutzung
        data.mana_cooldown = 5 -- 5 Sekunden kein Mana-Regen
        return true
    else
        -- Nicht genug Mana
        minetest.chat_send_player(name, "Nicht genug Mana!")
        return false
    end
end

-- Mana setzen
function runethera.set_mana(player, amount)
    local name = player:get_player_name()
    local data = runethera.players[name]
    
    if data then
        data.mana = math.max(0, math.min(amount, data.max_mana))
    end
end

-- Mana hinzufügen
function runethera.add_mana(player, amount)
    local name = player:get_player_name()
    local data = runethera.players[name]
    
    if data then
        data.mana = math.min(data.mana + amount, data.max_mana)
    end
end

-- Maximales Mana erhöhen
function runethera.increase_max_mana(player, amount)
    local name = player:get_player_name()
    local data = runethera.players[name]
    
    if data then
        data.max_mana = data.max_mana + amount
        data.mana = math.min(data.mana, data.max_mana)
    end
end

-- Prüfe ob Spieler genug Mana hat
function runethera.has_mana(player, amount)
    local name = player:get_player_name()
    local data = runethera.players[name]
    
    if data then
        return data.mana >= amount
    end
    return false
end
