# RUNETHERA - BALANCE SYSTEM

## 🎯 ZIEL
Verhindert OP (overpowered) Zauber-Kombinationen durch:
1. **Duplikat-Strafe:** Gleiche Rune mehrmals = teurer
2. **OP-Kombinations-Strafe:** Bestimmte Kombinationen = extrem teuer

## 📊 DUPLIKAT-STRAFE

### Formel
```
Kosten = Basis × (1 + Duplikate × 0.5)
```

### Beispiele
```
projectile + damage
→ Keine Duplikate = 1.0× Kosten

projectile + damage + damage
→ 1 Duplikat = 1.5× Kosten

projectile + damage + damage + damage
→ 2 Duplikate = 2.0× Kosten

split + split
→ 1 Duplikat = 1.5× Kosten (Mana UND Cooldown!)
```

## ⚠️ OP-KOMBINATIONEN

### Extrem Teuer (4-5× Mana, 3-4× Cooldown)
```
pierce + meteor       → 4.0× Mana, 3.0× CD
multicast + meteor    → 5.0× Mana, 4.0× CD
gravity_burst + meteor → 4.5× Mana, 3.5× CD
```

### Sehr Teuer (3-3.5× Mana, 2.5-3× Cooldown)
```
pierce + explosion    → 3.0× Mana, 2.5× CD
pierce + quake       → 3.5× Mana, 2.5× CD
split + meteor       → 3.0× Mana, 2.5× CD
gravity_burst + explosion → 3.5× Mana, 3.0× CD
bounce + explosion   → 3.5× Mana, 2.5× CD
homing + meteor      → 3.5× Mana, 2.5× CD
```

### Teuer (2.5-3× Mana, 2× Cooldown)
```
multicast + explosion → 4.0× Mana, 3.0× CD
chain + lightning    → 3.0× Mana, 2.0× CD
homing + lightning   → 2.5× Mana, 2.0× CD
```

## 🎮 BEISPIEL-RECHNUNGEN

### Einfacher Zauber
```
Zauber: projectile + damage
Basis: 10 Mana, 1s CD
Balance: Keine Strafe
Resultat: 10 Mana, 1s CD
```

### Duplikat-Zauber
```
Zauber: projectile + damage + damage + damage
Basis: 30 Mana, 3s CD
Duplikate: 2× damage (2 Duplikate)
Strafe: 1 + (2 × 0.5) = 2.0×
Resultat: 60 Mana, 6s CD
```

### OP-Kombination
```
Zauber: projectile + meteor + pierce
Basis: 20 Mana, 2s CD
OP-Combo: pierce + meteor
Strafe: 4.0× Mana, 3.0× CD
Resultat: 80 Mana, 6s CD
```

### Extremfall (Duplikate + OP)
```
Zauber: projectile + meteor + meteor + pierce
Basis: 30 Mana, 3s CD
Duplikate: 1× meteor (1.5×)
OP-Combo: pierce + meteor (4.0× Mana, 3.0× CD)
Total: 1.5 × 4.0 = 6.0× Mana
       1.5 × 3.0 = 4.5× CD
Resultat: 180 Mana, 13.5s CD
```

## 💡 WARNUNG IM SPIEL

Wenn Zauber OP ist, zeigt Spellbook:
```
⚠ OP Combination! Cost ×4.0, Cooldown ×3.0
```

Beim Casten:
```
⚠ OP Combination! Cost ×4.0, Cooldown ×3.0
```

## 🔧 WIE ES FUNKTIONIERT

### 1. Balance-Berechnung (balance.lua)
```lua
runethera.balance.calculate_spell_cost(rune_list, base_mana, base_cd)
→ Returns: balanced_mana, balanced_cooldown
```

### 2. Integration in Spellbook
- Zeigt Balance-Warnung an
- Berechnet finale Kosten

### 3. Integration in cast_spell
- MUSS NOCH IMPLEMENTIERT WERDEN!
- Momentan: Balance-System existiert aber wird nicht angewendet

## ⚠️ TODO

Balance-System ist fertig programmiert ABER:
- [ ] Noch nicht in cast_spell integriert
- [ ] Noch nicht getestet
- [ ] Warnung im Spellbook muss gefixt werden

### Wie integrieren:
```lua
-- In cast_spell BEFORE consuming mana:
local balanced_mana, balanced_cd = runethera.balance.calculate_spell_cost(
    spell.runes, spell.mana_cost, spell.cooldown
)

-- Use balanced costs instead of base costs
if not runethera.consume_mana(player, balanced_mana) then
    return
end
runethera.set_spell_cooldown(player, spell_idx, balanced_cd)
```

## 📝 BALANCE ANPASSEN

Zum Anpassen der Balance, edit `balance.lua`:

```lua
-- Duplikat-Strafe ändern (0.5 = 50% pro Duplikat)
local DUPLICATE_MULTIPLIER = 0.5

-- Neue OP-Kombination hinzufügen
{runes = {"homing", "explosion"}, mana_mult = 3.0, cooldown_mult = 2.0}
```
