-- HUD
-- Mana-Bar: unten rechts ueber Hotbar
-- Zauber-Liste: rechte Bildschirmseite, mittig vertikal
--   [vorheriger - grau]
--   > [aktueller - weiss/hell]
--   [naechster  - grau]
runethera.hud_ids = {}

function runethera.create_hud(player)
    local name = player:get_player_name()
    runethera.hud_ids[name] = {}
    local ids = runethera.hud_ids[name]

    -- -------------------------------------------------------
    -- MANA-BAR: unten rechts, ueber Hotbar
    -- -------------------------------------------------------
    ids.mana_bar = player:hud_add({
        hud_elem_type = "statbar",
        position      = {x=1.0, y=1.0},
        size          = {x=16, y=16},
        text          = "runethera_mana_full.png",
        text2         = "runethera_mana_empty.png",
        number        = 20,
        item          = 20,
        direction     = 0,
        offset        = {x=-170, y=-108},
    })

    ids.mana_text = player:hud_add({
        hud_elem_type = "text",
        position      = {x=1.0, y=1.0},
        text          = "Mana: 100/100",
        number        = 0x6699ff,
        offset        = {x=-170, y=-84},
        alignment     = {x=-1, y=-1},
        scale         = {x=160, y=20},
    })

    ids.cd_text = player:hud_add({
        hud_elem_type = "text",
        position      = {x=1.0, y=1.0},
        text          = "",
        number        = 0xff5555,
        offset        = {x=-170, y=-66},
        alignment     = {x=-1, y=-1},
        scale         = {x=160, y=18},
    })

    -- -------------------------------------------------------
    -- ZAUBER-ANZEIGE: rechts, Bildschirmmitte vertikal
    -- Alle drei Texte sind IMMER sichtbar (nicht nur mit Buch)
    -- -------------------------------------------------------

    -- Vorheriger Zauber (grau, oben)
    ids.spell_prev = player:hud_add({
        hud_elem_type = "text",
        position      = {x=0.85, y=0.5},  -- WEITER LINKS (war 1.0)
        text          = "",
        number        = 0x666688,
        offset        = {x=0, y=-48},
        alignment     = {x=1, y=-1},
        scale         = {x=300, y=18},
    })

    -- Aktueller Zauber (weiss, fett wirkend durch helle Farbe)
    ids.spell_cur = player:hud_add({
        hud_elem_type = "text",
        position      = {x=0.85, y=0.5},  -- WEITER LINKS
        text          = "> Kein Zauber",
        number        = 0xffeedd,
        offset        = {x=0, y=-24},
        alignment     = {x=1, y=-1},
        scale         = {x=300, y=22},
    })

    -- Naechster Zauber (grau, unten)
    ids.spell_next = player:hud_add({
        hud_elem_type = "text",
        position      = {x=0.85, y=0.5},  -- WEITER LINKS
        text          = "",
        number        = 0x666688,
        offset        = {x=0, y=4},
        alignment     = {x=1, y=-1},
        scale         = {x=300, y=18},
    })
end

-- Kurzbezeichnung fuer einen Zauber-Slot
local function spell_label(data, idx)
    local max_ss = data.max_spell_slots or 7
    if idx < 1 or idx > max_ss then return "" end
    local sp = data.spells[idx]
    if not sp then return "" end
    return "[" .. idx .. "] " .. sp.name .. " (" .. #sp.runes .. ")"
end

function runethera.update_hud(player)
    local name = player:get_player_name()
    local data = runethera.players[name]
    local ids  = runethera.hud_ids[name]
    if not data or not ids then return end

    -- Mana
    local ratio   = data.mana / math.max(data.max_mana, 1)
    local bar_val = math.floor(ratio * 20)
    if ids.mana_bar  then
        player:hud_change(ids.mana_bar, "number", bar_val)
    end
    if ids.mana_text then
        player:hud_change(ids.mana_text, "text",
            "Mana: " .. math.floor(data.mana) .. "/" .. data.max_mana)
    end

    -- Cooldown
    if ids.cd_text then
        local cd = ""
        if (data.spell_cooldown or 0) > 0.05 then
            cd = "CD: " .. string.format("%.1f", data.spell_cooldown) .. "s"
        elseif (data.mana_cooldown or 0) > 0 then
            cd = "Mana-CD: " .. data.mana_cooldown .. "s"
        end
        player:hud_change(ids.cd_text, "text", cd)
    end

    -- Zauber-Liste
    local sel    = data.selected_spell or 1
    local max_ss = data.max_spell_slots or 7

    -- Vorheriger
    local prev_idx = sel - 1
    if prev_idx < 1 then prev_idx = max_ss end
    if ids.spell_prev then
        player:hud_change(ids.spell_prev, "text", spell_label(data, prev_idx))
    end

    -- Aktueller (immer anzeigen, auch ohne Buch)
    if ids.spell_cur then
        local sp  = data.spells[sel]
        local txt = "> [" .. sel .. "] " ..
                    (sp and sp.name or "?") ..
                    " (" .. (sp and #sp.runes or 0) .. " Runen)"
        player:hud_change(ids.spell_cur, "text", txt)
    end

    -- Naechster
    local next_idx = sel + 1
    if next_idx > max_ss then next_idx = 1 end
    if ids.spell_next then
        player:hud_change(ids.spell_next, "text", spell_label(data, next_idx))
    end
end
