-- RUNEN-SYSTEM
-- Das Item verschwindet (wird verbraucht). Danach braucht man es nie wieder craften.
runethera.runes = {}

function runethera.register_rune(rname, def)
    runethera.runes[rname] = {
        description = def.description or rname,
        type        = def.type        or "effect",
        mana_cost   = def.mana_cost   or 10,
        cooldown    = def.cooldown    or 0,
        on_cast     = def.on_cast     or function() end,
        texture     = def.texture     or "runethera_particle_magic.png",
        effect_id   = def.effect_id   or rname,
        params      = def.params      or {},
    }
end

function runethera.load_runes_from_config()
    local path = runethera.modpath .. "/runen.conf"
    local f = io.open(path, "r")
    if not f then
        minetest.log("error", "[Runethera] runen.conf nicht gefunden: " .. path)
        return 0
    end
    local count = 0
    for line in f:lines() do
        if not line:match("^%s*#") and not line:match("^%s*$") then
            local parts = {}
            for p in (line .. "|"):gmatch("([^|]*)|") do
                table.insert(parts, (p:gsub("^%s*(.-)%s*$", "%1")))
            end
            if #parts >= 6 and parts[1] ~= "" then
                local rname    = parts[1]
                local rtype    = parts[2]
                local desc     = parts[3]
                local mana     = tonumber(parts[4]) or 10
                local cooldown = tonumber(parts[5]) or 0
                local texture  = parts[6]
                local func_id  = (parts[7] and parts[7] ~= "") and parts[7] or rname
                local param_s  = parts[8] or ""
                local params   = {}
                for p in param_s:gmatch("[^,]+") do
                    local t = p:gsub("^%s*(.-)%s*$", "%1")
                    table.insert(params, tonumber(t) or t)
                end
                local on_cast
                if rtype == "trigger" then
                    on_cast = function(player, target)
                        local fn = runethera.effects and runethera.effects[func_id]
                        return fn and fn(player, target, params) or "projectile"
                    end
                elseif rtype == "powerup" or rtype == "customizable" then
                    on_cast = function(player, spell_data)
                        -- Spezial-Handling für Farben und Partikel-Anpassungen
                        if func_id:find("color_") then
                            spell_data.particle_color = {r=params[1] or 255, g=params[2] or 255, b=params[3] or 255}
                        elseif func_id == "particle_size_custom" then
                            spell_data.particle_size = params[1] or 1.0
                        elseif func_id == "particle_speed_custom" then
                            spell_data.particle_speed = params[1] or 1.0
                        elseif func_id == "particle_life_custom" then
                            spell_data.particle_life = params[1] or 1.0
                        elseif func_id == "particle_star" then
                            spell_data.particle_form = "star"
                        elseif func_id == "particle_ring" then
                            spell_data.particle_form = "ring"
                        elseif func_id == "particle_spiral" then
                            spell_data.particle_form = "spiral"
                        elseif func_id == "particle_fire" or func_id == "particle_explode" then
                            spell_data.particle_form = "fire"
                        else
                            -- Fallback zu Effekt-Funktion
                            local fn = runethera.effects and runethera.effects[func_id]
                            if fn then fn(player, spell_data, params) end
                        end
                    end
                else
                    on_cast = function(player, target)
                        local fn = runethera.effects and runethera.effects[func_id]
                        if fn then fn(player, target, params) end
                    end
                end
                runethera.register_rune(rname, {
                    description=desc, type=rtype, mana_cost=mana, cooldown=cooldown,
                    texture=texture, effect_id=func_id, on_cast=on_cast, params=params,
                })
                count = count + 1
            end
        end
    end
    f:close()
    minetest.log("action", "[Runethera] " .. count .. " Runen geladen.")
    return count
end

runethera.load_runes_from_config()

-- RUNEN-POOL: Spieler hat PERMANENTE Sammlung an Runen
function runethera.get_pool(pname)
    local data = runethera.players[pname]
    if not data then return {} end
    if not data.rune_pool then data.rune_pool = {} end
    return data.rune_pool
end

-- Rune zum Pool hinzufuegen (permanent, kein Limit)
function runethera.pool_add(pname, rname, count)
    local pool = runethera.get_pool(pname)
    -- Wir speichern true statt einer Zahl, da die Rune dauerhaft verfuegbar ist
    pool[rname] = true
end

-- Pruefe ob Spieler die Rune freigeschaltet hat
function runethera.pool_has(pname, rname)
    local pool = runethera.get_pool(pname)
    return pool[rname] == true
end

-- Rune aus Zauber entfernen (geht NICHT aus dem Pool - bleibt permanent)
function runethera.pool_remove(pname, rname)
    -- Permanente Runen werden nicht entfernt! Immer true zurueckgeben wenn vorhanden
    return runethera.pool_has(pname, rname)
end

local tlab = {trigger="Ausloser", effect="Effekt", powerup="Powerup", customizable="Anpassbar"}

for rname, def in pairs(runethera.runes) do
    local n = rname
    local d = def
    minetest.register_craftitem("runethera:rune_" .. rname, {
        description = "Rune: " .. def.description ..
                      "\nTyp: " .. (tlab[def.type] or def.type) ..
                      "\nMana: " .. def.mana_cost ..
                      "\n\nLinksklick = Dauerhaft freischalten!\n(Dann unbegrenzt im Zauberbuch nutzbar)",
        inventory_image = def.texture,
        stack_max = 64,
        on_use = function(itemstack, user, _)
            local pname = user:get_player_name()
            if not runethera.players[pname] then return itemstack end

            -- Bereits freigeschaltet?
            if runethera.pool_has(pname, n) then
                minetest.chat_send_player(pname,
                    "'" .. d.description .. "' ist bereits freigeschaltet!")
                -- Item trotzdem verbrauchen (sonst haengt man auf gestackten Runen)
                itemstack:take_item(1)
                return itemstack
            end

            -- Dauerhaft freischalten
            runethera.pool_add(pname, n, 1)
            runethera.save_player_data(pname)

            -- Item entfernen (verbraucht)
            itemstack:take_item(1)

            minetest.chat_send_player(pname,
                "\194\167a[Runethera] '" .. d.description ..
                "' dauerhaft freigeschaltet! Jetzt unbegrenzt im Zauberbuch verwendbar.")

            -- Formspec aktualisieren falls offen
            minetest.after(0.05, function()
                local p = minetest.get_player_by_name(pname)
                if p then
                    minetest.show_formspec(pname, "runethera:spellbook",
                        runethera.get_spellbook_formspec(p))
                end
            end)
            return itemstack
        end,
    })
end

local n = 0; for _ in pairs(runethera.runes) do n = n+1 end
print("[Runethera] " .. n .. " Runen-Items registriert!")
