-- RUNETHERA - TUTORIAL-BUCH SYSTEM
-- Wird beim ersten Join gegeben, aufrufbar mit /tutorialbook

-- Speichert welche Spieler das Tutorial schon hatten
local storage = minetest.get_mod_storage()

local function has_seen_tutorial(name)
    return storage:get_string("tutorial_" .. name) == "seen"
end

local function mark_tutorial_seen(name)
    storage:set_string("tutorial_" .. name, "seen")
end

-- Tutorial-Kapitel
local chapters = {
    {
        title = "Willkommen zu Runethera!",
        text = [[
Runethera ist ein magisches Zauber-System.

Du kannst eigene Zauber aus RUNEN zusammenbauen!

Jeder Zauber braucht:
1. AUSLÖSER (wie wird er gewirkt?)
2. EFFEKTE (was passiert?)
3. POWERUPS (optional, macht ihn stärker)

Drücke 'Weiter' um mehr zu erfahren...
        ]]
    },
    {
        title = "Dein erstes Zauberbuch",
        text = [[
Du hast ein ZAUBERBUCH erhalten!

STEUERUNG:
• LINKSKLICK = Zauber wirken
• RECHTSKLICK = Nächster Zauber
• SHIFT + RECHTSKLICK = Vorheriger
• /spellbook = Buch öffnen

Öffne jetzt dein Zauberbuch mit /spellbook!
        ]]
    },
    {
        title = "Runen freischalten",
        text = [[
Runen müssen FREIGESCHALTET werden:

1. CRAFTE eine Rune
2. LINKSKLICK auf die Rune im Inventar
3. Die Rune ist DAUERHAFT freigeschaltet!

Starter-Rezepte:
• Projektil-Rune = 8× Default Stone
• Schaden-Rune = 8× Default Steel
• Heilungs-Rune = 8× Default Mese Crystal

Craft deine erste Rune!
        ]]
    },
    {
        title = "Zauber bauen",
        text = [[
So baust du einen Zauber:

1. Öffne /spellbook
2. Wähle einen Zauber-Slot (1-7)
3. Klicke auf FREIGESCHALTETE Runen

REGEL: AUSLÖSER ZUERST!
• Zuerst: projectile (oder self, touch, etc.)
• Dann: damage, heal, explosion, etc.
• Optional: amplify, split, pierce, etc.

BEISPIEL:
projectile + damage + amplify = Starkes Projektil!
        ]]
    },
    {
        title = "Mana & Cooldowns",
        text = [[
Jeder Zauber kostet MANA:
• Du hast 100 Mana (regeneriert mit 1/s)
• Jede Rune kostet Mana
• Stärkere Zauber = mehr Mana

COOLDOWN:
• Nach dem Wirken: Cooldown
• Angezeigt in der HUD (rechts unten)

TIPP: Starte mit einfachen Zaubern!
        ]]
    },
    {
        title = "Fortgeschritten",
        text = [[
KOMBINATIONS-TIPPS:

SCHADEN:
• projectile + damage + amplify + split
• cone + poison + aoe_size
• chain + lightning

HEILUNG:
• self + heal + amplify
• aoe + heal (heilt Gruppe)

UTILITY:
• touch + harvest (Ernte Pflanzen)
• aoe + pickup_items (Sammle Items)
• projectile + break_block (Abbauen)

Experimentiere! Es gibt 50+ Effekte!
        ]]
    },
    {
        title = "Viel Erfolg!",
        text = [[
Du bist bereit!

WICHTIG:
• Experimentiere mit Kombinationen
• Upgrade deine Zauber-Slots (/shop)
• Schalte neue Runen frei
• Habe Spaß!

HILFE:
• /tutorialbook = Dieses Buch nochmal
• /spellbook = Zauberbuch öffnen
• /help runethera = Kommandos

Viel Spaß beim Zaubern!
        ]]
    },
}

-- Formspec für Tutorial
local function get_tutorial_formspec(player_name, page)
    page = page or 1
    local chapter = chapters[page]
    
    local fs = "formspec_version[6]size[12,10]"
    fs = fs .. "bgcolor[#1a1a2e;true]"
    
    -- Titel
    fs = fs .. "box[0.5,0.5;11,1.2;#2a2a4a]"
    fs = fs .. "label[1,1.1;" .. minetest.formspec_escape(chapter.title) .. "]"
    
    -- Text
    fs = fs .. "box[0.5,2;11,6;#0f0f1e]"
    fs = fs .. "textarea[0.7,2.2;10.6,5.8;;;" .. minetest.formspec_escape(chapter.text) .. "]"
    
    -- Navigation
    if page > 1 then
        fs = fs .. "button[0.5,8.5;2,0.8;prev;◄ Zurück]"
    end
    if page < #chapters then
        fs = fs .. "button[9.5,8.5;2,0.8;next;Weiter ►]"
    else
        fs = fs .. "button[9.5,8.5;2,0.8;close;Fertig!]"
    end
    
    -- Seiten-Anzeige
    fs = fs .. "label[5.5,8.8;Seite " .. page .. " / " .. #chapters .. "]"
    
    return fs
end

-- Formspec-Handler
minetest.register_on_player_receive_fields(function(player, formname, fields)
    if formname ~= "runethera:tutorial" then return end
    
    local name = player:get_player_name()
    local page = tonumber(player:get_meta():get_string("tutorial_page")) or 1
    
    if fields.next then
        page = page + 1
    elseif fields.prev then
        page = page - 1
    elseif fields.close or fields.quit then
        mark_tutorial_seen(name)
        return
    end
    
    player:get_meta():set_string("tutorial_page", tostring(page))
    minetest.show_formspec(name, "runethera:tutorial", get_tutorial_formspec(name, page))
end)

-- Zeige Tutorial
local function show_tutorial(player)
    local name = player:get_player_name()
    player:get_meta():set_string("tutorial_page", "1")
    minetest.show_formspec(name, "runethera:tutorial", get_tutorial_formspec(name, 1))
end

-- Bei Join: Zeige Tutorial wenn neu
minetest.register_on_joinplayer(function(player)
    local name = player:get_player_name()
    
    if not has_seen_tutorial(name) then
        -- Gib Zauberbuch
        local inv = player:get_inventory()
        if inv:room_for_item("main", "runethera:spellbook") then
            inv:add_item("main", "runethera:spellbook")
        end
        
        -- Zeige Tutorial nach 2 Sekunden
        minetest.after(2, function()
            if minetest.get_player_by_name(name) then
                show_tutorial(player)
                minetest.chat_send_player(name, "Willkommen bei Runethera! Lies das Tutorial.")
            end
        end)
    end
end)

-- /tutorialbook Command
minetest.register_chatcommand("tutorialbook", {
    description = "Öffnet das Runethera-Tutorial",
    func = function(name)
        local player = minetest.get_player_by_name(name)
        if player then
            show_tutorial(player)
            return true, "Tutorial geöffnet!"
        end
        return false, "Spieler nicht gefunden"
    end
})

print("[Runethera] Tutorial-System geladen")

-- Hilfe-Command
minetest.register_chatcommand("runehelp", {
    description = "Zeigt Runethera-Hilfe",
    func = function(name)
        minetest.chat_send_player(name, "=== RUNETHERA HILFE ===")
        minetest.chat_send_player(name, "/spellbook - Zauberbuch öffnen")
        minetest.chat_send_player(name, "/tutorialbook - Tutorial öffnen")
        minetest.chat_send_player(name, "/runehelp - Diese Hilfe")
        minetest.chat_send_player(name, "")
        minetest.chat_send_player(name, "SCHNELLSTART:")
        minetest.chat_send_player(name, "1. Crafte Runen (siehe Rezepte)")
        minetest.chat_send_player(name, "2. Linksklick auf Rune = Freischalten")
        minetest.chat_send_player(name, "3. /spellbook öffnen")
        minetest.chat_send_player(name, "4. Zauber bauen: AUSLÖSER + EFFEKTE")
        minetest.chat_send_player(name, "5. Mit Zauberbuch wirken!")
        return true
    end
})
