local nuke_boom = {
	name = "nuke_boom",
	--description = "explosion caused by nuclear compound",
	radius = 12,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

		minetest.register_node("chemistry:nuke", {
			description = ("Nuclear Bomb"),
			tiles = {"nuke_top.png", "nuke_bottom.png", "nuke_side.png"},
			is_ground_content = false,
			groups = {dig_immediate = 2, mesecon = 2, tnt = 1, flammable = 5},
			sounds = default.node_sound_wood_defaults(),
			after_place_node = function(pos, placer)
				if placer and placer:is_player() then
					local meta = minetest.get_meta(pos)
					meta:set_string("owner", placer:get_player_name())
				end
			end,
			on_punch = function(pos, node, puncher)
				if puncher:get_wielded_item():get_name() == "default:torch" then
					minetest.swap_node(pos, {name ="chemistry:nuke_burning"})
					minetest.registered_nodes["chemistry:nuke_burning"].on_construct(pos)
					default.log_player_action(puncher, "ignites", node.name, "at", pos)
				end
			end,
			on_blast = function(pos, intensity)
				minetest.after(0.1, function()
					tnt.boom(pos, nuke_boom)
				end)
			end,
			mesecons = {effector =
				{action_on =
					function(pos)
						tnt.boom(pos, nuke_boom)
					end
				}
			},
			on_burn = function(pos)
				minetest.swap_node(pos, {name ="chemistry:nuke_burning"})
				minetest.registered_nodes["chemistry:nuke_burning"].on_construct(pos)
			end,
			on_ignite = function(pos, igniter)
				minetest.swap_node(pos, {name ="chemistry:nuke_burning"})
				minetest.registered_nodes["chemistry:nuke_burning"].on_construct(pos)
			end,
		})

minetest.register_node("chemistry:nuke_burning", {
			description = ("Nuclear Bomb Burning"),
		tiles = {
			{
				name = "nuke_top_burning_animated.png",
				animation = {
					type = "vertical_frames",
					aspect_w = 16,
					aspect_h = 16,
					length = 1,
				}
			},
			"nuke_bottom.png", "nuke_side.png"
			},
		light_source = 10,
		drop = "",
		sounds = default.node_sound_wood_defaults(),
		groups = {falling_node = 1, not_in_creative_inventory = 1},
		on_timer = function(pos, elapsed)
			tnt.boom(pos, nuke_boom)
		end,
		-- unaffected by explosions
		on_blast = function() end,
		on_construct = function(pos)
			minetest.sound_play("tnt_ignite", {pos = pos}, true)
			minetest.get_node_timer(pos):start(8)
			minetest.check_for_falling(pos)
		end,
	})

minetest.register_craft({
	output = 'chemistry:nuke',
	recipe = {
		{'chemistry:titanium_block', 'chemistry:uranium_block', 'chemistry:titanium_block'},
		{'chemistry:thorium_block', 'tnt:gunpowder', 'chemistry:thorium_block'},
		{'chemistry:titanium_block', 'chemistry:uranium_block', 'chemistry:titanium_block'},
	}
})

