
	minetest.register_biome({
		name = "alkaline_land",
		node_top = "chemistry:alkaline_sand",
		depth_top = 1,
		node_filler = "chemistry:alkaline_sand",
		depth_filler = 2,
		node_riverbed = "chemistry:alkaline_sand",
		depth_riverbed = 2,
		node_dungeon = "chemistry:alkaline_sandstone_brick",
		node_dungeon_alt = "chemistry:alkaline_sandstone_brick",
		node_dungeon_stair = "stairs:stair_alkaline_sandstone_brick",
		y_max = 31000,
		y_min = 4,
		heat_point = 90,
		humidity_point = 75,
	})


	minetest.register_decoration({
		name = "chemistry:cesium_crystal",
		deco_type = "simple",
		place_on = {"chemistry:alkaline_sand"},
		sidelen = 16,
		noise_params = {
			offset = -0.012,
			scale = 0.024,
			spread = {x = 100, y = 100, z = 100},
			seed = 230,
			octaves = 3,
			persist = 0.6
		},
		y_max = 300,
		y_min = 1,
		decoration = "chemistry:cesium_crystal",
	})

	minetest.register_ore({
		ore_type        = "stratum",
		ore             = "chemistry:alkaline_sandstone",
		wherein         = {"default:stone"},
		clust_scarcity  = 1,
		y_max           = 46,
		y_min           = 4,
		noise_params    = {
			offset = 28,
			scale = 16,
			spread = {x = 128, y = 128, z = 128},
			seed = 90122,
			octaves = 1,
		},
		stratum_thickness = 90,
		biomes = {"alkaline_land"},
	})

minetest.register_node("chemistry:sand_with_lithium", {
	description = ("Sand Lithium Ore"),
	tiles = {"alkaline_sand.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_sodium", {
	description = ("Sand Sodium Ore"),
	tiles = {"alkaline_sand.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_potassium", {
	description = ("Sand Potassium Ore"),
	tiles = {"alkaline_sand.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_rubidium", {
	description = ("Sand Rubidium Ore"),
	tiles = {"alkaline_sand.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone", {
	description = ("Alkaline Sandstone"),
	tiles = {"alkaline_sandstone.png"},
	groups = {crumbly = 1, cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_brick", {
	description = ("Alkaline Sandstone Brick"),
	tiles = {"alkaline_sandstone_brick.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_block", {
	description = ("Alkaline Sandstone Block"),
	tiles = {"alkaline_sandstone_block.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sand", {
	description = ("Alkaline Sand"),
	tiles = {"alkaline_sand.png"},
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_block 9',
	recipe = {
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
	}
})

minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_brick 4',
	recipe = {
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', ''},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', ''},
		{'', '', ''},
	}
})

stairs.register_stair(
	"alkaline_sandstone_brick",
	"chemistry:alkaline_sandstone_brick",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_brick.png"},
	("Alkaline Sandstone Brick Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"alkaline_sandstone_brick",
	"chemistry:alkaline_sandstone_brick",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_brick.png"},
	("Alkaline Sandstone Brick Slab"),
	default.node_sound_stone_defaults()
)

stairs.register_stair(
	"alkaline_sandstone_block",
	"chemistry:alkaline_sandstone_block",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_block.png"},
	("Alkaline Sandstone Block Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"alkaline_sandstone_block",
	"chemistry:alkaline_sandstone_block",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_block.png"},
	("Alkaline Sandstone Block Slab"),
	default.node_sound_stone_defaults()
)

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

