
local chemical_boom = {
	name = "chemical_boom",
	--description = "explosion caused by chemical reactions",
	radius = 4,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

local chemical_boom2 = {
	name = "chemical_boom2",
	--description = "explosion caused by chemical reactions",
	radius = 2,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

tnt.register_tnt(chemical_boom)

tnt.register_tnt(chemical_boom2)

minetest.register_node("chemistry:nitroglycerin", {
	description = ("Nitroglycerin"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	on_blast = function(pos)
		minetest.after(0.1, function()
		   tnt.boom(pos, chemical_boom)
      end)
	end,
	on_burn = function(pos)
		tnt.boom(pos, chemical_boom)
	end,
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:nitroglycerin_flowing",
	liquid_alternative_source = "chemistry:nitroglycerin",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1, flammable = 10},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:nitroglycerin_flowing", {
	description = ("Flowing Nitroglycerin"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	on_blast = function(pos)
		minetest.after(0.1, function()
		   tnt.boom(pos, chemical_boom2)
      end)
	end,
	on_burn = function(pos)
		tnt.boom(pos, chemical_boom)
	end,
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:nitroglycerin_flowing",
	liquid_alternative_source = "chemistry:nitroglycerin",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, flammable = 10},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:nitroglycerin",
		"chemistry:nitroglycerin_flowing",
		"chemistry:nitroglycerin_bucket",
		"oil_bucket.png",
		("Nitroglycerin Bucket"),
		{tool = 1, explosive = 1}
	)


minetest.register_node("chemistry:glycerin", {
	description = ("Glycerin"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:190",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:190",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glycerin_flowing",
	liquid_alternative_source = "chemistry:glycerin",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:glycerin_flowing", {
	description = ("Flowing Glycerin"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:190",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:190",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glycerin_flowing",
	liquid_alternative_source = "chemistry:glycerin",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:glycerin",
		"chemistry:glycerin_flowing",
		"chemistry:glycerin_bucket",
		"liquid_bucket.png",
		("Glycerin Bucket"),
		{tool = 1}
	)

minetest.register_craft({
	output = 'chemistry:nitroglycerin_bucket',
	recipe = {
		{'chemistry:hno_acid_bucket', 'chemistry:glycerin_bucket'},
	},
   replacements = {{'chemistry:hno_acid_bucket', 'bucket:bucket_empty'}}
})

