
minetest.register_node("chemistry:mineral_oil", {
	description = ("Mineral Oil"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:mineral_oil_flowing",
	liquid_alternative_source = "chemistry:mineral_oil",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:mineral_oil_flowing", {
	description = ("Flowing Mineral Oil"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:mineral_oil_flowing",
	liquid_alternative_source = "chemistry:mineral_oil",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:mineral_oil",
		"chemistry:mineral_oil_flowing",
		"chemistry:mineral_oil_bucket",
		"oil_bucket.png",
		("Mineral Oil Bucket"),
		{tool = 1}
	)

minetest.register_node("chemistry:kerosene", {
	description = ("Kerosene"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "oil_source_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "oil_source_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:kerosene_flowing",
	liquid_alternative_source = "chemistry:kerosene",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:kerosene_flowing", {
	description = ("Flowing Kerosene"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "oil_flowing_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "oil_flowing_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:kerosene_flowing",
	liquid_alternative_source = "chemistry:kerosene",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:kerosene",
		"chemistry:kerosene_flowing",
		"chemistry:kerosene_bucket",
		"oil_bucket.png",
		("Kerosene Bucket"),
		{tool = 1, fuel_bucket = 1}
	)

minetest.register_node("chemistry:petroleum", {
	description = ("Petroleum"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "petrol_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "petrol_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:petroleum_flowing",
	liquid_alternative_source = "chemistry:petroleum",
	liquid_viscosity = 1,
	post_effect_color = {a = 255, r = 0, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:petroleum_flowing", {
	description = ("Flowing Petroleum"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "petrol_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "petrol_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:petroleum_flowing",
	liquid_alternative_source = "chemistry:petroleum",
	liquid_viscosity = 1,
	post_effect_color = {a = 255, r = 0, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:petroleum",
		"chemistry:petroleum_flowing",
		"chemistry:petroleum_bucket",
		"petrol_bucket.png",
		("Petroleum Bucket"),
		{tool = 1, fuel_bucket = 1}
	)

minetest.register_node("chemistry:gasoline", {
	description = ("Gasoline"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:gasoline_flowing",
	liquid_alternative_source = "chemistry:gasoline",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:gasoline_flowing", {
	description = ("Flowing Gasoline"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:gasoline_flowing",
	liquid_alternative_source = "chemistry:gasoline",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:gasoline",
		"chemistry:gasoline_flowing",
		"chemistry:gasoline_bucket",
		"liquid_bucket.png",
		("Gasoline Bucket"),
		{tool = 1, fuel_bucket = 1}
	)


minetest.register_craft({
	type = "cooking",
	cooktime = 15,
	output = "chemistry:kerosene_bucket",
	recipe = "chemistry:petroleum_bucket"
})

minetest.register_craft({
	type = "cooking",
	cooktime = 10,
	output = "chemistry:gasoline_bucket",
	recipe = "chemistry:kerosene_bucket"
})

minetest.register_craft({
	type = "cooking",
	cooktime = 20,
	output = "chemistry:bucket_with_plastic",
	recipe = "chemistry:gasoline_bucket"
})

minetest.register_craftitem("chemistry:bucket_with_plastic", {
	description = ("Bucket With Plastic"),
	inventory_image = "bucket_with_plastic.png",
})

minetest.register_craft({
   output = 'basic_materials:plastic_sheet 3',
   recipe = {
      {'chemistry:bucket_with_plastic'},
	},
   replacements = {{'chemistry:bucket_with_plastic', 'bucket:bucket_empty'}}
})

minetest.register_craft({
   output = 'chemistry:plastic_block',
   recipe = {
      {'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
      {'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
      {'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
	}
})

minetest.register_craft({
   output = 'basic_materials:plastic_sheet 9',
   recipe = {
       {'chemistry:plastic_block'},
	}
})

minetest.register_node("chemistry:plastic_block", {
	description = ("Plastic Block"),
	tiles = {"plastic_block.png"},
	is_ground_content = false,
	groups = {oddly_breakable_by_hand = 2, flammable = 5, air_pollutioner = 1},
	sounds = default.node_sound_snow_defaults(),
})

	minetest.override_item("default:dirt", {
		drop = {
			max_items = 2,
			items = {
				{
					items = {"chemistry:styrene_monomer"},
					rarity = 20
				},
				{
					items = {"chemistry:baking_soda"},
					rarity = 20
				},
				{
					items = {"default:dirt"}
				}
			}
		}
	})

minetest.register_craftitem("chemistry:styrene_monomer", {
	description = ("Styrene Monomer"),
	inventory_image = "styrene_monomer.png",
})

minetest.register_craftitem("chemistry:unprocessed_polystyrene", {
	description = ("Unprocessed Polystyrene"),
	inventory_image = "liquid_bucket.png",
})

minetest.register_craft({
   output = 'chemistry:unprocessed_polystyrene',
   recipe = {
      {'chemistry:ethanol_bucket', 'chemistry:styrene_monomer'},
	}
})

minetest.register_craftitem("chemistry:bucket_with_polystyrene", {
	description = ("Bucket With Polystyrene"),
	inventory_image = "bucket_with_plastic.png",
})

minetest.register_craft({
	type = "cooking",
	cooktime = 10,
	output = "chemistry:bucket_with_polystyrene",
	recipe = "chemistry:unprocessed_polystyrene"
})

minetest.register_craftitem("chemistry:polystyrene_sheet", {
	description = ("Polystyrene Sheet"),
	inventory_image = "basic_materials_plastic_sheet.png",
})

minetest.register_craft({
   output = 'chemistry:polystyrene_sheet 3',
   recipe = {
      {'chemistry:bucket_with_polystyrene'},
	},
   replacements = {{'chemistry:bucket_with_polystyrene', 'bucket:bucket_empty'}}
})

minetest.register_craft({
	type = "fuel",
	recipe = "group:fuel_bucket",
	burntime = 60,
})

