local oil_footstep = {footstep = {name = "oil_footstep", gain = 0.2}}


local chemical_boom = {
	name = "chemical_boom",
	--description = "explosion caused by chemical reactions",
	radius = 4,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

local chemical_boom2 = {
	name = "chemical_boom2",
	--description = "explosion caused by chemical reactions",
	radius = 2,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

tnt.register_tnt(chemical_boom)

tnt.register_tnt(chemical_boom2)

minetest.register_node("chemistry:nitroglycerin", {
	description = ("Nitroglycerin"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	on_blast = function(pos, intensity)
		minetest.after(0.1, function()
		   tnt.boom(pos, chemical_boom)
      end)
	end,
	on_burn = function(pos)
		tnt.boom(pos, chemical_boom)
	end,
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:nitroglycerin_flowing",
	liquid_alternative_source = "chemistry:nitroglycerin",
	liquid_viscosity = 2,
	post_effect_color ={a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1, flammable = 10},
	sounds = oil_footstep,
})

minetest.register_node("chemistry:nitroglycerin_flowing", {
	description = ("Flowing Nitroglycerin"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2,
			},
		},
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	on_blast = function(pos, intensity)
		minetest.after(0.1, function()
		   tnt.boom(pos, chemical_boom2)
      end)
	end,
	on_burn = function(pos)
		tnt.boom(pos, chemical_boom)
	end,
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:nitroglycerin_flowing",
	liquid_alternative_source = "chemistry:nitroglycerin",
	liquid_viscosity = 2,
	liquid_range = 5,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, flammable = 10},
	sounds = oil_footstep,
})

	bucket.register_liquid(
		"chemistry:nitroglycerin",
		"chemistry:nitroglycerin_flowing",
		"chemistry:nitroglycerin_bucket",
		"oil_bucket.png",
		("Nitroglycerin Bucket"),
		{tool = 1, explosive = 1}
	)


minetest.register_node("chemistry:glycerin", {
	description = ("Glycerin"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:190",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:190",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glycerin_flowing",
	liquid_alternative_source = "chemistry:glycerin",
	liquid_viscosity = 2,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, cools_lava = 1},
	sounds = oil_footstep,
})

minetest.register_node("chemistry:glycerin_flowing", {
	description = ("Flowing Glycerin"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:190",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:190",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glycerin_flowing",
	liquid_alternative_source = "chemistry:glycerin",
	liquid_viscosity = 2,
	liquid_range = 2,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = oil_footstep,
})

	bucket.register_liquid(
		"chemistry:glycerin",
		"chemistry:glycerin_flowing",
		"chemistry:glycerin_bucket",
		"liquid_bucket.png",
		("Glycerin Bucket"),
		{tool = 1}
	)

minetest.register_craft({
	output = 'chemistry:nitroglycerin_bucket',
	recipe = {
		{'chemistry:hno_acid_bucket', 'chemistry:glycerin_bucket'},
	},
   replacements = {{'chemistry:hno_acid_bucket', 'bucket:bucket_empty'}}
})

if minetest.get_modpath("mesecons") then
		minetest.register_node("chemistry:c4", {
			description = ("C4 Bomb"),
			tiles = {"c4_base.png", "c4_base.png", "c4_side.png"},
			is_ground_content = false,
			groups = {dig_immediate = 2, mesecon = 2, tnt = 1, flammable = 5},
			sounds = default.node_sound_wood_defaults(),
			after_place_node = function(pos, placer)
				if placer and placer:is_player() then
					local meta = minetest.get_meta(pos)
					meta:set_string("owner", placer:get_player_name())
				end
			end,
			on_blast = function(pos, intensity)
				minetest.after(0.1, function()
					tnt.boom(pos, chemical_boom2)
				end)
			end,
			mesecons = {effector =
				{action_on =
					function(pos)
				minetest.sound_play(
					"c4_countdown",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
				minetest.after(5, function()
					tnt.boom(pos, chemical_boom2)
				end)
					end
				}
			},
			on_burn = function(pos)
				minetest.after(0.1, function()
					tnt.boom(pos, chemical_boom2)
				end)
			end,
		})

minetest.register_craft({
	output = 'chemistry:c4',
	recipe = {
		{'chemistry:plastic_block', 'default:mese_crystal', 'chemistry:plastic_block'},
		{'default:mese_crystal', 'chemistry:nitroglycerin_bucket', 'default:mese_crystal'},
		{'chemistry:plastic_block', 'default:mese_crystal', 'chemistry:plastic_block'},
	},
   replacements = {{'chemistry:nitroglycerin_bucket', 'bucket:bucket_empty'}}
})
end

