
minetest.register_craftitem("chemistry:radium", {
	description = ("Radium"),
	inventory_image = "radium.png",
})

minetest.register_node("chemistry:radium_block", {
	description = ("Radium Block"),
	tiles = {"radium_block.png"},
	is_ground_content = true,
	groups = {cracky = 2, radioactive = 12},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = 'chemistry:radium_block',
	recipe = {
		{'chemistry:radium', 'chemistry:radium', 'chemistry:radium'},
		{'chemistry:radium', 'chemistry:radium', 'chemistry:radium'},
		{'chemistry:radium', 'chemistry:radium', 'chemistry:radium'},
	}
})

minetest.register_craft({
	output = 'chemistry:radium 9',
	recipe = {
		{'chemistry:radium_block'},
	}
})

minetest.register_craftitem("chemistry:radium_dust", {
	description = ("Radium Dust"),
	inventory_image = "radium_dust.png",
})

-- Ore generation
-- -128 <-> -255

minetest.register_node("chemistry:radon", {
	description = ("Radon Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 1,
   damage_per_second = 0,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "radon_wl.png",
	inventory_image = "radon_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, radioactive = 1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local directions = {
	{x=1, y=0, z=0},
	{x=-1, y=0, z=0},
	{x=0, y=0, z=1},
	{x=0, y=0, z=-1},
}

local gas_node = {name="chemistry:radon"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:radon"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

minetest.register_craftitem("chemistry:polonium", {
	description = ("Polonium"),
	inventory_image = "polonium.png",
})

minetest.register_node("chemistry:polonium_block", {
	description = ("Polonium Block"),
	tiles = {"polonium_block.png"},
	is_ground_content = true,
	groups = {cracky = 2, radioactive = 8},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = 'chemistry:polonium_block',
	recipe = {
		{'chemistry:polonium', 'chemistry:polonium', 'chemistry:polonium'},
		{'chemistry:polonium', 'chemistry:polonium', 'chemistry:polonium'},
		{'chemistry:polonium', 'chemistry:polonium', 'chemistry:polonium'},
	}
})

minetest.register_craft({
	output = 'chemistry:polonium 9',
	recipe = {
		{'chemistry:polonium_block'},
	}
})


minetest.register_craftitem("chemistry:thorium", {
	description = ("Thorium"),
	inventory_image = "thorium.png",
})

minetest.register_node("chemistry:thorium_block", {
	description = ("Thorium Block"),
	tiles = {"thorium_block.png"},
	is_ground_content = true,
	groups = {cracky = 2, radioactive = 3},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = 'chemistry:thorium_block',
	recipe = {
		{'chemistry:thorium', 'chemistry:thorium', 'chemistry:thorium'},
		{'chemistry:thorium', 'chemistry:thorium', 'chemistry:thorium'},
		{'chemistry:thorium', 'chemistry:thorium', 'chemistry:thorium'},
	}
})

minetest.register_craft({
	output = 'chemistry:thorium 9',
	recipe = {
		{'chemistry:thorium_block'},
	}
})

-- Ore generation
-- -128 <-> -255

local orthogonal = {
	{x=0,y=0,z=1},
	{x=0,y=1,z=0},
	{x=1,y=0,z=0},
	{x=0,y=0,z=-1},
	{x=0,y=-1,z=0},
	{x=-1,y=0,z=0},
}

minetest.register_abm({
	label = "chemistry:thorite decay",
	nodenames = {"chemistry:thorite"},
	neighbors = {"air"},
	interval = 1.0,
	chance = 1,
	catch_up = true,
	action = function(pos, node)
		local target_pos = vector.add(pos,orthogonal[math.random(1,6)])
		if minetest.get_node(target_pos).name == "air" then
			minetest.swap_node(target_pos, {name="chemistry:radon"})
			if math.random() < 0.5 then
				minetest.sound_play(
					"",
					{pos = pos, max_hear_distance = 8, gain = 0.05}
				)
			end
		end	
	end,
})

minetest.register_node("chemistry:uranium_dioxide", {
	description = ("Uranium Dioxide"),
	tiles = {"uranium_dioxide.png"},
	groups = {crumbly = 3, falling_node = 1, radioactive = 3},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_craftitem("chemistry:uranium", {
	description = ("Uranium"),
	inventory_image = "uranium.png",
})

minetest.register_node("chemistry:uranium_block", {
	description = ("Uranium Block"),
	tiles = {"uranium_block.png"},
	is_ground_content = true,
	groups = {cracky = 2, radioactive = 4},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = 'chemistry:uranium_block',
	recipe = {
		{'chemistry:uranium', 'chemistry:uranium', 'chemistry:uranium'},
		{'chemistry:uranium', 'chemistry:uranium', 'chemistry:uranium'},
		{'chemistry:uranium', 'chemistry:uranium', 'chemistry:uranium'},
	}
})

minetest.register_craft({
	output = 'chemistry:uranium 9',
	recipe = {
		{'chemistry:uranium_block'},
	}
})

minetest.register_node("chemistry:uranium_water", {
	description = ("Uranium Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "yliquid_source_animated.png^[opacity:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "yliquid_source_animated.png^[opacity:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 5,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:uranium_water_flowing",
	liquid_alternative_source = "chemistry:uranium_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 0},
	groups = {liquid = 3, cools_lava = 1, radioactive = 3},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:uranium_water_flowing", {
	description = ("Flowing Uranium Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"yliquid.png"},
	special_tiles = {
		{
			name = "yliquid_flowing_animated.png^[opacity:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "yliquid_flowing_animated.png^[opacity:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 5,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:uranium_water_flowing",
	liquid_alternative_source = "chemistry:uranium_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, radioactive = 3},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:uranium_water",
		"chemistry:uranium_water_flowing",
		"chemistry:uranium_water_bucket",
		"yellow_wt_bucket.png",
		("Uranium Water Bucket"),
		{tool = 1}
	)

minetest.register_craft({
	output = 'chemistry:uranyl_acetate',
	recipe = {
		{'chemistry:uranium_dioxide', 'chemistry:ch3cooh_acid_bucket'},
	},
	replacements = {{'chemistry:ch3cooh_acid_bucket', 'bucket:bucket_empty'}},
})

minetest.register_craft({
	output = 'chemistry:uranyl_nitrate',
	recipe = {
		{'chemistry:uranyl_acetate', 'chemistry:hno_acid_bucket'},
	},
	replacements = {{'chemistry:hno_acid_bucket', 'bucket:bucket_empty'}},
})

minetest.register_craft({
	output = 'chemistry:uranium_water_bucket',
	recipe = {
		{'chemistry:uranyl_nitrate', 'bucket:bucket_water'},
	}
})

minetest.register_craft({
	output = 'chemistry:sodium_diuranate',
	recipe = {
		{'chemistry:uranium_water_bucket', 'chemistry:cwater_bucket', 'vessels:glass_bottle'},
	},
	replacements = {{'chemistry:cwater_bucket', 'bucket:bucket_empty'}, {'chemistry:uranium_water_bucket', 'chemistry:uranium_water_bucket'}},
})

minetest.register_craft({
	output = 'chemistry:uranium_comp',
	recipe = {
		{'chemistry:sodium_diuranate', 'vessels:glass_fragments'},
	}
})

minetest.register_craft({
	output = 'chemistry:uranium_comp_bucket',
	recipe = {
		{'chemistry:uranium_comp', 'chemistry:uranium_comp', 'chemistry:uranium_comp'},
      {'', 'bucket:bucket_empty', ''},
	}
})

minetest.register_craftitem("chemistry:uranyl_acetate", {
	description = ("Uranyl Acetate"),
	inventory_image = "uranyl_acetate.png",
})

minetest.register_craftitem("chemistry:uranyl_nitrate", {
	description = ("Uranyl Nitrate"),
	inventory_image = "uranyl_nitrate.png",
})

minetest.register_craftitem("chemistry:sodium_diuranate", {
	description = ("Sodium Diuranate"),
	inventory_image = "sodium_diuranate.png",
})

minetest.register_craftitem("chemistry:uranium_comp", {
	description = ("Uranium Compound"),
	inventory_image = "uranium_comp.png",
})

minetest.register_craftitem("chemistry:uranium_comp_bucket", {
	description = ("Uranium Compound Bucket"),
	inventory_image = "uranium_comp_bucket.png",
})

minetest.register_node("chemistry:uranium_glass", {
	description = ("Uranium Glass"),
	drawtype = "glasslike_framed_optional",
	tiles = {"uranium_glass.png", "uranium_glass_detail.png"},
	use_texture_alpha = "clip",
	paramtype = "light",
   light_source = 7,
   glow = 7,
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {cracky = 3, oddly_breakable_by_hand = 3},
	sounds = default.node_sound_glass_defaults(),
})

minetest.register_craft({
	type = "cooking",
	cooktime = 3,
	output = "chemistry:uranium_glass",
	recipe = "chemistry:uranium_comp_bucket"
})

-- Ore generation
-- -128 <-> -255

minetest.register_craftitem("chemistry:plutonium", {
	description = ("Plutonium"),
	inventory_image = "plutonium.png",
})

minetest.register_node("chemistry:plutonium_block", {
	description = ("Plutonium Block"),
	tiles = {"plutonium_block.png"},
	is_ground_content = true,
	groups = {cracky = 2, radioactive = 6},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = 'chemistry:plutonium_block',
	recipe = {
		{'chemistry:plutonium', 'chemistry:plutonium', 'chemistry:plutonium'},
		{'chemistry:plutonium', 'chemistry:plutonium', 'chemistry:plutonium'},
		{'chemistry:plutonium', 'chemistry:plutonium', 'chemistry:plutonium'},
	}
})

minetest.register_craft({
	output = 'chemistry:plutonium 9',
	recipe = {
		{'chemistry:plutonium_block'},
	}
})

