 -- Sodium Hydroxide (used to make caustic water)

minetest.register_craftitem("chemistry:sodium_hydroxide", {
	description = ("Sodium Hydroxide"),
	inventory_image = "sodium_hydroxide.png",
})

minetest.register_craftitem("chemistry:potassium_hydroxide", {
	description = ("Potassium Hydroxide"),
	inventory_image = "potassium_hydroxide.png",
})

minetest.register_craftitem("chemistry:baking_soda", {
	description = ("Baking Soda"),
	inventory_image = "zinc_sulfide.png",
})

minetest.register_craftitem("chemistry:baking_soda_comp", {
	description = ("Baking Soda Compound"),
	inventory_image = "liquid_bucket.png",
})

minetest.register_craft({
	output = 'chemistry:sodium_hydroxide',
	recipe = {
		{'bucket:bucket_water', 'chemistry:sodium'},
	},
	replacements = {{'bucket:bucket_water', 'bucket:bucket_empty'}},
})

minetest.register_craft({
	output = 'chemistry:potassium_hydroxide',
	recipe = {
		{'bucket:bucket_water', 'chemistry:potassium'},
	},
	replacements = {{'bucket:bucket_water', 'bucket:bucket_empty'}},
})

minetest.register_craft({
	output = 'chemistry:cwater_bucket',
	recipe = {
		{'bucket:bucket_water', 'chemistry:sodium_hydroxide'},
	}
})

-- Aluminium (reactive, same as lithium but protected with oxide layer)


minetest.register_craftitem("chemistry:aluminium", {
	description = ("Aluminium"),
	inventory_image = "aluminium.png",
})

minetest.register_node("chemistry:aluminium_block", {
	description = ("Aluminium Block"),
	tiles = {"aluminium_block.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 1},
	sounds = default.node_sound_metal_defaults(),
})


minetest.register_craft({
	output = 'chemistry:aluminium_block',
	recipe = {
		{'chemistry:aluminium', 'chemistry:aluminium', 'chemistry:aluminium'},
		{'chemistry:aluminium', 'chemistry:aluminium', 'chemistry:aluminium'},
		{'chemistry:aluminium', 'chemistry:aluminium', 'chemistry:aluminium'},
	}
})

-- Aluminum Items from Aluminium Block Crafting
minetest.register_craft({
	output = 'chemistry:aluminium 9',
	recipe = {
		{'chemistry:aluminium_block'},
	}
})

minetest.register_tool("chemistry:aluminium_pick", {
	description = ("Aluminium Pickaxe"),
	inventory_image = "aluminium_pick.png",
	tool_capabilities = {
		full_punch_interval = 1.5,
		max_drop_level=1,
		groupcaps={
			cracky = {times={[1]=0.80, [2]=0.80, [3]=0.80}, uses=50, maxlevel=2},
		},
		damage_groups = {fleshy=5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1}
})

minetest.register_tool("chemistry:aluminium_sword", {
	description = ("Aluminium Sword"),
	inventory_image = "aluminium_sword.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=0.5, [2]=0.20, [3]=0.35}, uses=50, maxlevel=2},
		},
		damage_groups = {fleshy=6},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_craft({
	output = 'chemistry:aluminium_pick',
	recipe = {
		{'chemistry:aluminium', 'chemistry:aluminium', 'chemistry:aluminium'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:aluminium_axe',
	recipe = {
		{'chemistry:aluminium', 'chemistry:aluminium', ''},
		{'chemistry:aluminium', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:aluminium_shovel',
	recipe = {
		{'', 'chemistry:aluminium', ''},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:aluminium_sword',
	recipe = {
		{'', 'chemistry:aluminium', ''},
		{'', 'chemistry:aluminium', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_tool("chemistry:aluminium_shovel", {
	description = ("Aluminium Shovel"),
	inventory_image = "aluminium_shovel.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=0.50, [2]=0.90, [3]=0.40}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=1},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_tool("chemistry:aluminium_axe", {
	description = ("Aluminium Axe"),
	inventory_image = "aluminium_axe.png",
	tool_capabilities = {
		full_punch_interval = 2.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=1.30, [2]=1.30, [3]=0.90}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=4},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
})


-- Ore generation
-- -128 <-> -255

local output_node = {name="chemistry:hydrogen"}
	minetest.register_abm({
		label = "chemistry:aluminium_reaction",
		nodenames = {"group:acid"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:aluminium_block", "chemistry:zinc_block"},
		interval = 1.0,
		chance = 7,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, output_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

-- Gallium (low melting point, can react with aluminum to create a soft alloy)

-- Gallium Item
minetest.register_craftitem("chemistry:gallium", {
	description = ("Gallium"),
	inventory_image = "gallium.png",
})


minetest.register_node("chemistry:gallium_block", {
	description = ("Gallium Block"),
	tiles = {"gallium_block.png"},
	is_ground_content = true,
	groups = {cracky = 1},
	sounds = default.node_sound_metal_defaults(),
})


minetest.register_craft({
	output = 'chemistry:gallium_block',
	recipe = {
		{'chemistry:gallium', 'chemistry:gallium', 'chemistry:gallium'},
		{'chemistry:gallium', 'chemistry:gallium', 'chemistry:gallium'},
		{'chemistry:gallium', 'chemistry:gallium', 'chemistry:gallium'},
	}
})

-- Gallium Items from Gallium Block Crafting
minetest.register_craft({
	output = 'chemistry:gallium 9',
	recipe = {
		{'chemistry:gallium_block'},
	}
})

-- Ore generation
-- -128 <-> -255

minetest.register_node("chemistry:lgallium", {
	description = ("Liquid Gallium"),
	drawtype = "liquid",
	tiles = {
		{
			name = "lgallium.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "lgallium.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	paramtype = "light",
	light_source = 0,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:lgallium_flowing",
	liquid_alternative_source = "chemistry:lgallium",
	liquid_viscosity = 1,
	liquid_renewable = false,
	damage_per_second = 0,
	post_effect_color = {a = 0, r = 0, g = 0, b = 0},
	groups = {liquid = 1},
})

minetest.register_node("chemistry:lgallium_flowing", {
	description = "Liquid Gallium Flowing",
	drawtype = "flowingliquid",
	tiles = {"lgallium.png"},
	special_tiles = {
		{
			name = "lgallium.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 4,
			},
		},
		{
			name = "lgallium.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 4,
			},
		},
	},
	paramtype = "light",
	paramtype2 = "flowingliquid",
	light_source = 0,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:lgallium_flowing",
	liquid_alternative_source = "chemistry:lgallium",
	liquid_viscosity = 1,
	liquid_renewable = false,
	damage_per_second = 0,
	post_effect_color = {a = 0, r = 0, g = 0, b = 0},
	groups = {liquid = 1, not_in_creative_inventory = 1},
})

	bucket.register_liquid(
		"chemistry:lgallium",
		"chemistry:lgallium_flowing",
		"chemistry:lgallium_bucket",
		"lgallium_bucket.png",
		("Liquid Gallium Bucket"),
		{tool = 1}
	)


minetest.register_craftitem("chemistry:bismuth", {
	description = ("Bismuth"),
	inventory_image = "bismuth.png",
})


minetest.register_node("chemistry:bismuth_block", {
	description = ("Bismuth Block"),
	tiles = {"bismuth_block.png"},
	is_ground_content = true,
	groups = {cracky = 1},
	sounds = default.node_sound_metal_defaults(),
})


minetest.register_craft({
	output = 'chemistry:bismuth_block',
	recipe = {
		{'chemistry:bismuth', 'chemistry:bismuth', 'chemistry:bismuth'},
		{'chemistry:bismuth', 'chemistry:bismuth', 'chemistry:bismuth'},
		{'chemistry:bismuth', 'chemistry:bismuth', 'chemistry:bismuth'},
	}
})

minetest.register_craft({
	output = 'chemistry:bismuth 9',
	recipe = {
		{'chemistry:bismuth_block'},
	}
})

-- Ore generation
-- -128 <-> -255

minetest.register_node("chemistry:bismuth_crystal", {
	description = ("Bismuth Crystal"),
	drawtype = "plantlike",
	tiles = {"bismuth_crystal.png"},
	inventory_image = "bismuth_crystal.png",
	wield_image = "bismuth_crystal.png",
	paramtype = "light",
	light_source = 0,
	sunlight_propagates = true,
	walkable = true,
	damage_per_second = 1,
	groups = {cracky = 1, attached_node = 1},
	sounds = default.node_sound_glass_defaults(),
	selection_box = {
		type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
	},
	node_box = {
		type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
	},
	drop = {
		max_items = 1,
		items = {
			{
				items = {'chemistry:bismuth'},  --The first and second drops ever
			},
      }
   },
})

minetest.register_node("chemistry:lbismuth", {
	description = ("Liquid Bismuth"),
	drawtype = "liquid",
	tiles = {
		{
			name = "lbismuth_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 6.0,
			},
		},
		{
			name = "lbismuth_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 6.0,
			},
		},
	},
	paramtype = "light",
	light_source = 0,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:lbismuth_flowing",
	liquid_alternative_source = "chemistry:lbismuth",
	liquid_viscosity = 1,
	liquid_renewable = false,
	damage_per_second = 5,
	post_effect_color = {a = 0, r = 0, g = 0, b = 0},
	groups = {liquid = 1},
})

minetest.register_node("chemistry:lbismuth_flowing", {
	description = "Liquid Bismuth Flowing",
	drawtype = "flowingliquid",
	tiles = {"lbismuth.png"},
	special_tiles = {
		{
			name = "lbismuth_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 4,
			},
		},
		{
			name = "lbismuth_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 4,
			},
		},
	},
	paramtype = "light",
	paramtype2 = "flowingliquid",
	light_source = 0,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:lbismuth_flowing",
	liquid_alternative_source = "chemistry:lbismuth",
	liquid_viscosity = 1,
	liquid_renewable = false,
	damage_per_second = 5,
	post_effect_color = {a = 0, r = 0, g = 0, b = 0},
	groups = {liquid = 1, not_in_creative_inventory = 1},
})

	bucket.register_liquid(
		"chemistry:lbismuth",
		"chemistry:lbismuth_flowing",
		"chemistry:lbismuth_bucket",
		"lbismuth_bucket.png",
		("Liquid Bismuth Bucket"),
		{tool = 1}
	)

-- Aluminium alloy Block (Same as aluminium but the oxide layer is destroyed due to gallium, can react with water and it is soluble)

local input_node = {name="chemistry:gallium_aluminium_alloy"}
	minetest.register_abm({
		label = "chemistry: gallium and aluminium reaction",
		nodenames = {"chemistry:aluminium_block"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:lgallium", "chemistry:lgallium_flowing"},
		interval = 1.0,
		chance = 7,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, input_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_node("chemistry:gallium_aluminium_alloy", {
	description = ("Aluminium Alloy Block"),
	tiles = {"aluminium_block.png^gallium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 1, oddly_breakable_by_hand = 1},
	sounds = default.node_sound_stone_defaults(),
})

local input_node = {name="chemistry:hydrogen"}
	minetest.register_abm({
		label = "chemistry: aluminium ignition",
		nodenames = {"group:water"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:gallium_aluminium_alloy"},
		interval = 1.0,
		chance = 2,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, input_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

local output_node = {name="air"}
	minetest.register_abm({
		label = "chemistry: aluminium ignition",
		nodenames = {"chemistry:gallium_aluminium_alloy"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:water"},
		interval = 1.0,
		chance = 15,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, output_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

local input_node2 = {name="chemistry:lgallium"}
	minetest.register_abm({
		label = "chemistry: gallium melting",
		nodenames = {"chemistry:gallium_block"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:fire", "group:lava"},
		interval = 1.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:igniter") then
				minetest.swap_node(pos, input_node2)
			end	
		end,
	})

local input_node2 = {name="chemistry:lbismuth"}
	minetest.register_abm({
		label = "chemistry: bismuth melting",
		nodenames = {"chemistry:bismuth_block"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:lava", "group:magnesium_fire"},
		interval = 10.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:igniter") then
				minetest.swap_node(pos, input_node2)
			end	
		end,
	})

local input_node2 = {name="default:lava_source"}
	minetest.register_abm({
		label = "chemistry:stone Melting",
		nodenames = {"default:stone"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:magnesium_fire"},
		interval = 10.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:igniter") then
				minetest.swap_node(pos, input_node2)
			end	
		end,
	})

local input_node2 = {name="chemistry:bismuth_crystal"}
	minetest.register_abm({
		label = "chemistry: bismuth cooling",
		nodenames = {"chemistry:lbismuth_flowing"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:cools_lava"},
		interval = 2.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:cools_lava") then
				minetest.swap_node(pos, input_node2)
				minetest.sound_play(
					"default_cool_lava",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local input_node2 = {name="chemistry:bismuth_block"}
	minetest.register_abm({
		label = "chemistry: bismuth cooling",
		nodenames = {"chemistry:lbismuth"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:cools_lava"},
		interval = 2.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:cools_lava") then
				minetest.swap_node(pos, input_node2)
				minetest.sound_play(
					"default_cool_lava",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local input_node2 = {name="chemistry:gallium_block"}
	minetest.register_abm({
		label = "chemistry: gallium cooling",
		nodenames = {"chemistry:lgallium"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"air"},
		interval = 1.0,
		chance = 15,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "chemistry:gallium_block") then
				minetest.swap_node(pos, input_node2)
			end	
		end,
	})

-- Sulfur (non-metal that has many uses in metals reactions and products)


minetest.register_craftitem("chemistry:sulfur", {
	description = ("Sulfur"),
	inventory_image = "sulfur.png",
})

minetest.register_node("chemistry:sulfur_block", {
	description = ("Sulfur Block"),
	tiles = {"sulfur_block.png"},
	is_ground_content = true,
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craft({
	output = 'chemistry:sulfur_block',
	recipe = {
		{'chemistry:sulfur', 'chemistry:sulfur', 'chemistry:sulfur'},
		{'chemistry:sulfur', 'chemistry:sulfur', 'chemistry:sulfur'},
		{'chemistry:sulfur', 'chemistry:sulfur', 'chemistry:sulfur'},
	}
})


minetest.register_craft({
	output = 'chemistry:sulfur 9',
	recipe = {
		{'chemistry:sulfur_block'},
	}
})

-- Ore generation
-- -1 <-> -255

minetest.register_craftitem("chemistry:sulfur_comp", {
	description = ("Sulfuric Compound"),
	inventory_image = "sulfur_comp.png",
})

minetest.register_craft({
	output = 'chemistry:sulfur_comp',
	recipe = {
		{'fire:flint_and_steel', 'chemistry:sulfur', 'chemistry:sodium_hydroxide'},
	},
	replacements = {{'fire:flint_and_steel', 'fire:flint_and_steel'}},
})

minetest.register_craft({
	output = 'chemistry:hso_acid_bucket',
	recipe = {
		{'chemistry:sulfur_comp', 'bucket:bucket_water'},
	},
	replacements = {{'bucket:bucket_water', 'bucket:bucket_empty'}},
})


minetest.register_node("chemistry:nitrogen_dioxide", {
	description = ("Nitrogen Dioxide Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 10,
   damage_per_second = 5,
	post_effect_color = {a = 80, r = 122, g = 88, b = 0},
	tiles = {"nitrogen_dioxide.png^[opacity:95"},
	wield_image = "nitrogen_dioxide_wl.png",
	inventory_image = "nitrogen_dioxide_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local directions = {
	{x=1, y=0, z=0},
	{x=-1, y=0, z=0},
	{x=0, y=0, z=1},
	{x=0, y=0, z=-1},
}

local gas_node = {name="chemistry:nitrogen_dioxide"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:nitrogen_dioxide"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

minetest.register_craftitem("chemistry:zinc_sulfide", {
	description = ("Zinc Sulfide"),
	inventory_image = "zinc_sulfide.png",
})

minetest.register_craft({
	output = 'chemistry:zinc_sulfide',
	recipe = {
		{'chemistry:sulfur', 'chemistry:zinc_dust', 'fire:flint_and_steel'},
	},
	replacements = {{'fire:flint_and_steel', 'fire:flint_and_steel'}},
})

minetest.register_node("chemistry:ethanol", {
	description = ("Ethanol"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:ethanol_flowing",
	liquid_alternative_source = "chemistry:ethanol",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, cools_lava = 1, flammable = 1, very_flammable = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:ethanol_flowing", {
	description = ("Flowing Ethanol"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:ethanol_flowing",
	liquid_alternative_source = "chemistry:ethanol",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, flammable =1, very_flammable = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:ethanol",
		"chemistry:ethanol_flowing",
		"chemistry:ethanol_bucket",
		"acid_bucket.png",
		("Ethanol Bucket"),
		{tool = 1, volatile = 1}
	)

local output_node5 = {name="fire:basic_flame"}
minetest.register_abm({
		label = "chemistry: ethanol ignition",
		nodenames = {"air"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:very_flammable"},
		interval = 1.0,
		chance = 6,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:igniter") then
				minetest.swap_node(pos, output_node5)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry: phosphorus ignition",
		nodenames = {"air"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:white_phosphorus"},
		interval = 5.0,
		chance = 6,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, output_node5)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry: phosphorus ignition2",
		nodenames = {"chemistry:white_phosphorus"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:fire"},
		interval = 1.0,
		chance = 12,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				tnt.boom(pos, chemical_boom)
				if math.random() < 0.5 then
					minetest.set_node(pos, {name="fire:basic_flame"})
				end
			end	
		end,
	})

local red_trans = {name ="chemistry:white_phosphorus"}
minetest.register_abm({
		label = "chemistry: phosphorus transform",
		nodenames = {"chemistry:red_phosphorus"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:fire"},
		interval = 5.0,
		chance = 6,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:fire") then
				minetest.swap_node(pos, red_trans)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_node("chemistry:white_phosphorus", {
	description = ("White Phosphorus"),
	tiles = {"white_phosphorus.png"},
	is_ground_content = true,
	groups = {cracky = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:red_phosphorus", {
	description = ("Red Phosphorus"),
	tiles = {"red_phosphorus.png"},
	groups = {crumbly = 3, falling_node = 1},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:purple_phosphorus", {
	description = ("Purple Phosphorus"),
	tiles = {"purple_phosphorus.png"},
	groups = {crumbly = 3, falling_node = 1},
	on_blast = function(pos)
		tnt.boom(pos, chemical_boom2)
	end,
	sounds = default.node_sound_sand_defaults(),
})

local chemical_boom = {
	name = "chemical_boom",
	--description = "explosion caused by chemical reactions",
	radius = 1,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

tnt.register_tnt(chemical_boom)

local chemical_boom2 = {
	name = "chemical_boom2",
	--description = "explosion caused by chemical reactions",
	radius = 5,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

tnt.register_tnt(chemical_boom2)

minetest.register_craft({
	type = "cooking",
	cooktime = 6,
	output = "chemistry:red_phosphorus",
	recipe = "chemistry:purple_phosphorus"
})

minetest.register_craftitem("chemistry:zinc", {
	description = ("Zinc"),
	inventory_image = "zinc.png",
})

minetest.register_craftitem("chemistry:zinc_dust", {
	description = ("Zinc Dust"),
	inventory_image = "zinc_dust.png",
})


minetest.register_node("chemistry:zinc_block", {
	description = ("Zinc Block"),
	tiles = {"zinc_block.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
})


minetest.register_craft({
	output = 'chemistry:zinc_block',
	recipe = {
		{'chemistry:zinc', 'chemistry:zinc', 'chemistry:zinc'},
		{'chemistry:zinc', 'chemistry:zinc', 'chemistry:zinc'},
		{'chemistry:zinc', 'chemistry:zinc', 'chemistry:zinc'},
	}
})

minetest.register_craft({
	output = 'chemistry:zinc 9',
	recipe = {
		{'chemistry:zinc_block'},
	}
})

-- Ore generation
-- -128 <-> -255


minetest.register_craftitem("chemistry:titanium", {
	description = ("Titanium"),
	inventory_image = "titanium.png",
})

minetest.register_craftitem("chemistry:titanium_raw", {
	description = ("Raw Titanium"),
	inventory_image = "titanium_raw.png",
})

minetest.register_node("chemistry:titanium_block", {
	description = ("Titanium Block"),
	tiles = {"titanium_block.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 3},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	type = "cooking",
	cooktime = 3,
	output = "chemistry:titanium",
	recipe = "chemistry:titanium_raw"
})

minetest.register_craft({
	output = 'chemistry:titanium_block',
	recipe = {
		{'chemistry:titanium', 'chemistry:titanium', 'chemistry:titanium'},
		{'chemistry:titanium', 'chemistry:titanium', 'chemistry:titanium'},
		{'chemistry:titanium', 'chemistry:titanium', 'chemistry:titanium'},
	}
})

minetest.register_craft({
	output = 'chemistry:titanium 9',
	recipe = {
		{'chemistry:titanium_block'},
	}
})

-- Ore generation
-- -128 <-> -255

minetest.register_tool("chemistry:titanium_sword", {
	description = ("Titanium Sword"),
	inventory_image = "default_tool_steelsword.png^[brighten:75",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=0.5, [2]=0.20, [3]=0.35}, uses=380, maxlevel=3},
		},
		damage_groups = {fleshy=9},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_craft({
	output = 'chemistry:titanium_pick',
	recipe = {
		{'chemistry:titanium', 'chemistry:titanium', 'chemistry:titanium'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:titanium_axe',
	recipe = {
		{'chemistry:titanium', 'chemistry:titanium', ''},
		{'chemistry:titanium', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:titanium_shovel',
	recipe = {
		{'', 'chemistry:titanium', ''},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:titanium_sword',
	recipe = {
		{'', 'chemistry:titanium', ''},
		{'', 'chemistry:titanium', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_tool("chemistry:titanium_pick", {
	description = ("Titanium Pickaxe"),
	inventory_image = "default_tool_steelpick.png^[brighten:75",
	tool_capabilities = {
		full_punch_interval = 1.5,
		max_drop_level=1,
		groupcaps={
			cracky = {times={[1]=0.80, [2]=0.80, [3]=0.80}, uses=180, maxlevel=3},
		},
		damage_groups = {fleshy=8},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1}
})

minetest.register_tool("chemistry:titanium_shovel", {
	description = ("Titanium Shovel"),
	inventory_image = "default_tool_steelshovel.png^[brighten:75",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=0.50, [2]=0.90, [3]=0.40}, uses=270, maxlevel=3},
		},
		damage_groups = {fleshy=6},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_tool("chemistry:titanium_axe", {
	description = ("Titanium Axe"),
	inventory_image = "default_tool_steelaxe.png^[brighten:75",
	tool_capabilities = {
		full_punch_interval = 2.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=1.30, [2]=1.30, [3]=0.90}, uses=200, maxlevel=3},
		},
		damage_groups = {fleshy=8},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
})


minetest.register_craftitem("chemistry:magnesium", {
	description = ("Magnesium"),
	inventory_image = "magnesium.png",
})

minetest.register_node("chemistry:magnesium_block", {
	description = ("Magnesium Block"),
	tiles = {"magnesium_block.png"},
	is_ground_content = true,
	groups = {cracky = 3},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	output = 'chemistry:magnesium_block',
	recipe = {
		{'chemistry:magnesium', 'chemistry:magnesium', 'chemistry:magnesium'},
		{'chemistry:magnesium', 'chemistry:magnesium', 'chemistry:magnesium'}, 
      {'chemistry:magnesium', 'chemistry:magnesium', 'chemistry:magnesium'},
	}
})

minetest.register_craft({
	output = 'chemistry:magnesium 9',
	recipe = {
		{'chemistry:magnesium_block'},
	}
})

-- Ore generation
-- -128 <-> -255

minetest.register_node("chemistry:magnesium_fire", {
	description = ("Magnesium Fire"),
	drawtype = "firelike",
	tiles = {{
		name = "magnesium_fire_animated.png",
		animation = {
			type = "vertical_frames",
			aspect_w = 16,
			aspect_h = 16,
			length = 1
		}}
	},
	inventory_image = "magnesium_fire.png",
	paramtype = "light",
	light_source = 20,
	walkable = false,
	buildable_to = true,
	sunlight_propagates = true,
	floodable = false,
	damage_per_second = 5,
	groups = {igniter = 2, fire = 1, magnesium_fire = 1},
	drop = "",
   on_timer = function(pos)
	if not minetest.find_node_near(pos, 1, {"chemistry:magnesium_block"}) then
		minetest.remove_node(pos)
		return
	end
	return true
end,
   on_construct = function(pos)
	minetest.get_node_timer(pos):start(math.random(5, 10))
end,
})

minetest.register_node("chemistry:permanent_magnesium_fire", {
	description = ("Permanent Magnesium Fire"),
	drawtype = "firelike",
	tiles = {{
		name = "magnesium_fire_animated.png",
		animation = {
			type = "vertical_frames",
			aspect_w = 16,
			aspect_h = 16,
			length = 1
		}}
	},
	inventory_image = "magnesium_fire.png",
	paramtype = "light",
	light_source = 20,
	walkable = false,
	buildable_to = true,
	sunlight_propagates = true,
	floodable = false,
	damage_per_second = 5,
	groups = {igniter = 2, fire = 1, magnesium_fire = 1},
	drop = "",
})

	minetest.register_abm({
		label = "Remove magnesium nodes",
		nodenames = {"chemistry:magnesium_fire"},
		neighbors = "chemistry:magnesium_block",
		interval = 1,
		chance = 18,
		catch_up = false,
		action = function(pos)
			local p = minetest.find_node_near(pos, 1, {"chemistry:magnesium_block"})
			if not p then
				return
			end
			local flammable_node = minetest.get_node(p)
			local def = minetest.registered_nodes[flammable_node.name]
			if def.on_burn then
				def.on_burn(p)
			else
				minetest.remove_node(p)
				minetest.check_for_falling(p)
			end
		end,
	})

	minetest.register_abm({
		label = "Ignite flame",
		nodenames = {"air"},
		neighbors = {"chemistry:magnesium_block"},
		interval = 1,
		chance = 12,
		catch_up = true,
		action = function(pos)
			local p = minetest.find_node_near(pos, 1, {"group:igniter"})
			if p then
				minetest.set_node(pos, {name = "chemistry:magnesium_fire"})
			end
		end
	})

minetest.register_node("chemistry:vinegar", {
	description = ("White Vinegar"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:vinegar_flowing",
	liquid_alternative_source = "chemistry:vinegar",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:vinegar_flowing", {
	description = ("Flowing White Vinegar"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:vinegar_flowing",
	liquid_alternative_source = "chemistry:vinegar",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:vinegar",
		"chemistry:vinegar_flowing",
		"chemistry:vinegar_bucket",
		"liquid_bucket.png",
		("White Vinegar Bucket"),
		{tool = 1}
	)

minetest.register_node("chemistry:sodium_acetate_crystals", {
	description = ("Sodium Acetate Crystals"),
	tiles = {"sodium_acetate_crystals.png"},
	is_ground_content = true,
	groups = {oddly_breakable_by_hand = 2},
	sounds = default.node_sound_snow_defaults(),
})

minetest.register_node("chemistry:saturated_sodium_acetate", {
	description = ("Supersaturated Sodium Acetate"),
	tiles = {"saturated_sodium_acetate.png"},
	is_ground_content = true,
	groups = {oddly_breakable_by_hand = 1, cracky = 3},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:saturated_sodium_acetate_2", {
	description = ("Supersaturated Sodium Acetate"),
	tiles = {"saturated_sodium_acetate.png"},
	is_ground_content = true,
	drop = {
		max_items = 1,
		items = {
			{
				items = {'chemistry:saturated_sodium_acetate 1'},  --The first and second drops ever
			}
      }
   },
	groups = {oddly_breakable_by_hand = 1, cracky = 3, not_in_creative_inventory = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	type = "cooking",
	cooktime = 30,
	output = "chemistry:sodium_acetate_bucket",
	recipe = "chemistry:baking_soda_comp"
})

minetest.register_craft({
	output = 'chemistry:baking_soda_comp',
	recipe = {
      {'chemistry:baking_soda', 'chemistry:baking_soda', 'chemistry:baking_soda'},
		{'chemistry:baking_soda', 'chemistry:vinegar_bucket', 'chemistry:baking_soda'},
      {'chemistry:baking_soda', 'chemistry:baking_soda', 'chemistry:baking_soda'},
	},
	replacements = {{'chemistry:vinegar_bucket', 'chemistry:sodium_acetate_crystals'}},
})

minetest.register_node("chemistry:sodium_acetate", {
	description = ("Sodium Acetate"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:190",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:190",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:sodium_acetate_flowing",
	liquid_alternative_source = "chemistry:sodium_acetate",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:sodium_acetate_flowing", {
	description = ("Flowing Sodium Acetate"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:190",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:190",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:sodium_acetate_flowing",
	liquid_alternative_source = "chemistry:sodium_acetate",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:sodium_acetate",
		"chemistry:sodium_acetate_flowing",
		"chemistry:sodium_acetate_bucket",
		"liquid_bucket.png",
		("Sodium Acetate Bucket"),
		{tool = 1}
	)

local sodium_acetate = {"chemistry:sodium_acetate", "chemistry:sodium_acetate_flowing"}
local saturated_sodium_acetate = {"chemistry:sodium_acetate_crystals", "chemistry:saturated_sodium_acetate"}
local output_node = {name="chemistry:saturated_sodium_acetate_2"}
	minetest.register_abm({
		label = "chemistry:sodium acetate form",
		nodenames = sodium_acetate,
		neighbors = saturated_sodium_acetate,
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, saturated_sodium_acetate) then
				minetest.swap_node(pos, output_node)
			end	
		end,
	})

	minetest.register_abm({
		label = "chemistry:sodium acetate form",
		nodenames = {"chemistry:saturated_sodium_acetate_2"}, 
		neighbors = saturated_sodium_acetate,
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, saturated_sodium_acetate) then
				minetest.swap_node(pos, {name="chemistry:saturated_sodium_acetate"})
			end	
		end,
	})

	minetest.register_abm({
		label = "chemistry:sodium acetate melting",
		nodenames = {"default:ice"}, 
		neighbors = {"chemistry:saturated_sodium_acetate"},
		interval = 20.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, saturated_sodium_acetate) then
				minetest.swap_node(pos, {name="default:water_source"})
			end	
		end,
	})

	minetest.register_abm({
		label = "chemistry:sodium acetate melting",
		nodenames = {"chemistry:gallium_block"}, 
		neighbors = {"chemistry:saturated_sodium_acetate"},
		interval = 10.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, saturated_sodium_acetate) then
				minetest.swap_node(pos, {name="chemistry:lgallium"})
			end	
		end,
	})

minetest.register_craftitem("chemistry:tungsten", {
	description = ("Tungsten"),
	inventory_image = "tungsten.png",
})

minetest.register_craftitem("chemistry:tungsten_raw", {
	description = ("Raw Tungsten"),
	inventory_image = "tungsten_raw.png",
})

minetest.register_node("chemistry:tungsten_block", {
	description = ("Tungsten Block"),
	tiles = {"tungsten_block.png"},
	is_ground_content = true,
	on_blast = function() end,
	groups = {cracky = 1, level = 4},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	type = "cooking",
	cooktime = 7,
	output = "chemistry:tungsten",
	recipe = "chemistry:tungsten_raw"
})

minetest.register_craft({
	output = 'chemistry:tungsten_block',
	recipe = {
		{'chemistry:tungsten', 'chemistry:tungsten', 'chemistry:tungsten'},
		{'chemistry:tungsten', 'chemistry:tungsten', 'chemistry:tungsten'},
		{'chemistry:tungsten', 'chemistry:tungsten', 'chemistry:tungsten'},
	}
})

minetest.register_craft({
	output = 'chemistry:tungsten 9',
	recipe = {
		{'chemistry:tungsten_block'},
	}
})

-- Ore generation
-- -128 <-> -255

minetest.register_tool("chemistry:tungsten_sword", {
	description = ("Tungsten Sword"),
	inventory_image = "tungsten_sword.png",
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=0.5, [2]=0.20, [3]=0.35}, uses=680, maxlevel=5},
		},
		damage_groups = {fleshy=14},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_craft({
	output = 'chemistry:tungsten_pick',
	recipe = {
		{'chemistry:tungsten', 'chemistry:tungsten', 'chemistry:tungsten'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:tungsten_axe',
	recipe = {
		{'chemistry:tungsten', 'chemistry:tungsten', ''},
		{'chemistry:tungsten', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:tungsten_shovel',
	recipe = {
		{'', 'chemistry:tungsten', ''},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:tungsten_sword',
	recipe = {
		{'', 'chemistry:tungsten', ''},
		{'', 'chemistry:tungsten', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_tool("chemistry:tungsten_pick", {
	description = ("Tungsten Pickaxe"),
	inventory_image = "tungsten_pick.png",
	tool_capabilities = {
		full_punch_interval = 1.9,
		max_drop_level=1,
		groupcaps={
			cracky = {times={[1]=1.80, [2]=0.90, [3]=0.45}, uses=400, maxlevel=5},
		},
		damage_groups = {fleshy=12},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1}
})

minetest.register_tool("chemistry:tungsten_shovel", {
	description = ("Tungsten Shovel"),
	inventory_image = "tungsten_shovel.png",
	tool_capabilities = {
		full_punch_interval = 2.0,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=0.20, [2]=0.20, [3]=0.05}, uses=470, maxlevel=5},
		},
		damage_groups = {fleshy=10},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_tool("chemistry:tungsten_axe", {
	description = ("Tungsten Axe"),
	inventory_image = "tungsten_axe.png",
	tool_capabilities = {
		full_punch_interval = 5.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=1.20, [2]=0.60, [3]=0.30}, uses=600, maxlevel=5},
		},
		damage_groups = {fleshy=13},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
})

minetest.register_craftitem("chemistry:gallium_ingot_bucket", {
	description = ("Bucket With Gallium ingots"),
	inventory_image = "gallium_ingot_bucket.png",
})

minetest.register_craftitem("chemistry:bismuth_lump_bucket", {
	description = ("Bucket with Bismuth lumps"),
	inventory_image = "bismuth_lump_bucket.png",
})

minetest.register_craftitem("chemistry:cesium_shard_bucket", {
	description = ("Bucket with Cesium shards"),
	inventory_image = "cesium_shard_bucket.png",
})

minetest.register_craft({
	type = "cooking",
	cooktime = 1,
	output = "chemistry:cesium_bucket",
	recipe = "chemistry:cesium_shard_bucket"
})

minetest.register_craft({
	type = "cooking",
	cooktime = 10,
	output = "chemistry:lbismuth_bucket",
	recipe = "chemistry:bismuth_lump_bucket"
})

minetest.register_craft({
	type = "cooking",
	cooktime = 5,
	output = "chemistry:lgallium_bucket",
	recipe = "chemistry:gallium_ingot_bucket"
})

minetest.register_craft({
	output = 'chemistry:bismuth_lump_bucket',
	recipe = {
		{'chemistry:bismuth', 'chemistry:bismuth', 'chemistry:bismuth'},
		{'chemistry:bismuth', 'bucket:bucket_empty', 'chemistry:bismuth'},
		{'chemistry:bismuth', 'chemistry:bismuth', 'chemistry:bismuth'},
	}
})

minetest.register_craft({
	output = 'chemistry:gallium_ingot_bucket',
	recipe = {
		{'chemistry:gallium', 'chemistry:gallium', 'chemistry:gallium'},
		{'chemistry:gallium', 'bucket:bucket_empty', 'chemistry:gallium'},
		{'chemistry:gallium', 'chemistry:gallium', 'chemistry:gallium'},
	}
})

minetest.register_craft({
	output = 'chemistry:cesium_shard_bucket',
	recipe = {
		{'chemistry:cesium_shard', 'chemistry:cesium_shard', 'chemistry:cesium_shard'},
		{'chemistry:cesium_shard', 'bucket:bucket_empty', 'chemistry:cesium_shard'},
		{'chemistry:cesium_shard', 'chemistry:cesium_shard', 'chemistry:cesium_shard'},
	}
})


minetest.register_craftitem("chemistry:manganese", {
	description = ("Manganese"),
	inventory_image = "manganese.png",
})

minetest.register_craftitem("chemistry:manganese_oxide", {
	description = ("Manganese Oxide"),
	inventory_image = "manganese_oxide.png",
})

minetest.register_node("chemistry:steelblock", {
	description = ("Steel-Manganese alloy Block"),
	tiles = {"default_steel_block.png^[colorize:red:50"},
	is_ground_content = false,
	groups = {cracky = 1, level = 3},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craftitem("chemistry:steel_ingot", {
	description = ("Steel-Manganese alloy Ingot"),
	inventory_image = "default_steel_ingot.png^[colorize:red:50"
})

minetest.register_tool("chemistry:steel_sword", {
	description = ("Steel-Manganese alloy Sword"),
	inventory_image = "default_tool_steelsword.png^[colorize:red:50",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.5, [2]=1.20, [3]=0.35}, uses=70, maxlevel=3},
		},
		damage_groups = {fleshy=8},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_tool("chemistry:steel_axe", {
	description = ("Steel-Manganese alloy Axe"),
	inventory_image = "default_tool_steelaxe.png^[colorize:red:50",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.25, [2]=1.20, [3]=0.75}, uses=70, maxlevel=3},
		},
		damage_groups = {fleshy=7},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1}
})

minetest.register_tool("chemistry:steel_shovel", {
	description = ("Steel-Manganese alloy Shovel"),
	inventory_image = "default_tool_steelshovel.png^[colorize:red:50",
	wield_image = "default_tool_steelshovel.png^[colorize:red:50",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=1.00, [2]=0.10, [3]=0.05}, uses=70, maxlevel=3},
		},
		damage_groups = {fleshy=5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1}
})

minetest.register_tool("chemistry:steel_pick", {
	description = ("Steel-Manganese alloy Pickaxe"),
	inventory_image = "default_tool_steelpick.png^[colorize:red:50",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			cracky = {times={[1]=3.70, [2]=1.40, [3]=0.65}, uses=70, maxlevel=3},
		},
		damage_groups = {fleshy=6},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1}
})

minetest.register_craft({
	output = 'chemistry:steel_pick',
	recipe = {
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:steel_axe',
	recipe = {
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', ''},
		{'chemistry:steel_ingot', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:steel_shovel',
	recipe = {
		{'', 'chemistry:steel_ingot', ''},
		{'', 'group:stick', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:steel_sword',
	recipe = {
		{'', 'chemistry:steel_ingot', ''},
		{'', 'chemistry:steel_ingot', ''},
		{'', 'group:stick', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:steelblock',
	recipe = {
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
	}
})

minetest.register_craft({
	output = 'chemistry:steel_ingot 9',
	recipe = {
		{'chemistry:steelblock'},
	}
})

minetest.register_craft({
	output = 'chemistry:steelblock',
	recipe = {
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
		{'chemistry:steel_ingot', 'chemistry:steel_ingot', 'chemistry:steel_ingot'},
	}
})

minetest.register_craftitem("chemistry:manganese_comp_bucket", {
	description = ("Bucket with Steel and Manganese"),
	inventory_image = "manganese_comp_bucket.png"
})

minetest.register_craft({
	output = 'chemistry:manganese_comp_bucket',
	recipe = {
		{'default:steel_ingot', 'chemistry:manganese', 'default:steel_ingot'},
		{'default:steel_ingot', 'bucket:bucket_empty', 'default:steel_ingot'},
		{'default:steel_ingot', 'default:steel_ingot', 'default:steel_ingot'},
	}
})

minetest.register_craftitem("chemistry:red_hot_comp_bucket", {
	description = ("Bucket with Red Hot Steel"),
	inventory_image = "manganese_comp_bucket.png^[colorize:red:125"
})

minetest.register_craft({
   output = 'chemistry:red_hot_steel_ingot 8',
   recipe = {
      {'chemistry:red_hot_comp_bucket'},
	},
   replacements = {{'chemistry:red_hot_comp_bucket', 'bucket:bucket_empty'}}
})

minetest.register_craftitem("chemistry:red_hot_steel_ingot", {
	description = ("Red Hot Steel-Manganese alloy Ingot"),
	inventory_image = "default_steel_ingot.png^[colorize:red:150"
})

minetest.register_craft({
   output = 'chemistry:steel_ingot',
   recipe = {
      {'group:water_bucket', 'chemistry:red_hot_steel_ingot'},
	},
   replacements = {{'group:water_bucket', 'bucket:bucket_empty'}}
})

minetest.register_craft({
	type = "cooking",
	cooktime = 20,
	output = "chemistry:red_hot_comp_bucket",
	recipe = "chemistry:manganese_comp_bucket"
})

