
local S = minetest.get_translator("chemistry")

minetest.register_node("chemistry:oxygen", {
	description = S("Oxygen Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 0,
   damage_per_second = -1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "oxygen_wl.png",
	inventory_image = "oxygen_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, gas=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

minetest.register_node("chemistry:nitrogen", {
	description = S("Nitrogen Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 1,
   damage_per_second = 0,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "nitrogen_wl.png",
	inventory_image = "nitrogen_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, gas=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

minetest.register_node("chemistry:hydrogen", {
	description = S("Hydrogen Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 1,
   damage_per_second = 0,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "hydrogen_wl.png",
	inventory_image = "hydrogen_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, fire_expander = 1, light_gas=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local directions = {
	{x=1, y=0, z=0},
	{x=-1, y=0, z=0},
	{x=0, y=0, z=1},
	{x=0, y=0, z=-1},
}
local orthogonal = {
	{x=0,y=0,z=1},
	{x=0,y=1,z=0},
	{x=1,y=0,z=0},
	{x=0,y=0,z=-1},
	{x=0,y=-1,z=0},
	{x=-1,y=0,z=0},
}

minetest.register_node("chemistry:carbon_dioxide", {
	description = S("Carbon Dioxide Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 0,
   damage_per_second = -1,
	post_effect_color = {a = 122, r = 22, g = 22, b = 22},
	tiles = {"carbon_dioxide.png^[opacity:180"},
	wield_image = "carbon_dioxide_wl.png",
	inventory_image = "carbon_dioxide_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, gas=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local gas_node = {name="chemistry:oxygen"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:oxygen"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local gas_node2 = {name="chemistry:nitrogen"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:nitrogen"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node2)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node2)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node2)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node2)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local input_node = {name="chemistry:nitrogen"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen vaporation",
		nodenames = {"chemistry:lnitrogen", "chemistry:lnitrogen_flowing"}, -- liquid gases turn back into gases
		neighbors = {"air"},
		interval = 1.0,
		chance = 19,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, input_node)
			end	
		end,
	})

local output_node = {name="default:ice"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen freezing",
		nodenames = {"default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"}, -- liquid that turn into solids
		neighbors = {"group:freezer"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:freezer") then
				minetest.swap_node(pos, output_node)
				minetest.sound_play(
					"freezing",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local output_node4 = {name="chemistry:dry_ice"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen freezing",
		nodenames = {"chemistry:carbon_dioxide"}, -- gases that go under inverse sublimation
		neighbors = {"group:freezer"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:freezer") then
				minetest.swap_node(pos, output_node4)
				minetest.sound_play(
					"freezing",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local output_node4 = {name="default:ice"}
	minetest.register_abm({
		label = "chemistry:dry ice freezing",
		nodenames = {"default:water_source", "default:water_flowing"}, -- gases that go under inverse sublimation
		neighbors = {"group:cools_water"},
		interval = 2.0,
		chance = 5,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:water") then
				minetest.swap_node(pos, output_node4)
				minetest.sound_play(
					"freezing",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local output_node2 = {name="chemistry:cesium_block"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen freezing2",
		nodenames = {"chemistry:cesium"}, -- reactive liquids dont react to nitrogen but can solidify it
		neighbors = {"group:freezer"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:freezer") then
				minetest.swap_node(pos, output_node2)
				minetest.sound_play(
					"default_cool_lava",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local output_node2 = {name="chemistry:cesium_crystal"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen freezing2",
		nodenames = {"chemistry:cesium_flowing"}, -- reactive liquids dont react to nitrogen but can solidify it
		neighbors = {"group:freezer"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:freezer") then
				minetest.swap_node(pos, output_node2)
				minetest.sound_play(
					"default_cool_lava",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local output_node3 = {name="chemistry:gallium_block"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen freezing2",
		nodenames = {"chemistry:lgallium", "chemistry:lgallium_flowing"}, -- this also affects low melting point nodes
		neighbors = {"group:freezer"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:freezer") then
				minetest.swap_node(pos, output_node3)
				minetest.sound_play(
					"default_cool_lava",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local input_node2 = {name="chemistry:nitrogen"}
	minetest.register_abm({
		label = "chemistry:liquid gases vaporation2",
		nodenames = {"group:freezer"}, -- hot liquids or plasma can make liquid gases to evaporate
		neighbors = {"group:torch", "group:igniter", "group:fire"},
		interval = 1.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:freezer") then
				minetest.swap_node(pos, input_node2)
				minetest.sound_play(
					"default_cool_lava",
					{pos = pos, max_hear_distance = 18, gain = 0.05}
             )
			end	
		end,
	})

local output_node5 = {name="fire:basic_flame"}
minetest.register_abm({
		label = "mine_gas:gas ignition",
		nodenames = {"group:fire_expander"}, -- checking for ignition sources
		neighbors = {"group:torch", "group:igniter", "group:fire"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, output_node5)
			end	
		end,
	})

local gas_node3 = {name="chemistry:hydrogen"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:hydrogen"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node3)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node3)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node3)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node3)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local gas_node4 = {name="chemistry:carbon_dioxide"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:carbon_dioxide"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node4)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node4)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node4)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node4)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local output_node6 = {name="default:water_source"}
minetest.register_abm({
		label = "chemistry: water generation",
		nodenames = {"chemistry:hydrogen"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:oxygen"},
		interval = 1.0,
		chance = 1,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 2, "chemistry:hydrogen") then
				minetest.swap_node(pos, output_node6)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry:oxygen combustion",
		nodenames = {"group:flammable"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:oxygen"},
		interval = 1.0,
		chance = 3,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:igniter") then
				minetest.swap_node(pos, {name="fire:basic_flame"})
				if math.random() < 0.1 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

	minetest.register_abm({
		label = "chemistry: lithium ignition",
		nodenames = {"chemistry:hydrogen"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:sodium_block", "chemistry:potassium_block"},
		interval = 1.0,
		chance = 3,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:water") then
				minetest.swap_node(pos, output_node5)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_node("chemistry:methane", {
	description = S("Methane Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 1,
   damage_per_second = 0,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "methane_wl.png",
	inventory_image = "methane_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, fire_expander = 1, light_gas=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local gas_node5 = {name="chemistry:methane"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:methane"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node5)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node5)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node5)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node5)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local input_node = {name="chemistry:methane"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen condensation",
		nodenames = {"chemistry:lmethane_flowing", "chemistry:lmethane"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"air"},
		interval = 1.0,
		chance = 19,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, input_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_node("chemistry:butane", {
	description = S("Butane Gas"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 1,
   damage_per_second = 0,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "butane_wl.png",
	inventory_image = "butane_wl.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, fire_expander = 1, light_gas=1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local gas_node5 = {name="chemistry:butane"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:butane"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node5)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node5)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node5)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node5)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local input_node = {name="chemistry:butane"}
	minetest.register_abm({
		label = "chemistry:liquid nitrogen condensation",
		nodenames = {"chemistry:lbutane_flowing", "chemistry:lbutane"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"air"},
		interval = 1.0,
		chance = 19,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, input_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
	label = "natural gas seep",
	nodenames = {"chemistry:gas_seep"},
	neighbors = {"air"},
	interval = 1.0,
	chance = 3,
	catch_up = true,
	action = function(pos, node)
		local target_pos = vector.add(pos,orthogonal[math.random(1,6)])
		if minetest.get_node(target_pos).name == "air" then
			minetest.swap_node(target_pos, {name="chemistry:butane"})
			if math.random() < 0.5 then
				minetest.sound_play(
					"mine_gas_seep_hiss",
					{pos = pos, max_hear_distance = 8, gain = 0.05}
				)
			end
		end	
	end,
})
minetest.register_abm({
	label = "natural gas seep",
	nodenames = {"chemistry:gas_seep"},
	neighbors = {"air"},
	interval = 1.0,
	chance = 3,
	catch_up = true,
	action = function(pos, node)
		local target_pos = vector.add(pos,orthogonal[math.random(1,6)])
		if minetest.get_node(target_pos).name == "air" then
			minetest.swap_node(target_pos, {name="chemistry:methane"})
			if math.random() < 0.5 then
				minetest.sound_play(
					"mine_gas_seep_hiss",
					{pos = pos, max_hear_distance = 8, gain = 0.05}
				)
			end
		end	
	end,
})

local chemical_boom = {
	name = "chemical_boom",
	--description = "explosion caused by chemical reactions",
	radius = 4,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}


if chemical_boom then
	minetest.register_abm({
		label = "alkali metals ignition",
		nodenames = {"chemistry:gas_seep"}, 
		neighbors = {"group:igniter"},
		interval = 1.0,
		chance = 2,
		catch_up = true,
		action = function(pos, node)
			tnt.boom(pos, chemical_boom)
			if math.random() < 0.5 then
				minetest.set_node(pos, {name="fire:basic_flame"})
			end
		end,
	})
end

tnt.register_tnt(chemical_boom)
