
local S = minetest.get_translator("chemistry")

minetest.register_craftitem("chemistry:arsenic", {
	description = S("Arsenic"),
	inventory_image = "arsenic.png",
})

minetest.register_node("chemistry:arsenic_water", {
	description = S("Arsenic Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 7,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:arsenic_water_flowing",
	liquid_alternative_source = "chemistry:arsenic_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 155, r = 0, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, toxic=1, water = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:arsenic_water_flowing", {
	description = S("Flowing Arsenic Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png^[opacity:150^[colorize:black:150"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
   damage_per_second = 7,
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:arsenic_water_flowing",
	liquid_alternative_source = "chemistry:arsenic_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 155, r = 0, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, toxic=1, water = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:arsenic_water",
		"chemistry:arsenic_water_flowing",
		"chemistry:arsenic_water_bucket",
		"acid_bucket.png",
		S("Arsenic Water Bucket"),
		{tool = 1, toxic = 1}
	)

minetest.register_craft({
	output = 'chemistry:arsenic_water_bucket',
	recipe = {
		{'group:water_bucket', 'chemistry:arsenic'},
	}
})

minetest.register_node("chemistry:mercury", {
	description = S("Mercury"),
	drawtype = "liquid",
	tiles = {
		{
			name = "lmetal.png^[brighten:75",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "lmetal.png^[brighten:75",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	paramtype = "light",
	light_source = 0,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   damage_per_second = 7,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:mercury_flowing",
	liquid_alternative_source = "chemistry:mercury",
	liquid_viscosity = 1,
	liquid_renewable = false,
	post_effect_color = {a = 240, r = 80, g = 80, b = 80},
	groups = {liquid = 1, toxic = 1},
})

minetest.register_node("chemistry:mercury_flowing", {
	description = S("Mercury Flowing"),
	drawtype = "flowingliquid",
	tiles = {"lmetal.png^[brighten:75"},
	special_tiles = {
		{
			name = "lmetal.png^[brighten:75",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 4,
			},
		},
		{
			name = "lmetal.png^[brighten:75",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 4,
			},
		},
	},
	paramtype = "light",
	paramtype2 = "flowingliquid",
	light_source = 0,
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   damage_per_second = 7,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:mercury_flowing",
	liquid_alternative_source = "chemistry:mercury",
	liquid_viscosity = 1,
	liquid_renewable = false,
	post_effect_color = {a = 240, r = 80, g = 80, b = 80},
	groups = {liquid = 1, not_in_creative_inventory = 1, toxic = 1},
})

	bucket.register_liquid(
		"chemistry:mercury",
		"chemistry:mercury_flowing",
		"chemistry:mercury_bucket",
		"lmetal_bucket.png",
		S("Mercury Bucket"),
		{tool = 1, toxic = 1}
	)

minetest.register_node("chemistry:mercury_vapour", {
	description = S("Mercury Vapour"),
	walkable = false,
	pointable = false,
	diggable = false,
	is_ground_content = false,
	buildable_to = true,
	drawtype = "glasslike",
	drowning = 0,
   damage_per_second = 2.5,
	post_effect_color = {a = 122, r = 122, g = 122, b = 122},
	tiles = {"incolored_gas.png^[opacity:15"},
	wield_image = "incolored_gas.png",
	inventory_image = "incolored_gas.png",
	use_texture_alpha = "blend",
	groups = {not_in_creative_inventory=0, ropes_can_extend_into=1, not_solid=1, not_opaque=1, gas=1, not_in_creative_inventory = 1, toxic = 1},
	paramtype = "light",
	drop = {},
	sunlight_propagates = true,
	--on_blast = function() end, -- unaffected by explosions
})

local directions = {
	{x=1, y=0, z=0},
	{x=-1, y=0, z=0},
	{x=0, y=0, z=1},
	{x=0, y=0, z=-1},
}

local gas_node = {name="chemistry:mercury_vapour"}
minetest.register_abm({
    label = "chemistry:gases_movement",
    nodenames = {"chemistry:mercury_vapour"},
    neighbors = {"group:liquid", "air"},
    interval = 1,
    chance = 1,
    catch_up = true,
    action = function(pos, node)
		local next_pos = {x=pos.x, y=pos.y+1, z=pos.z}
		local next_node = minetest.get_node(next_pos)
		if minetest.get_item_group(next_node.name, "liquid") > 0 then
			minetest.swap_node(next_pos, gas_node)
			minetest.swap_node(pos, next_node)
		else
			next_pos.y = pos.y-1
			next_node = minetest.get_node(next_pos)
			if next_node.name == "air" then
				minetest.swap_node(next_pos, gas_node)
				minetest.swap_node(pos, next_node)			
			else
				local dir = directions[math.random(1,4)]
				local next_pos = vector.add(pos, dir)
				local next_node = minetest.get_node(next_pos)
				if next_node.name == "air" or  minetest.get_item_group(next_node.name, "liquid") > 0 then
					if next_node.name == "air" or math.random() < 0.5 then -- gas never "climbs" above air.
						minetest.swap_node(next_pos, gas_node)
						minetest.swap_node(pos, next_node)
					else
						-- this can get gas to rise up out of the surface of liquid, preventing it from forming a permanent hole.
						next_pos.y = next_pos.y + 1
						next_node = minetest.get_node(next_pos)
						if next_node.name == "air" then
							minetest.swap_node(next_pos, gas_node)
							minetest.swap_node(pos, next_node)
						end
					end
				end
			end
		end
	end,
})

local orthogonal = {
	{x=0,y=0,z=1},
	{x=0,y=1,z=0},
	{x=1,y=0,z=0},
	{x=0,y=0,z=-1},
	{x=0,y=-1,z=0},
	{x=-1,y=0,z=0},
}

minetest.register_abm({
	label = "chemistry:mercury vaporation",
	nodenames = {"chemistry:mercury", "chemistry:mercury_flowing"},
	neighbors = {"air"},
	interval = 1.0,
	chance = 5,
	catch_up = true,
	action = function(pos, node)
		local target_pos = vector.add(pos,orthogonal[math.random(1,6)])
		if minetest.get_node(target_pos).name == "air" then
			minetest.swap_node(target_pos, {name="chemistry:mercury_vapour"})
			if math.random() < 0.5 then
				minetest.sound_play(
					"",
					{pos = pos, max_hear_distance = 8, gain = 0.05}
				)
			end
		end	
	end,
})

minetest.register_node("chemistry:mercury_block", {
	description = S("Mercury Block"),
	tiles = {"mercury_block.png"},
	is_ground_content = true,
	groups = {cracky = 3, toxic = 1},
	sounds = default.node_sound_metal_defaults(),
})

local output_node = {name="chemistry:mercury"}
	minetest.register_abm({
		label = "chemistry:Mercury melting",
		nodenames = {"chemistry:mercury_block"},
		interval = 1.0,
		chance = 15,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, output_node)
			end	
		end,
	})

local chemical_boom = {
	name = "chemical_boom",
	--description = "explosion caused by chemical reactions",
	radius = 2,
	tiles = {
		side = "invisible.png",
		top = "invisible.png",
		bottom = "invisible.png",
		burning = "invisible.png"
	},
}

tnt.register_tnt(chemical_boom)

	minetest.register_abm({
		label = "chemistry:Mercury melting",
		nodenames = {"chemistry:mercury_block", "chemistry:mercury", "chemistry:mercury_flowing"},
      neighbors = {"group:lava", "group:magnesium_firr"},
		interval = 1.0,
		chance = 20,
		catch_up = true,
		action = function(pos, node)
      tnt.boom(pos, chemical_boom)
			if math.random() < 0.5 then
				minetest.set_node(pos, {name="fire:basic_flame"})
			end
		end,
	})

minetest.register_abm({
	label = "chemistry:mercury vapour decay",
	nodenames = {"chemistry:mercury_vapour"},
	interval = 10.0,
	chance = 9,
	catch_up = true,
	action = function(pos, node)
      minetest.swap_node(pos, {name="air"})
   end,
})

minetest.register_tool("chemistry:steel_arsenic_sword", {
	description = S("Steel Sword with Arsenic"),
	inventory_image = "arsenic_steelsword.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.5, [2]=1.20, [3]=0.35}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=12.5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_craft({
	output = 'chemistry:steel_arsenic_sword',
	recipe = {
		{'default:sword_steel', 'chemistry:arsenic'},
	}
})

