
local S = minetest.get_translator("chemistry")

local oil_footstep = {footstep = {name = "oil_footstep", gain = 0.2}}


minetest.register_node("chemistry:mineral_oil", {
	description = S("Mineral Oil"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "oil_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:mineral_oil_flowing",
	liquid_alternative_source = "chemistry:mineral_oil",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1},
	sounds = oil_footstep,
})

minetest.register_node("chemistry:mineral_oil_flowing", {
	description = S("Flowing Mineral Oil"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "oil_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:mineral_oil_flowing",
	liquid_alternative_source = "chemistry:mineral_oil",
	liquid_viscosity = 1,
	liquid_range = 5,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1},
	sounds = oil_footstep,
})

	bucket.register_liquid(
		"chemistry:mineral_oil",
		"chemistry:mineral_oil_flowing",
		"chemistry:mineral_oil_bucket",
		"oil_bucket.png",
		S("Mineral Oil Bucket"),
		{tool = 1}
	)

minetest.register_node("chemistry:kerosene", {
	description = S("Kerosene"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "oil_source_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "oil_source_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:kerosene_flowing",
	liquid_alternative_source = "chemistry:kerosene",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = oil_footstep,
})

minetest.register_node("chemistry:kerosene_flowing", {
	description = S("Flowing Kerosene"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "oil_flowing_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "oil_flowing_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:kerosene_flowing",
	liquid_alternative_source = "chemistry:kerosene",
	liquid_viscosity = 1,
	liquid_range = 5,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = oil_footstep,
})

	bucket.register_liquid(
		"chemistry:kerosene",
		"chemistry:kerosene_flowing",
		"chemistry:kerosene_bucket",
		"oil_bucket.png",
		S("Kerosene Bucket"),
		{tool = 1, fuel_bucket = 1}
	)

minetest.register_node("chemistry:petroleum", {
	description = S("Petroleum"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "petrol_source_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "petrol_source_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:petroleum_flowing",
	liquid_alternative_source = "chemistry:petroleum",
	liquid_viscosity = 1,
	post_effect_color = {a = 255, r = 0, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = oil_footstep,
})

minetest.register_node("chemistry:petroleum_flowing", {
	description = S("Flowing Petroleum"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"oil.png"},
	special_tiles = {
		{
			name = "petrol_flowing_animated.png",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "petrol_flowing_animated.png",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:petroleum_flowing",
	liquid_alternative_source = "chemistry:petroleum",
	liquid_viscosity = 1,
	liquid_range = 5,
	post_effect_color = {a = 255, r = 0, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = oil_footstep,
})

	bucket.register_liquid(
		"chemistry:petroleum",
		"chemistry:petroleum_flowing",
		"chemistry:petroleum_bucket",
		"petrol_bucket.png",
		S("Petroleum Bucket"),
		{tool = 1, fuel_bucket = 1}
	)

minetest.register_node("chemistry:gasoline", {
	description = S("Gasoline"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:gasoline_flowing",
	liquid_alternative_source = "chemistry:gasoline",
	liquid_viscosity = 1,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:gasoline_flowing", {
	description = S("Flowing Gasoline"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:170",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:170",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_renewable = false,
	liquid_alternative_flowing = "chemistry:gasoline_flowing",
	liquid_alternative_source = "chemistry:gasoline",
	liquid_viscosity = 1,
	liquid_range = 5,
	post_effect_color = {a = 100, r = 250, g = 250, b = 250},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, fuel = 1, flammable=1, air_pollutioner = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:gasoline",
		"chemistry:gasoline_flowing",
		"chemistry:gasoline_bucket",
		"liquid_bucket.png",
		S("Gasoline Bucket"),
		{tool = 1, fuel_bucket = 1}
	)


minetest.register_craft({
	type = "cooking",
	cooktime = 15,
	output = "chemistry:kerosene_bucket",
	recipe = "chemistry:petroleum_bucket"
})

minetest.register_craft({
	type = "cooking",
	cooktime = 10,
	output = "chemistry:gasoline_bucket",
	recipe = "chemistry:kerosene_bucket"
})

minetest.register_craft({
	type = "cooking",
	cooktime = 20,
	output = "chemistry:bucket_with_plastic",
	recipe = "chemistry:gasoline_bucket"
})

minetest.register_craftitem("chemistry:bucket_with_plastic", {
	description = S("Bucket With Plastic"),
	inventory_image = "bucket_with_plastic.png",
})

minetest.register_craft({
   output = 'basic_materials:plastic_sheet 3',
   recipe = {
      {'chemistry:bucket_with_plastic'},
	},
   replacements = {{'chemistry:bucket_with_plastic', 'bucket:bucket_empty'}}
})

minetest.register_craft({
   output = 'chemistry:plastic_block',
   recipe = {
      {'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
      {'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
      {'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
	}
})

minetest.register_craft({
   output = 'basic_materials:plastic_sheet 9',
   recipe = {
       {'chemistry:plastic_block'},
	}
})

minetest.register_node("chemistry:plastic_block", {
	description = S("Plastic Block"),
	tiles = {"plastic_block.png"},
	is_ground_content = false,
	groups = {oddly_breakable_by_hand = 2, flammable = 5, air_pollutioner = 1},
	sounds = default.node_sound_snow_defaults(),
})

	minetest.override_item("default:dirt", {
		drop = {
			max_items = 2,
			items = {
				{
					items = {"chemistry:baking_soda"},
					rarity = 20
				},
				{
					items = {"default:dirt"}
				}
			}
		}
	})

minetest.register_craft({
	type = "fuel",
	recipe = "group:fuel_bucket",
	burntime = 120,
	replacements = {{"group:fuel_bucket", "bucket:bucket_empty"}},
})

minetest.register_craft({
	type = "fuel",
	recipe = "chemistry:anthracite",
	burntime = 100,
})

minetest.register_craftitem("chemistry:anthracite", {
	description = S("Anthracite Coal"),
	inventory_image = "anthracite.png",
})

minetest.register_node("chemistry:magnesium_anthracite_block", {
	description = S("Magnesium Anthracite Block"),
	tiles = {"anthracite_block.png^magnesium_anthracite_block.png"},
	is_ground_content = false,
	groups = {cracky = 3},
	sounds = default.node_sound_stone_defaults(),
})

minetest.override_item("chemistry:magnesium_anthracite_block", {
	on_heat = function(pos)
		local flame_pos = {x = pos.x, y = pos.y + 1, z = pos.z}
		if minetest.get_node(flame_pos).name == "air" then
			minetest.set_node(flame_pos, {name = "chemistry:permanent_magnesium_fire"})
		end
	end
})

minetest.register_craft({
	output = 'chemistry:magnesium_anthracite_block',
	recipe = {
		{'chemistry:magnesium', 'chemistry:anthracite', 'chemistry:magnesium'},
		{'chemistry:anthracite', 'chemistry:magnesium', 'chemistry:anthracite'},
		{'chemistry:magnesium', 'chemistry:anthracite', 'chemistry:magnesium'},
	}
})

