
local S = minetest.get_translator("chemistry")

	minetest.register_biome({
		name = "alkaline_land",
		node_top = "chemistry:alkaline_sand",
		depth_top = 1,
		node_filler = "chemistry:alkaline_sand",
		depth_filler = 2,
		node_riverbed = "chemistry:alkaline_sand",
		depth_riverbed = 2,
		node_stone = "chemistry:alkaline_sandstone",
		node_dungeon = "chemistry:alkaline_sandstone_brick",
		node_dungeon_alt = "chemistry:alkaline_sandstone_brick_cracked",
		node_dungeon_stair = "stairs:stair_alkaline_sandstone_brick",
		y_max = 31000,
		y_min = 4,
		heat_point = 90,
		humidity_point = 75,
	})


	minetest.register_biome({
		name = "strong_stone_layer",
		node_filler = "chemistry:stone",
		node_stone = "chemistry:stone",
		node_dungeon = "chemistry:stone_brick",
		node_dungeon_alt = "chemistry:stone_brick_cracked",
		node_dungeon_stair = "stairs:stair_strong_stone_brick",
		y_max = -11000,
		y_min = -31000,
		heat_point = 90,
		humidity_point = 75,
	})

	minetest.register_decoration({
		name = "chemistry:cesium_crystal",
		deco_type = "simple",
		place_on = {"chemistry:alkaline_sand"},
		sidelen = 16,
		noise_params = {
			offset = -0.012,
			scale = 0.024,
			spread = {x = 100, y = 100, z = 100},
			seed = 230,
			octaves = 3,
			persist = 0.6
		},
		y_max = 300,
		y_min = 1,
		decoration = "chemistry:cesium_crystal",
	})

minetest.register_node("chemistry:sand_with_lithium", {
	description = S("Sand Lithium Ore"),
	tiles = {"alkaline_sand.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_sodium", {
	description = S("Sand Sodium Ore"),
	tiles = {"alkaline_sand.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_potassium", {
	description = S("Sand Potassium Ore"),
	tiles = {"alkaline_sand.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_rubidium", {
	description = S("Sand Rubidium Ore"),
	tiles = {"alkaline_sand.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sandstone_with_lithium", {
	description = S("Sandstone Lithium Ore"),
	tiles = {"alkaline_sandstone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_sodium", {
	description = S("Sandstone Sodium Ore"),
	tiles = {"alkaline_sandstone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_potassium", {
	description = S("Sandstone Potassium Ore"),
	tiles = {"alkaline_sandstone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_rubidium", {
	description = S("Sandstone Rubidium Ore"),
	tiles = {"alkaline_sandstone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone", {
	description = S("Alkaline Sandstone"),
	tiles = {"alkaline_sandstone.png"},
	groups = {crumbly = 1, cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_brick", {
	description = S("Alkaline Sandstone Brick"),
	tiles = {"alkaline_sandstone_brick.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_brick_cracked", {
	description = S("Cracked Alkaline Sandstone Brick"),
	tiles = {"alkaline_sandstone_brick_cracked.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_block", {
	description = S("Alkaline Sandstone Block"),
	tiles = {"alkaline_sandstone_block.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sand", {
	description = S("Alkaline Sand"),
	tiles = {"alkaline_sand.png"},
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_block 9',
	recipe = {
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
	}
})

minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_brick 4',
	recipe = {
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', ''},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', ''},
		{'', '', ''},
	}
})

stairs.register_stair(
	"alkaline_sandstone_brick",
	"chemistry:alkaline_sandstone_brick",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_brick.png"},
	S("Alkaline Sandstone Brick Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"alkaline_sandstone_brick",
	"chemistry:alkaline_sandstone_brick",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_brick.png"},
	S("Alkaline Sandstone Brick Slab"),
	default.node_sound_stone_defaults()
)

stairs.register_stair(
	"alkaline_sandstone_block",
	"chemistry:alkaline_sandstone_block",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_block.png"},
	S("Alkaline Sandstone Block Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"alkaline_sandstone_block",
	"chemistry:alkaline_sandstone_block",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_block.png"},
	S("Alkaline Sandstone Block Slab"),
	default.node_sound_stone_defaults()
)

minetest.register_node("chemistry:stone", {
	description = S("Strong Stone"),
	tiles = {"strong_stone.png"},
	groups = {cracky = 2, strong_stone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_brick", {
	description = S("Strong Stone Brick"),
	tiles = {"strong_stone_brick.png"},
	groups = {cracky = 1, strong_stone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_brick_cracked", {
	description = S("Cracked Strong Stone Brick"),
	tiles = {"strong_stone_brick_cracked.png"},
	groups = {cracky = 1, strong_stone = 1},
	sounds = default.node_sound_stone_defaults(),
})

stairs.register_stair(
	"stone_brick",
	"chemistry:stone_brick",
	{cracky = 1, strong_stone = 1},
	{"strong_stone_brick.png"},
	S("Strong Stone Brick Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"stone_brick",
	"chemistry:stone_brick",
	{cracky = 1, strong_stone = 1},
	{"strong_stone_brick.png"},
	S("Strong Stone Brick Slab"),
	default.node_sound_stone_defaults()
)
minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_brick 4',
	recipe = {
		{'chemistry:stone', 'chemistry:stone', ''},
		{'chemistry:stone', 'chemistry:stone', ''},
		{'', '', ''},
	}
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})




minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_lithium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_lithium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_sodium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_sodium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_potassium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_potassium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_rubidium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_rubidium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_alias("default:stone", "chemistry:stone")


minetest.register_node("chemistry:strong_stone_with_anthracite", {
	description = S("Strong Anthracite Ore"),
	tiles = {"strong_stone.png^anthracite_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 1},
	drop = "chemistry:anthracite",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_titanium", {
	description = S("Strong Titanium Ore"),
	tiles = {"strong_stone.png^titanium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level=3},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:titanium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:titanium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_cobalt", {
	description = S("Strong Cobalt Ore"),
	tiles = {"strong_stone.png^cobalt_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 4},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:cobalt_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_osmium", {
	description = S("Strong Osmium Ore"),
	tiles = {"strong_stone.png^osmium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 5},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:osmium_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:osmium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_tungsten", {
	description = S("Strong Tungsten Ore"),
	tiles = {"strong_stone.png^tungsten_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 6},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:tungsten_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_diamond", {
	description = S("Strong Diamond Ore"),
	tiles = {"strong_stone.png^default_mineral_diamond.png"},
	groups = {cracky = 1, level = 1},
	drop = "default:diamond",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_magnesium", {
	description = S("Strong Magnesium Ore"),
	tiles = {"strong_stone.png^magnesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:magnesium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:magnesium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_gas_seep", {
	description = S("Strong Natural Gas Seep"),
	tiles = {"strong_stone.png^[combine:16x80:0,-32=crack_anylength.png"},
	groups = {cracky = 2, pickaxey=1, building_block=1, material_stone=1},
	sounds = default.node_sound_stone_defaults(),
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:methane 6'},    --The 6 drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'default:cobble'},    --The 1st drops
				rarity = 1,
			},
			{
				items = {'chemistry:butane 6'},    --The 6 other drops with a 1/3 chance
				rarity = 2,
			},
		}
	},
	is_ground_content = true,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_magnesium",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_magnesium",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_diamond",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_diamond",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 12,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 15,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20 * 20,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_gas_seep",
	wherein        = "chemistry:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -12500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_titanium",
	wherein        = "chemistry:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_titanium",
	wherein        = "chemistry:stone",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -13000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_cobalt",
	wherein        = "chemistry:stone",
	clust_scarcity = 18 * 18 * 18,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_cobalt",
	wherein        = "chemistry:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -13000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_osmium",
	wherein        = "chemistry:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_osmium",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -14000,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_tungsten",
	wherein        = "chemistry:stone",
	clust_scarcity = 21 * 21 * 21,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_tungsten",
	wherein        = "chemistry:stone",
	clust_scarcity = 14 * 14 * 14,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -15000,
})
