
local S = minetest.get_translator("chemistry")

minetest.register_tool("chemistry:blowtorch", {
	description = S("Blowtorch"),
	inventory_image = "blowtorch.png",
	sound = {breaks = "default_tool_breaks"},

	on_use = function(itemstack, user, pointed_thing)
		local sound_pos = pointed_thing.above or user:get_pos()
		minetest.sound_play("default_item_smoke",
			{pos = sound_pos, gain = 0.2, max_hear_distance = 8}, true)
		local player_name = user:get_player_name()
		if pointed_thing.type == "node" then
			local node_under = minetest.get_node(pointed_thing.under).name
			local nodedef = minetest.registered_nodes[node_under]
			if not nodedef then
				return
			end
			if minetest.is_protected(pointed_thing.under, player_name) then
				minetest.record_protection_violation(pointed_thing.under, player_name)
				return
			end
			if nodedef.on_ignite then
				nodedef.on_ignite(pointed_thing.under, user)
			elseif nodedef.on_heat then
               nodedef.on_heat(pointed_thing.under, user)
			elseif minetest.get_node(node_under, pointed_thing.above)
					and minetest.get_node(pointed_thing.above).name == "air" then
				if minetest.is_protected(pointed_thing.above, player_name) then
					minetest.record_protection_violation(pointed_thing.above, player_name)
					return
				end

				minetest.set_node(pointed_thing.above, {name = "fire:basic_flame"})
			end
		end
		if not minetest.is_creative_enabled(player_name) then
			-- Wear tool
			local wdef = itemstack:get_definition()
			itemstack:add_wear_by_uses(150)

			-- Tool break sound
			if itemstack:get_count() == 0 and wdef.sound and wdef.sound.breaks then
				minetest.sound_play(wdef.sound.breaks,
					{pos = sound_pos, gain = 0.5}, true)
			end
			return itemstack
		end
	end
})

minetest.register_craft({
	output = 'chemistry:blowtorch',
	recipe = {
		{'chemistry:tungsten', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
		{'', 'chemistry:steel_ingot', 'chemistry:lbutane_bucket'},
		{'', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
	},
   replacements = {{"chemistry:lbutane_bucket", "bucket:bucket_empty"}},
})

