
local S = minetest.get_translator("chemistry")

minetest.register_craftitem("chemistry:arsenic", {
	description = S("Arsenic"),
	inventory_image = "arsenic.png",
})

minetest.register_node("chemistry:arsenic_water", {
	description = S("Arsenic Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 7,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:arsenic_water_flowing",
	liquid_alternative_source = "chemistry:arsenic_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 155, r = 0, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, toxic=1, water = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:arsenic_water_flowing", {
	description = S("Flowing Arsenic Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png^[opacity:150^[colorize:black:150"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
   damage_per_second = 7,
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:arsenic_water_flowing",
	liquid_alternative_source = "chemistry:arsenic_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 155, r = 0, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, toxic=1, water = 1},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:arsenic_water",
		"chemistry:arsenic_water_flowing",
		"chemistry:arsenic_water_bucket",
		"acid_bucket.png",
		S("Arsenic Water Bucket"),
		{tool = 1, toxic = 1}
	)

minetest.register_craft({
	output = 'chemistry:arsenic_water_bucket',
	recipe = {
		{'group:water_bucket', 'chemistry:arsenic'},
	}
})

minetest.register_tool("chemistry:steel_arsenic_sword", {
	description = S("Steel Sword with Arsenic"),
	inventory_image = "arsenic_steelsword.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.5, [2]=1.20, [3]=0.35}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=12.5},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1}
})

minetest.register_craft({
	output = 'chemistry:steel_arsenic_sword',
	recipe = {
		{'default:sword_steel', 'chemistry:arsenic'},
	}
})

