
local output_node = {name="air"}
minetest.register_abm({
		label = "chemistry:corrosion normal",
		nodenames = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "mykota:mykota", "mykota:dry_mykota"}, 
		neighbors = {"group:corrosive"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:acid") then
				minetest.swap_node(pos, output_node)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry:corrosion strong",
		nodenames = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "mykota:mykota", "mykota:dry_mykota", "group:crumbly", "default:steel_block"}, 
		neighbors = {"group:corrosive2"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:acid") then
				minetest.swap_node(pos, output_node)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

local output_node2 = {name="chemistry:nitrogen_dioxide"}
minetest.register_abm({
		label = "chemistry:corrosion nitric",
		nodenames = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "mykota:mykota", "mykota:dry_mykota", "group:crumbly", "default:steelblock", "default:copperblock", "default:obsidian", "default:obsidian_block", "default:obsidian_brick"}, -- checking for nodes that can be corroded
		neighbors = {"chemistry:hno_acid", "chemistry:hno_acid_flowing"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:acid") then
				minetest.swap_node(pos, output_node2)
				if math.random() < 0.75 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

local input_node = {name="chemistry:hno_acid"}
minetest.register_abm({
		label = "chemistry:corrosion nitric",
		nodenames = {"default:water_source"}, -- checking for nodes that can be corroded
		neighbors = {"chemistry:nitrogen_dioxide"},
		interval = 5.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.swap_node(pos, input_node)
				if math.random() < 0.5 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry:corrosion regia",
		nodenames = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "mykota:mykota", "mykota:dry_mykota", "group:crumbly", "default:steelblock", "default:copperblock", "default:obsidian", "default:obsidian_block", "default:obsidian_brick", "default:gold_block", "group:lava", "moreores:mithril_block", "moreores:silver_block"}, 
		neighbors = {"chemistry:aqua_regia", "chemistry:aqua_regia_flowing"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:acid") then
				minetest.swap_node(pos, output_node)
				if math.random() < 0.0001 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

