
local S = minetest.get_translator("chemistry")

minetest.register_tool("chemistry:blowtorch", {
	description = S("Blowtorch"),
	inventory_image = "blowtorch.png",

	on_use = function(itemstack, user, pointed_thing)
		local sound_pos = pointed_thing.above or user:get_pos()
		minetest.sound_play("default_item_smoke",
			{pos = sound_pos, gain = 0.2, max_hear_distance = 8}, true)
		local player_name = user:get_player_name()
		if pointed_thing.type == "node" then
			local node_under = minetest.get_node(pointed_thing.under).name
			local nodedef = minetest.registered_nodes[node_under]
			if not nodedef then
				return
			end
			if minetest.is_protected(pointed_thing.under, player_name) then
				minetest.record_protection_violation(pointed_thing.under, player_name)
				return
			end
			if nodedef.on_ignite then
				nodedef.on_ignite(pointed_thing.under, user)
			elseif nodedef.on_heat then
               nodedef.on_heat(pointed_thing.under, user)
			elseif minetest.get_item_group(node_under, "anthracite_material") >= 1
			    and minetest.get_node(pointed_thing.above).name == "air" then
					if minetest.is_protected(pointed_thing.above, player_name) then
						minetest.record_protection_violation(pointed_thing.above, player_name)
						return
					end
	
					minetest.set_node(pointed_thing.above, {name = "chemistry:anthracite_fire"})
			elseif minetest.get_node(node_under, pointed_thing.above)
					and minetest.get_node(pointed_thing.above).name == "air" then
				if minetest.is_protected(pointed_thing.above, player_name) then
					minetest.record_protection_violation(pointed_thing.above, player_name)
					return
				end

				minetest.set_node(pointed_thing.above, {name = "fire:basic_flame"})
			end
		end
		if not minetest.is_creative_enabled(player_name) then
			-- Wear tool
			local wdef = itemstack:get_definition()
			itemstack:add_wear_by_uses(150)

			-- Tool break sound
			if itemstack:get_count() == 0 then
		        itemstack = "chemistry:blowtorch_empty"
			end
			return itemstack
		end
	end
})

minetest.register_tool("chemistry:blowtorch_empty", {
	description = S("Empty Blowtorch"),
	inventory_image = "blowtorch.png",

	on_use = function(itemstack, user, pointed_thing)
		local sound_pos = pointed_thing.above or user:get_pos()
		minetest.sound_play("default_item_smoke",
			{pos = sound_pos, gain = 0.2, max_hear_distance = 8}, true)
	end,
	groups = {not_in_creative_inventory = 1}
})

minetest.register_craft({
	output = 'chemistry:blowtorch',
	recipe = {
		{'chemistry:tungsten', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
		{'', 'chemistry:steel_ingot', 'chemistry:blowtorch_bottle'},
		{'', 'basic_materials:plastic_sheet', 'basic_materials:plastic_sheet'},
	}
})


minetest.register_craft({
	output = 'chemistry:blowtorch_bottle 4',
	recipe = {
		{'chemistry:aluminium', 'basic_materials:plastic_sheet', 'chemistry:aluminium'},
		{'chemistry:aluminium', 'chemistry:lbutane_bucket', 'chemistry:aluminium'},
		{'chemistry:aluminium', 'chemistry:aluminium', 'chemistry:aluminium'},
	},
	replacements = {{'chemistry:lbutane_bucket', 'bucket:bucket_empty'}}
})


minetest.register_craft({
	output = 'chemistry:blowtorch',
	recipe = {
		{'chemistry:blowtorch_empty', 'chemistry:blowtorch_bottle'},
	},
	replacements = {{'chemistry:lbutane_bucket', 'bucket:bucket_empty'}}
})

minetest.register_craftitem("chemistry:blowtorch_bottle", {
	description = S("Blowtorch Gas Bottle"),
	inventory_image = "blowtorch_bottle.png",
})

