local path = minetest.get_modpath(minetest.get_current_modname()) .. "/"

chemistry = {version = 20250214}
chemistry.allow_corrosion = minetest.settings:get_bool("chemistry.allow_corrosion", true)
chemistry.allow_alkali_reaction = minetest.settings:get_bool("chemistry.allow_alkali_reaction", true)
chemistry.enable_nuke = minetest.settings:get_bool("chemistry.enable_nuke", true)

dofile(path .. "sounds.lua")
dofile(path .. "halogens.lua")
dofile(path .. "alkali_metals.lua")
dofile(path .. "gases.lua")
dofile(path .. "others.lua")
if chemistry.allow_corrosion then
   dofile(path .. "corrosion.lua")
end
dofile(path .. "acids.lua")
dofile(path .. "glow_water.lua")
dofile(path .. "hydrocarbons.lua")
dofile(path .. "fuel_flammability.lua")
dofile(path .. "air_pollution.lua")
dofile(path .. "mapgen.lua")
dofile(path .. "minerals.lua")
dofile(path .. "particle_gen.lua")
dofile(path .. "explosives.lua")
dofile(path .. "freezing.lua")
dofile(path .. "magnesium_torch.lua")
dofile(path .. "blowtorch.lua")
dofile(path .. "tools.lua")
dofile(path .. "molten_metals.lua")
dofile(path .. "schems.lua")
dofile(path .. "strong_lava.lua")
if minetest.get_modpath("3d_armor") then
   dofile(path .. "armor.lua")
end
dofile(path .. "toxic_elements.lua")
if minetest.get_modpath("technic") then
   dofile(path .. "half-life.lua")
   dofile(path .. "radioactive.lua")
   if chemistry.enable_nuke then
      dofile(path .. "nuke.lua")
   end
   dofile(path .. "detectors.lua")
end
