
local S = minetest.get_translator("chemistry")

 ---
 --- Ore Register
 ---

	minetest.register_node("chemistry:antimony_crystal", {
		description = S("Antimony Crystal Ore"),
		drawtype = "plantlike",
		tiles = {"antimony_mineral.png"},
		inventory_image = "antimony_mineral.png",
		wield_image = "antimony_mineral.png",
		paramtype = "light",
		light_source = 5,
		sunlight_propagates = true,
		walkable = true,
		damage_per_second = 0,
		groups = {cracky = 1, falling_node=1, level=1},
		sounds = default.node_sound_glass_defaults(),
		selection_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		node_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		drop = "chemistry:antimony",
		on_blast = function() end,
	})

minetest.register_node("chemistry:gas_seep", {
	description = S("Natural Gas Seep"),
	tiles = {"default_stone.png^[combine:16x80:0,-16=crack_anylength.png"},
	groups = {cracky = 3, pickaxey=1, building_block=1, material_stone=1},
	sounds = default.node_sound_stone_defaults(),
	drop = {
		max_items = 2,
		items = {
			{
				items = {'chemistry:methane 1'},    --The 3 drops with a 1/5 chance
				rarity = 5,
			},
			{
				items = {'default:cobble'},    --The 1st drops
				rarity = 1,
			},
			{
				items = {'chemistry:butane 1'},    --The 3 other drops with a 1/10 chance
				rarity = 5,
			},
		}
	},
	is_ground_content = true,
})

minetest.register_node("chemistry:stone_with_magnesium", {
	description = S("Magnesium Ore"),
	tiles = {"default_stone.png^magnesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:magnesium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:magnesium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_anthracite", {
	description = S("Anthracite Ore"),
	tiles = {"default_stone.png^anthracite_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1},
	drop = "chemistry:anthracite",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_arsenic", {
	description = S("Arsenic Ore"),
	tiles = {"default_stone.png^arsenic_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:arsenic 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:arsenic'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:arsenic'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:arsenic'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_calcium", {
	description = S("Calcium Ore"),
	tiles = {"default_stone.png^calcium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:calcium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:calcium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:calcium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:calcium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_manganese", {
	description = S("Manganese Ore"),
	tiles = {"default_stone.png^manganese_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 6,
		items = {
			{
				items = {'chemistry:manganese 2'},  
			},
			{
				items = {'chemistry:manganese'},    
				rarity = 5,
			},
			{
				items = {'chemistry:manganese_oxide 2'},    
			},
			{
				items = {'chemistry:manganese_oxide'},
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_titanium", {
	description = S("Titanium Ore"),
	tiles = {{
	name = "default_stone_32px.png^titanium_mineral.png",
	align_style = "world",
	scale       = 2,
   }},
	is_ground_content = true,
	groups = {cracky=1, level=3},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:titanium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:titanium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:stone_with_cobalt", {
	description = S("Cobalt Ore"),
	tiles = {"default_stone.png^cobalt_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 4},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:cobalt_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:stone_with_osmium", {
	description = S("Osmium Ore"),
	tiles = {"default_stone.png^osmium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 5},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:osmium_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:osmium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:stone_with_tungsten", {
	description = S("Tungsten Ore"),
	tiles = {"default_stone.png^tungsten_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 6},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:tungsten_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

if minetest.get_modpath("technic") then
   minetest.override_item("technic:mineral_zinc", {
   	drop = {
		   max_items = 3,
		   items = {
			   {
				   items = {'technic:zinc_lump'},
			    },
			    {
				   items = {'chemistry:zinc_dust'},
				   rarity = 2,
			      },
		   	{
			   	items = {'chemistry:zinc_dust'},
			   	rarity = 2,
			   },
		   }
	   },
   })
end

minetest.register_node("chemistry:stone_with_sulfur", {
	description = S("Sulfur Ore"),
	tiles = {"default_stone.png^sulfur_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sulfur 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sulfur'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sulfur'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sulfur'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_bismuth", {
	description = S("Bismuth Ore"),
	tiles = {"default_stone.png^bismuth_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:bismuth 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:bismuth'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:bismuth'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:bismuth'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_gallium", {
	description = S("Gallium Ore"),
	tiles = {"default_stone.png^gallium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:gallium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:gallium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:gallium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:gallium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_aluminium", {
	description = S("Aluminium Ore"),
	tiles = {"default_stone.png^aluminium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 6,
		items = {
			{
				items = {'chemistry:aluminium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:aluminium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 3,
			},
			{
				items = {'chemistry:aluminium_powder'},    --The 4th drops with a 1/3 chance
				rarity = 7,
			},
			{
				items = {'chemistry:aluminium_powder'},    --The 5th drops with a 1/8 chance
				rarity = 12,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

if minetest.get_modpath("technic") then
minetest.register_node("chemistry:thorite", {
	description = S("Thorite"),
	tiles = {"thorite.png"},
	is_ground_content = true,
	groups = {cracky=2, radioactive = 1},
	drop = {
		max_items = 6,
		items = {
			{
				items = {'chemistry:thorium 2'},
			},
			{
				items = {'chemistry:thorium 2'}, 
				rarity = 2,
			},
			{
				items = {'chemistry:thorium 2'}, 
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:uraninite", {
	description = S("Uraninite"),
	tiles = {"uraninite.png"},
	is_ground_content = true,
	groups = {cracky=2, radioactive = 1},
	drop = {
		max_items = 15,
		items = {
			{
				items = {'chemistry:radium'},
            rarity = 10,
			},
			{
				items = {'chemistry:polonium'}, 
				rarity = 10,
			},
			{
				items = {'chemistry:plutonium'}, 
				rarity = 20,
			},
			{
				items = {'chemistry:uranium'}, 
			},
         {
            items = {'chemistry:radium_dust 2'},
            rarity = 5
         },
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
end
minetest.register_node("chemistry:stone_with_lithium", {
	description = S("Lithium Ore"),
	tiles = {"default_stone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_sodium", {
	description = S("Sodium Ore"),
	tiles = {"default_stone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_potassium", {
	description = S("Potassium Ore"),
	tiles = {"default_stone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_rubidium", {
	description = S("Rubidium Ore"),
	tiles = {"default_stone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_cesium", {
	description = S("Cesium Ore"),
	tiles = {"default_stone.png^cesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:cesium_shard 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cesium_shard'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_francium", {
	description = S("Francium Ore"),
	tiles = {"default_stone.png^francium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2, radioactive = 2, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:francium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:francium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

 --
 ---- Ore Generation (spawns the ores at the default node "default:stone")
 --
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_lithium",
	wherein        = "default:stone",
	clust_scarcity = 6 * 6 * 6,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 100,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_lithium",
	wherein        = "default:stone",
	clust_scarcity = 5 * 5 * 5,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -2290,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sodium",
	wherein        = "default:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -1,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sodium",
	wherein        = "default:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 4,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -1000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_potassium",
	wherein        = "default:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -89,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_potassium",
	wherein        = "default:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 5,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_rubidium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -129,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_rubidium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 3,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cesium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 1,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -199,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cesium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 5,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_francium",
	wherein        = "default:stone",
	clust_scarcity = 29 * 29 * 29,
	clust_num_ores = 1,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -289,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_francium",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:iodine_block",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -1,
})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:mineral_oil",
		wherein         = {"default:stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = 100,
		y_min           = -30010,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:petroleum",
		wherein         = {"default:stone"},
		clust_scarcity  = 76 * 76 * 76,
		clust_size      = 10,
		y_max           = 100,
		y_min           = -30010,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})


	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:bleach",
		wherein         = {"default:dirt"},
		clust_scarcity  = 76 * 76 * 76,
		clust_size      = 5,
		y_max           = 100,
		y_min           = -20,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:glycerin",
		wherein         = {"default:dirt"},
		clust_scarcity  = 36 * 36 * 36,
		clust_size      = 3,
		y_max           = 1000,
		y_min           = -30,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:vinegar",
		wherein         = {"default:dirt"},
		clust_scarcity  = 26 * 26 * 26,
		clust_size      = 3,
		y_max           = 1000,
		y_min           = -30,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:hcl_acid",
		wherein         = {"default:stone"},
		clust_scarcity  = 46 * 46 * 46,
		clust_size      = 3,
		y_max           = 0,
		y_min           = -30000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:hso_acid",
		wherein         = {"default:stone"},
		clust_scarcity  = 66 * 66 * 66,
		clust_size      = 3,
		y_max           = -10,
		y_min           = -30000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})


	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:hno_acid",
		wherein         = {"chemistry:stone"},
		clust_scarcity  = 66 * 66 * 66,
		clust_size      = 3,
		y_max           = -11000,
		y_min           = -30000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

if minetest.get_modpath("technic") then
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uraninite",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uraninite",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 5,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uranium_dioxide",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uranium_dioxide",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uraninite",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 5,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "chemistry:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uranium_dioxide",
	wherein        = "chemistry:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uranium_dioxide",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})
end

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_aluminium",
	wherein        = "default:stone",
	clust_scarcity = 14 * 14 * 14,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = 100,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_aluminium",
	wherein        = "default:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -50,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_gallium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -20,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_gallium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -300,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_bismuth",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -20,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_bismuth",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -300,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sulfur",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -5,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sulfur",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -50,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_calcium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 0,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_calcium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 26 * 26 * 26,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 0,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -250,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cobalt",
	wherein        = "default:stone",
	clust_scarcity = 28 * 28 * 28,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -250,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cobalt",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20 * 20,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_osmium",
	wherein        = "default:stone",
	clust_scarcity = 26 * 26 * 26,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -500,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_osmium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -1000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_tungsten",
	wherein        = "default:stone",
	clust_scarcity = 31 * 31 * 31,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -1000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_tungsten",
	wherein        = "default:stone",
	clust_scarcity = 24 * 24 * 24,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -1500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_magnesium",
	wherein        = "default:stone",
	clust_scarcity = 29 * 29 * 29,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 120,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_magnesium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_anthracite",
	wherein        = "default:stone",
	clust_scarcity = 32 * 32 * 32,
	clust_num_ores = 12,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = 120,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_anthracite",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 15,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_manganese",
	wherein        = "default:stone",
	clust_scarcity = 46 * 46 * 46,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 120,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_manganese",
	wherein        = "default:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:red_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:red_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:purple_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 6,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:purple_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_arsenic",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 6,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_arsenic",
	wherein        = "default:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:anthracite_block",
	wherein        = "chemistry:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 1,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:anthracite_block",
	wherein        = "chemistry:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -15500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:lithium_block",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 1,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -10,
})


	minetest.register_decoration({
		name = "chemistry:antimony_crystal",
		deco_type = "simple",
		place_on = {"default:stone"},
		sidelen = 16,
		flags = "force_placement, all_floors",
	    fill_ratio = 0.001,
		y_max = 0,
		y_min = -31000,
		decoration = "chemistry:antimony_crystal",
	})

