--Sapling Grow Function

local function add_tree(pos, schem, replace)

	minetest.swap_node(pos, {name = "air"})

	minetest.place_schematic(pos, schem, "random", replace, false,
			"place_center_x, place_center_z")
end

function chemistry.grow_ionized_tree(pos)
	add_tree(pos, chemistry.ionized_tree)
end

function chemistry.grow_anthracite_tree(pos)
	add_tree(pos, chemistry.anthracite_tree)
end

local function register_sapling_growth(nodename, grow)
	default.register_sapling_growth("chemistry:" .. nodename, {grow = grow})
end

local function after_place_leaves(...)
	return default.after_place_leaves(...)
end

local function grow_sapling(...)
	return default.grow_sapling(...)
end

local function prepare_on_place(itemstack, placer, pointed_thing, name, w, h)

	if sapling_protection_check then

		-- check if grown tree area intersects any players protected area
		return default.sapling_on_place(itemstack, placer, pointed_thing,
				name, {x = -w, y = 1, z = -w}, {x = w, y = h, z = w}, 4)
	end

	-- Position of sapling
	local pos = pointed_thing.under
	local node = minetest.get_node_or_nil(pos)
	local pdef = node and minetest.registered_nodes[node.name]

	-- Check if node clicked on has it's own on_rightclick function
	if pdef and pdef.on_rightclick
	and not (placer and placer:is_player() and placer:get_player_control().sneak) then
		return pdef.on_rightclick(pos, node, placer, itemstack, pointed_thing)
	end

	-- place normally
	return minetest.item_place_node(itemstack, placer, pointed_thing)
end

function chemistry.can_grow_on_stone(pos)
	local node_under = minetest.get_node_or_nil({x = pos.x, y = pos.y - 1, z = pos.z})
	if not node_under then
		return false
	end
	if minetest.get_item_group(node_under.name, "strong_stone") == 0 then
		return false
	end
	local light_level = minetest.get_node_light(pos)
	if not light_level or light_level < 13 then
		return false
	end
	return true
end

function chemistry.register_sapling_growth(name, def)
	default.sapling_growth_defs[name] = {
		can_grow = def.can_grow or chemistry.can_grow_on_stone,
		on_grow_failed = def.on_grow_failed or default.on_grow_failed,
		grow = assert(def.grow)
	}
end

local function register_sapling_growth_on_stone(nodename, grow)
	chemistry.register_sapling_growth("chemistry:" .. nodename, {grow = grow})
end

register_sapling_growth("ionized_sapling", chemistry.grow_ionized_tree)
register_sapling_growth_on_stone("anthracite_sapling", chemistry.grow_anthracite_tree)

local S = minetest.get_translator("chemistry")

-- Biomes and Decorations

	minetest.register_biome({
		name = "alkaline_land",
		node_top = "chemistry:alkaline_sand",
		depth_top = 4,
		node_filler = "chemistry:alkaline_sandstone",
		depth_filler = 7,
		node_riverbed = "chemistry:alkaline_sand",
		depth_riverbed = 2,
		node_stone = "chemistry:alkaline_stone",
		node_dungeon = "chemistry:alkaline_sandstone_brick_cracked",
		node_dungeon_alt = "chemistry:alkaline_sandstone_brick",
		node_dungeon_stair = "stairs:stair_alkaline_sandstone_brick",
		y_max = 31000,
		y_min = 4,
		heat_point = 100,
		humidity_point = 25,
	})

	minetest.register_biome({
		name = "ionized_forest",
		node_top = "chemistry:dirt_with_uranyl",
		depth_top = 1,
		node_filler = "default:dirt",
		depth_filler = 3,
		node_riverbed = "chemistry:uranium_dioxide",
		depth_riverbed = 2,
		node_dungeon = "default:cobble",
		node_dungeon_alt = "default:mossycobble",
		node_dungeon_stair = "stairs:stair_cobble",
		y_max = 31000,
		y_min = 3,
		heat_point = 75,
		humidity_point = 50,
	})

	
	minetest.register_biome({
		name = "ionized_ocean",
		node_top = "chemistry:uranium_dioxide",
		depth_top = 1,
		node_filler = "chemistry:uranium_dioxide",
		depth_filler = 3,
		node_riverbed = "chemistry:uranium_dioxide",
		depth_riverbed = 2,
		node_dungeon = "default:cobble",
		node_dungeon_alt = "default:mossycobble",
		node_dungeon_stair = "stairs:stair_cobble",
		node_water_top = "chemistry:uranium_water",
		depth_water_top = 13,		
		y_max = 3,
		y_min = -80,
		heat_point = 75,
		humidity_point = 50,
	})

	minetest.register_biome({
		name = "strong_stone_layer",
		node_filler = "chemistry:stone",
		node_stone = "chemistry:stone",
		node_dungeon = "chemistry:stone_brick_cracked",
		node_dungeon_alt = "chemistry:stone_brick",
		node_dungeon_stair = "stairs:stair_strong_stone_brick",
		y_max = -11000,
		y_min = -31000,
		node_cave_liquid = {"chemistry:msteel", "chemistry:mcopper", "chemistry:mtin"},
		heat_point = 100,
		humidity_point = 25,
	})

	minetest.register_decoration({
		name = "default:dry_shrub",
		deco_type = "simple",
		place_on = {"chemistry:dirt_with_uranyl"},
		sidelen = 16,
		flags = "force_placement",
	    fill_ratio = 0.01,
		y_max = 31000,
		y_min = 0,
		decoration = "default:dry_shrub",
	})

	minetest.register_decoration({
		name = "chemistry:crystal",
		deco_type = "simple",
		place_on = {"chemistry:stone"},
		sidelen = 16,
		flags = "all_floors", "force_placement",
	    fill_ratio = 0.005,
		y_max = -11000,
		y_min = -31000,
		decoration = "chemistry:crystal",
	})

	minetest.register_node("chemistry:crystal", {
		description = S("Strong Crystal"),
		drawtype = "plantlike",
		tiles = {"crystal.png"},
		inventory_image = "crystal.png",
		wield_image = "crystal.png",
		paramtype = "light",
		light_source = 15,
		sunlight_propagates = true,
		walkable = true,
		damage_per_second = 0,
		groups = {cracky = 1, falling_node=1, level=7},
		sounds = default.node_sound_glass_defaults(),
		selection_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		node_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		drop = "chemistry:crystal_shard",
		on_blast = function() end,
	})

	minetest.register_craftitem("chemistry:crystal_shard", {
		description = S("Strong Crystal Shard"),
		inventory_image = "crystal_shard.png",
	})
	
	minetest.register_decoration({
		name = "chemistry:cesium_crystal",
		deco_type = "simple",
		place_on = {"chemistry:alkaline_sand"},
		sidelen = 16,
		flags = "all_floors",
	    fill_ratio = 0.005,
		y_max = 110,
		y_min = -0,
		decoration = "chemistry:cesium_crystal",
	})

-- Nodes and Ores Definitions

minetest.register_node("chemistry:sand_with_lithium", {
	description = S("Sand Lithium Ore"),
	tiles = {"alkaline_sand.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_sodium", {
	description = S("Sand Sodium Ore"),
	tiles = {"alkaline_sand.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_potassium", {
	description = S("Sand Potassium Ore"),
	tiles = {"alkaline_sand.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_rubidium", {
	description = S("Sand Rubidium Ore"),
	tiles = {"alkaline_sand.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sandstone_with_cesium", {
	description = S("Sandstone Cesium Ore"),
	tiles = {"alkaline_sandstone.png^cesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:cesium_shard 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cesium_shard'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_lithium", {
	description = S("Sandstone Lithium Ore"),
	tiles = {"alkaline_sandstone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_sodium", {
	description = S("Sandstone Sodium Ore"),
	tiles = {"alkaline_sandstone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_potassium", {
	description = S("Sandstone Potassium Ore"),
	tiles = {"alkaline_sandstone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_rubidium", {
	description = S("Sandstone Rubidium Ore"),
	tiles = {"alkaline_sandstone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_lithium", {
	description = S("Alkaline Stone Lithium Ore"),
	tiles = {"alkaline_stone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_sodium", {
	description = S("Alkaline Stone Sodium Ore"),
	tiles = {"alkaline_stone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_potassium", {
	description = S("Alkaline Stone Potassium Ore"),
	tiles = {"alkaline_stone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_rubidium", {
	description = S("Alkaline Stone Rubidium Ore"),
	tiles = {"alkaline_stone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_cesium", {
	description = S("Alkaline Stone Cesium Ore"),
	tiles = {"alkaline_stone.png^cesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:cesium_shard 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cesium_shard'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_francium", {
	description = S("Alkaline Stone Francium Ore"),
	tiles = {"alkaline_stone.png^francium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1, radioactive = 2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:francium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:francium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone", {
	description = S("Alkaline Sandstone"),
	tiles = {"alkaline_sandstone.png"},
	groups = {crumbly = 1, cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_stone", {
	description = S("Alkaline Stone"),
	tiles = {"alkaline_stone.png"},
   drop = "default:cobble",
	groups = {cracky = 3, alkaline = 1, alkaline_stone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_brick", {
	description = S("Alkaline Sandstone Brick"),
	tiles = {"alkaline_sandstone_brick.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_brick_cracked", {
	description = S("Cracked Alkaline Sandstone Brick"),
	tiles = {"alkaline_sandstone_brick_cracked.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sandstone_block", {
	description = S("Alkaline Sandstone Block"),
	tiles = {"alkaline_sandstone_block.png"},
	groups = {cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alkaline_sand", {
	description = S("Alkaline Sand"),
	tiles = {"alkaline_sand.png"},
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_block 9',
	recipe = {
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone'},
	}
})

minetest.register_craft({
	output = 'chemistry:alkaline_sandstone_brick 4',
	recipe = {
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', ''},
		{'chemistry:alkaline_sandstone', 'chemistry:alkaline_sandstone', ''},
		{'', '', ''},
	}
})

stairs.register_stair(
	"alkaline_sandstone_brick",
	"chemistry:alkaline_sandstone_brick",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_brick.png"},
	S("Alkaline Sandstone Brick Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"alkaline_sandstone_brick",
	"chemistry:alkaline_sandstone_brick",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_brick.png"},
	S("Alkaline Sandstone Brick Slab"),
	default.node_sound_stone_defaults()
)

stairs.register_stair(
	"alkaline_sandstone_block",
	"chemistry:alkaline_sandstone_block",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_block.png"},
	S("Alkaline Sandstone Block Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"alkaline_sandstone_block",
	"chemistry:alkaline_sandstone_block",
	{cracky = 3, alkaline = 1, alkaline_sandstone = 1},
	{"alkaline_sandstone_block.png"},
	S("Alkaline Sandstone Block Slab"),
	default.node_sound_stone_defaults()
)

minetest.register_craft({
	type = "cooking",
	cooktime = 3,
	output = "chemistry:alkaline_sandstone_brick",
	recipe = "chemistry:alkaline_sandstone_brick_cracked"
})

minetest.register_node("chemistry:stone", {
	description = S("Strong Stone"),
	tiles = {"strong_stone.png"},
	groups = {cracky = 1, strong_stone = 1},
	drop = "chemistry:stone_cobble",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_cobble", {
	description = S("Strong Cobblestone"),
	tiles = {"strong_cobblestone.png"},
	groups = {cracky = 1, strong_stone = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	type = "cooking",
	cooktime = 6,
	output = "chemistry:stone",
	recipe = "chemistry:stone_cobble"
})

minetest.register_node("chemistry:stone_brick", {
	description = S("Strong Stone Brick"),
	tiles = {"strong_stone_brick.png"},
	groups = {cracky = 1, strong_stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_block", {
	description = S("Strong Stone Block"),
	tiles = {"strong_stone_block.png"},
	groups = {cracky = 1, strong_stone = 1, level = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_brick_cracked", {
	description = S("Cracked Strong Stone Brick"),
	tiles = {"strong_stone_brick_cracked.png"},
	groups = {cracky = 1, strong_stone = 1},
	sounds = default.node_sound_stone_defaults(),
})

stairs.register_stair(
	"stone_cobble",
	"chemistry:stone_cobble",
	{cracky = 1, strong_stone = 1, level = 1},
	{"strong_cobblestone.png"},
	S("Strong Cobblestone Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"stone_cobble",
	"chemistry:stone_cobble",
	{cracky = 1, strong_stone = 1, level = 1},
	{"strong_cobblestone.png"},
	S("Strong Cobblestone Slab"),
	default.node_sound_stone_defaults()
)
stairs.register_stair(
	"stone_brick",
	"chemistry:stone_brick",
	{cracky = 1, strong_stone = 1, level = 1},
	{"strong_stone_brick.png"},
	S("Strong Stone Brick Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"stone_brick",
	"chemistry:stone_brick",
	{cracky = 1, strong_stone = 1, level = 1},
	{"strong_stone_brick.png"},
	S("Strong Stone Brick Slab"),
	default.node_sound_stone_defaults()
)
stairs.register_stair(
	"stone_block",
	"chemistry:stone_block",
	{cracky = 1, strong_stone = 1, level = 1},
	{"strong_stone_block.png"},
	S("Strong Stone Block Stair"),
	default.node_sound_stone_defaults()
)
stairs.register_slab(
	"stone_block",
	"chemistry:stone_block",
	{cracky = 1, strong_stone = 1, level = 1},
	{"strong_stone_block.png"},
	S("Strong Stone Block Slab"),
	default.node_sound_stone_defaults()
)
minetest.register_craft({
	output = 'chemistry:stone_brick 4',
	recipe = {
		{'chemistry:stone', 'chemistry:stone', ''},
		{'chemistry:stone', 'chemistry:stone', ''},
		{'', '', ''},
	}
})

minetest.register_craft({
	output = 'chemistry:stone_block 9',
	recipe = {
		{'chemistry:stone', 'chemistry:stone', 'chemistry:stone'},
		{'chemistry:stone', 'chemistry:stone', 'chemistry:stone'},
		{'chemistry:stone', 'chemistry:stone', 'chemistry:stone'},
	}
})

minetest.register_craft({
	type = "cooking",
	cooktime = 20,
	output = "chemistry:stone_brick",
	recipe = "chemistry:stone_brick_cracked"
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})




minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_lithium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_lithium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_sodium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_sodium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_potassium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_potassium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_rubidium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_rubidium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_cesium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_cesium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})





minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_lithium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_lithium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_sodium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_sodium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_potassium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_potassium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_rubidium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_rubidium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_cesium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_cesium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_francium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 2,
	clust_size     = 1,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_francium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 2,
	clust_size     = 1,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_node("chemistry:strong_stone_with_anthracite", {
	description = S("Strong Anthracite Ore"),
	tiles = {"strong_stone.png^anthracite_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 1},
	drop = "chemistry:anthracite",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_titanium", {
	description = S("Strong Titanium Ore"),
	tiles = {{
	name = "strong_stone_32px.png^titanium_mineral.png",
	align_style = "world",
	scale       = 2,
   }},
	is_ground_content = true,
	groups = {cracky=1, level=3},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:titanium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:titanium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_cobalt", {
	description = S("Strong Cobalt Ore"),
	tiles = {"strong_stone.png^cobalt_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 4},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:cobalt_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_osmium", {
	description = S("Strong Osmium Ore"),
	tiles = {"strong_stone.png^osmium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 5},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:osmium_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:osmium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_tungsten", {
	description = S("Strong Tungsten Ore"),
	tiles = {"strong_stone.png^tungsten_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 6},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:tungsten_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_diamond", {
	description = S("Strong Diamond Ore"),
	tiles = {"strong_stone.png^default_mineral_diamond.png"},
	groups = {cracky = 1, level = 2},
	drop = "default:diamond",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_magnesium", {
	description = S("Strong Magnesium Ore"),
	tiles = {"strong_stone.png^magnesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:magnesium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:magnesium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_gas_seep", {
	description = S("Strong Natural Gas Seep"),
	tiles = {"strong_stone.png^[combine:16x80:0,-32=crack_anylength.png"},
	groups = {cracky = 1, pickaxey=1, building_block=1, material_stone=1},
	sounds = default.node_sound_stone_defaults(),
	drop = {
		max_items = 2,
		items = {
			{
				items = {'chemistry:methane 1'},    --The 3 drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:stone_cobble'},    --The 1st drops
			},
			{
				items = {'chemistry:butane 1'},    --The 3 other drops with a 1/3 chance
				rarity = 2,
			},
		}
	},
	is_ground_content = true,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_magnesium",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_magnesium",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_diamond",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_diamond",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_mese",
	wherein        = "chemistry:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_mese",
	wherein        = "chemistry:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_gold",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_gold",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 12,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 15,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 30 * 30 * 30,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_gas_seep",
	wherein        = "chemistry:stone",
	clust_scarcity = 20 * 20 * 20,
	clust_num_ores = 3,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -12500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_titanium",
	wherein        = "chemistry:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_titanium",
	wherein        = "chemistry:stone",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -13000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_cobalt",
	wherein        = "chemistry:stone",
	clust_scarcity = 18 * 18 * 18,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_cobalt",
	wherein        = "chemistry:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -13000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_osmium",
	wherein        = "chemistry:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_osmium",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -14000,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_tungsten",
	wherein        = "chemistry:stone",
	clust_scarcity = 21 * 21 * 21,
	clust_num_ores = 3,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_tungsten",
	wherein        = "chemistry:stone",
	clust_scarcity = 14 * 14 * 14,
	clust_num_ores = 6,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -15000,
})

minetest.register_node("chemistry:strong_stone_with_gold", {
	description = S("Strong Gold Ore"),
	tiles = {"strong_stone.png^default_mineral_gold.png"},
	groups = {cracky = 1, level = 1},
	drop = "default:gold_lump",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_mese", {
	description = S("Strong Mese Ore"),
	tiles = {"strong_stone.png^default_mineral_mese.png"},
	groups = {cracky = 1, level = 2},
	drop = "default:mese_crystal",
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craftitem("chemistry:stone_ingot", {
	description = S("Stronger Stone Ingot"),
	inventory_image = "stronger_stone_ingot.png",
})

minetest.register_craftitem("chemistry:stone_lump", {
	description = S("Stronger Stone Lump"),
	inventory_image = "stronger_stone_lump.png",
})

minetest.register_craft({
	type = "cooking",
	cooktime = 25,
	output = "chemistry:stone_ingot",
	recipe = "chemistry:stone_lump"
})

minetest.register_node("chemistry:stronger_stone_block", {
	description = S("Stronger Stone Block"),
	tiles = {"stronger_stone_block.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 9},
	on_blast = function() end,
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craft({
	output = 'chemistry:stronger_stone_block',
	recipe = {
		{'chemistry:stone_ingot', 'chemistry:stone_ingot', 'chemistry:stone_ingot'},
		{'chemistry:stone_ingot', 'chemistry:stone_ingot', 'chemistry:stone_ingot'},
		{'chemistry:stone_ingot', 'chemistry:stone_ingot', 'chemistry:stone_ingot'},
	}
})

minetest.register_craft({
	output = 'chemistry:stone_ingot 9',
	recipe = {
		{'chemistry:stronger_stone_block'},
	}
})

minetest.register_craft({
	output = 'chemistry:stone_lump',
	recipe = {
		{'chemistry:crystal_shard', 'chemistry:crystal_shard', 'chemistry:crystal_shard'},
		{'chemistry:crystal_shard', 'chemistry:stone', 'chemistry:crystal_shard'},
		{'chemistry:crystal_shard', 'chemistry:crystal_shard', 'chemistry:crystal_shard'},
	}
})

minetest.register_node("chemistry:dirt_with_uranyl", {
	description = S("Dirt with Uranyl"),
	tiles = {{
	name = "uranium_dioxide.png",
	align_style = "world",
	scale       = 2,
        },
	 "default_dirt.png",
		{name = "default_dirt.png^uranium_field.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, soil = 1, spreading_dirt_type = 1, radioactive = 1},
	drop = "default:dirt",
	sounds = default.node_sound_dirt_defaults({
		footstep = {name = "default_grass_footstep", gain = 0.25},
	}),
})

minetest.register_node("chemistry:ionized_trunk", {
	description = S("Ionized Tree Trunk"),
	tiles = {"ionized_tree_top.png", "ionized_tree_top.png", "ionized_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2, radioactive = 1, ionized_wood=1},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("chemistry:ionized_wood", {
	description = S("Ionized Wood Planks"),
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"ionized_wood.png"},
	is_ground_content = false,
	groups = {choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, ionized_wood=1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("chemistry:ionized_sapling", {
    description = S("Ionized Tree Sapling"),
	drawtype = "plantlike",
	tiles = {"ionized_sapling.png"},
	inventory_image = "ionized_sapling.png",
	wield_image = "ionized_sapling.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3, flammable = 2,
		attached_node = 1, sapling = 1, radioactive = 1, ionized_wood=1},
	sounds = default.node_sound_leaves_defaults(),

	on_timer = grow_sapling,
	
	on_construct = function(pos)
		minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,
	
	on_place = function(itemstack, placer, pointed_thing)
		return prepare_on_place(itemstack, placer, pointed_thing,
				"chemistry:ionized_sapling", 2, 7)
	end,
})

minetest.register_node("chemistry:ionized_leaves", {
	description = S("Ionized Tree Leaves"),
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"ionized_leaves.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 3, leafdecay = 3, flammable = 2, leaves = 1, radioactive = 1, ionized_wood=1},
	drop = {
		max_items = 1,
		items = {
			{
				-- player will get sapling with 1/20 chance
				items = {"chemistry:ionized_sapling"},
				rarity = 20,
			},
			{
				-- player will get leaves only if he get no saplings,
				-- this is because max_items is 1
				items = {"chemistry:ionized_leaves"},
			}
		}
	},
	sounds = default.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})

minetest.register_node("chemistry:anthracite_trunk", {
	description = S("Anthracite Tree Trunk"),
	tiles = {"anthracite_tree_top.png", "anthracite_tree_top.png", "anthracite_tree.png"},
	paramtype2 = "facedir",
	is_ground_content = false,
	groups = {tree = 1, choppy = 2, anthracite_material = 1, level = 1},
	sounds = default.node_sound_wood_defaults(),

	on_place = minetest.rotate_node
})

minetest.register_node("chemistry:anthracite_wood", {
	description = S("Anthracite Wood Planks"),
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"anthracite_wood.png"},
	is_ground_content = false,
	groups = {choppy = 1, oddly_breakable_by_hand = 2, wood = 1, anthracite_material = 1, level = 1},
	sounds = default.node_sound_wood_defaults(),
})

minetest.register_node("chemistry:anthracite_sapling", {
    description = S("Anthracite Tree Sapling"),
	drawtype = "plantlike",
	tiles = {"anthracite_sapling.png"},
	inventory_image = "anthracite_sapling.png",
	wield_image = "anthracite_sapling.png",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, 7 / 16, 4 / 16}
	},
	groups = {snappy = 2, dig_immediate = 3,
		attached_node = 1, sapling = 1, anthracite_material = 1},
	sounds = default.node_sound_leaves_defaults(),

	on_timer = grow_sapling,
	
	on_construct = function(pos)
		minetest.get_node_timer(pos):start(math.random(300, 1500))
	end,
	
	on_place = function(itemstack, placer, pointed_thing)
		return prepare_on_place(itemstack, placer, pointed_thing,
				"chemistry:anthracite_sapling", 2, 7)
	end,
})

minetest.register_node("chemistry:anthracite_leaves", {
	description = S("Anthracite Tree Leaves"),
	drawtype = "allfaces_optional",
	waving = 1,
	tiles = {"anthracite_leaves.png"},
	paramtype = "light",
	is_ground_content = false,
	groups = {snappy = 2, leafdecay = 3, leaves = 1, anthracite_material = 1},
	drop = {
		max_items = 1,
		items = {
			{
				-- player will get sapling with 1/20 chance
				items = {"chemistry:anthracite_sapling"},
				rarity = 20,
			},
			{
				-- player will get leaves only if he get no saplings,
				-- this is because max_items is 1
				items = {"chemistry:anthracite_leaves"},
			}
		}
	},
	sounds = default.node_sound_leaves_defaults(),

	after_place_node = after_place_leaves,
})


minetest.register_craft({
	output = "chemistry:ionized_wood 4",
	recipe = {
		{"chemistry:ionized_trunk"},
	}
})

minetest.register_craft({
	output = "chemistry:anthracite_wood 4",
	recipe = {
		{"chemistry:anthracite_trunk"},
	}
})

stairs.register_stair(
	"ionized_wood",
	"chemistry:ionized_wood",
	{choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, ionized_wood=1},
	{"ionized_wood.png"},
	S("Ionized Wood Stair"),
	default.node_sound_wood_defaults()
)
stairs.register_slab(
	"ionized_wood",
	"chemistry:ionized_wood",
	{choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, ionized_wood=1},
	{"ionized_wood.png"},
	S("Ionized Wood Slab"),
	default.node_sound_wood_defaults()
)

stairs.register_stair(
	"anthracite_wood",
	"chemistry:anthracite_wood",
	{choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, anthracite_material = 1},
	{"anthracite_wood.png"},
	S("Anthracite Wood Stair"),
	default.node_sound_wood_defaults()
)
stairs.register_slab(
	"anthracite_wood",
	"chemistry:anthracite_wood",
	{choppy = 2, oddly_breakable_by_hand = 2, flammable = 2, wood = 1, anthracite_material = 1},
	{"anthracite_wood.png"},
	S("Anthracite Wood Slab"),
	default.node_sound_wood_defaults()
)


minetest.register_node("chemistry:stone_cobble_glow1", {
	description = S("Strong Cobblestone with Strong Lava"),
	tiles = {
		{
			name = "st_lava_flowing_anim.png^strong_cobblestone_template.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 2.0
			}
		}
	},
	groups = {cracky = 1, strong_stone = 1, igniter = 1},
	drop = "chemistry:stone_cobble",
	sounds = default.node_sound_stone_defaults(),
	light_source = default.LIGHT_MAX,
})


minetest.register_node("chemistry:stone_cobble_glow2", {
	description = S("Strong Cobblestone with Molten Metal"),
	tiles = {
		{
			name = "molten_metal_flowing.png^[colorize:yellow:125^strong_cobblestone_template.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 1.0
			}
		}
	},
	groups = {cracky = 1, strong_stone = 1},
	drop = "chemistry:stone_cobble",
	sounds = default.node_sound_stone_defaults(),
	light_source = 14,
})

minetest.register_node("chemistry:stone_cobble_glow3", {
	description = S("Strong Cobblestone with Molten Metal"),
	tiles = {
		{
			name = "lmetal_flowing_anim.png^strong_cobblestone_template.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 1.0
			}
		}
	},
	groups = {cracky = 1, strong_stone = 1},
	drop = "chemistry:stone_cobble",
	sounds = default.node_sound_stone_defaults(),
	light_source = 7,
})

minetest.register_abm({
	label = "chemistry:cobblestone",
	nodenames = {"chemistry:stone_cobble"}, -- checking for ignition sources because there will be fewer than there are gas nodes
	neighbors = {"group:strong_lava"},
	interval = 5.0,
	chance = 7,
	catch_up = true,
	action = function(pos, node)
		minetest.swap_node(pos, {name="chemistry:stone_cobble_glow1"})
	end,
})

minetest.register_abm({
	label = "chemistry:cobblestone",
	nodenames = {"chemistry:stone_cobble"}, -- checking for ignition sources because there will be fewer than there are gas nodes
	neighbors = {"group:mmetal"},
	interval = 5.0,
	chance = 7,
	catch_up = true,
	action = function(pos, node)
		minetest.swap_node(pos, {name="chemistry:stone_cobble_glow2"})
	end,
})

minetest.register_abm({
	label = "chemistry:cobblestone",
	nodenames = {"chemistry:stone_cobble"}, -- checking for ignition sources because there will be fewer than there are gas nodes
	neighbors = {"group:hot_metal"},
	interval = 5.0,
	chance = 7,
	catch_up = true,
	action = function(pos, node)
		minetest.swap_node(pos, {name="chemistry:stone_cobble_glow3"})
	end,
})
