
local S = minetest.get_translator("chemistry")

if minetest.get_modpath("technic") then
minetest.register_craft({
	output = 'chemistry:glow_water2_bucket',
	recipe = {
		{'bucket:bucket_water', 'chemistry:radium_dust', 'chemistry:zinc_sulfide'},
	},
})
end

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:glow_water1_bucket',
	recipe = {
		'group:glowing_water', 'dye:red',
	},
})

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:glow_water2_bucket',
	recipe = {
		'group:glowing_water', 'dye:cyan', 'dye:green',
	},
})

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:glow_water3_bucket',
	recipe = {
		'group:glowing_water', 'dye:blue',
	},
})

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:glow_water4_bucket',
	recipe = {
		'group:glowing_water', 'dye:yellow',
	},
})

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:glow_water5_bucket',
	recipe = {
		'group:glowing_water', 'dye:pink',
	},
})

minetest.register_node("chemistry:glow_water1", {
	description = S("Red Glow Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "rliquid_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "rliquid_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glow_water1_flowing",
	liquid_alternative_source = "chemistry:glow_water1",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:glow_water1_flowing", {
	description = S("Flowing Red Glow Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"rliquid.png"},
	special_tiles = {
		{
			name = "rliquid_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "rliquid_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glow_water1_flowing",
	liquid_alternative_source = "chemistry:glow_water1",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:glow_water1",
		"chemistry:glow_water1_flowing",
		"chemistry:glow_water1_bucket",
		"red_wt_bucket.png",
		S("Red Glow Water Bucket"),
		{tool = 1, glowing_water = 1}
	)

minetest.register_node("chemistry:glow_water2", {
	description = S("Radioactive Green Glow Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "rgliquid_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "rgliquid_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glow_water2_flowing",
	liquid_alternative_source = "chemistry:glow_water2",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 0, g = 123, b = 98},
	groups = {liquid = 3, cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:glow_water2_flowing", {
	description = S("Flowing Radioactive Green Glow Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"rgliquid.png"},
	special_tiles = {
		{
			name = "rgliquid_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "rgliquid_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glow_water2_flowing",
	liquid_alternative_source = "chemistry:glow_water2",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 0, g = 123, b = 98},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:glow_water2",
		"chemistry:glow_water2_flowing",
		"chemistry:glow_water2_bucket",
		"radioactive_green_wt_bucket.png",
		S("Radioactive Green Glow Water Bucket"),
		{tool = 1, glowing_water = 1}
	)

minetest.register_node("chemistry:glow_water3", {
	description = S("Blue Glow Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "bliquid_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "bliquid_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glow_water3_flowing",
	liquid_alternative_source = "chemistry:glow_water3",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 0, g = 0, b = 122},
	groups = {liquid = 3, cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:glow_water3_flowing", {
	description = S("Flowing Blue Glow Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"rliquid.png"},
	special_tiles = {
		{
			name = "bliquid_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "bliquid_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glow_water3_flowing",
	liquid_alternative_source = "chemistry:glow_water3",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 0, g = 0, b = 122},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:glow_water3",
		"chemistry:glow_water3_flowing",
		"chemistry:glow_water3_bucket",
		"blue_wt_bucket.png",
		S("Blue Glow Water Bucket"),
		{tool = 1, glowing_water = 1}
	)

minetest.register_node("chemistry:glow_water4", {
	description = S("Yellow Glow Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "yliquid_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "yliquid_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glow_water4_flowing",
	liquid_alternative_source = "chemistry:glow_water4",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:glow_water4_flowing", {
	description = S("Flowing Yellow Glow Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"rliquid.png"},
	special_tiles = {
		{
			name = "yliquid_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "yliquid_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glow_water4_flowing",
	liquid_alternative_source = "chemistry:glow_water4",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 122, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:glow_water4",
		"chemistry:glow_water4_flowing",
		"chemistry:glow_water4_bucket",
		"yellow_wt_bucket.png",
		S("Yellow Glow Water Bucket"),
		{tool = 1, glowing_water = 1}
	)

minetest.register_node("chemistry:glow_water5", {
	description = S("Pink Glow Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "pliquid_source_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "pliquid_source_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:glow_water5_flowing",
	liquid_alternative_source = "chemistry:glow_water5",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:glow_water5_flowing", {
	description = S("Flowing Pink Glow Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"pliquid.png"},
	special_tiles = {
		{
			name = "pliquid_flowing_animated.png^[opacity:180",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "pliquid_flowing_animated.png^[opacity:180",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
   light_source = 7,
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 0,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
   glow = 7,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:glow_water5_flowing",
	liquid_alternative_source = "chemistry:glow_water5",
	liquid_viscosity = 1,
	post_effect_color = {a = 122, r = 122, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, water = 3},
	sounds = default.node_sound_water_defaults(),
})

	bucket.register_liquid(
		"chemistry:glow_water5",
		"chemistry:glow_water5_flowing",
		"chemistry:glow_water5_bucket",
		"pink_wt_bucket.png",
		S("Pink Glow Water Bucket"),
		{tool = 1, glowing_water = 1}
	)

