
local S = minetest.get_translator("chemistry")

minetest.register_abm({
	nodenames = {"chemistry:radiation_detector"},
	interval = 2,
	chance = 1,
	catch_up = true,

	action = function(pos, node)

		if #minetest.find_nodes_in_area_under_air(
				{x = pos.x - 10, y = pos.y - 10, z = pos.z - 10},
				{x = pos.x + 10, y = pos.y + 10, z = pos.z + 10}, "group:radioactive") >= 1 then

				minetest.sound_play(
					"radiation",
					{pos = pos, max_hear_distance = 10, gain = 0.05}
             )
		end
	end
})

minetest.register_node("chemistry:radiation_detector", {
	description = S("Radiation Detector"),
	tiles = {"titanium_block.png", "titanium_block.png", "default_steel_block.png^radiation_sign.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 1},
	sounds = default.node_sound_metal_defaults(),
})

minetest.register_craft({
	output = 'chemistry:radiation_detector',
	recipe = {
		{'default:steel_ingot', 'default:mese_crystal', 'default:steel_ingot'},
		{'default:steel_ingot', 'chemistry:americium', 'default:steel_ingot'},
		{'default:steel_ingot', 'chemistry:titanium', 'default:steel_ingot'},
	}
})

