
local S = chemistry.getter

local function register_dust(name, ingot)
	local lname = string.lower(name)
	lname = string.gsub(lname, ' ', '_')
	minetest.register_craftitem("chemistry:"..lname.."_dust", {
		description = S("%s Dust"):format(S(name)),
		inventory_image = lname.."_dust.png",
	})
	minetest.register_craft({
		type = "cooking",
		recipe = "chemistry:"..lname.."_dust",
		output = "chemistry:"..lname,
	})
	technic.register_grinder_recipe({ input = {"chemistry:"..lname}, output = "chemistry:"..lname.."_dust 1" })
end

-- Sorted alphabetically
local dusts = {
	{"Aluminium", "chemistry:aluminium"},
	{"Cobalt", "chemistry:cobalt"},
	{"Osmium", "chemistry:osmium"},
	{"Titanium", "chemistry:titanium"},
	{"Tungsten", "chemistry:tungsten"},
	{"Tungsten Carbide", "chemistry:tungsten_carbide"},
   {"Radium", "chemistry:radium"},
}

for _, data in ipairs(dusts) do
	register_dust(data[1], data[2])
end

minetest.override_item("chemistry:tungsten_carbide_dust", {
	inventory_image = "tungsten_dust.png^[colorize:white:75",
})

minetest.override_item("chemistry:titanium_dust", {
	inventory_image = "tungsten_dust.png^[brighten:75",
})

minetest.override_item("chemistry:cobalt_dust", {
	inventory_image = "tungsten_dust.png^[colorize:#0050F5:150",
})

minetest.override_item("chemistry:osmium_dust", {
	inventory_image = "aluminium_dust.png^[colorize:#AAF0F0:122",
})

