
local ignite = {name="fire:basic_flame"}
minetest.register_abm({
		label = "chemistry:fuel flammability normal",
		nodenames = {"air"}, 
		neighbors = {"group:fuel"},
		interval = 2.0,
		chance = 4,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "group:igniter") then
				minetest.set_node(pos, ignite)
			end
		end,
	})

minetest.register_abm({
		label = "chemistry:fuel remove",
		nodenames = {"group:fuel"}, 
		neighbors = {"fire:basic_flame"},
		interval = 2.0,
		chance = 7,
		catch_up = true,
		action = function(pos, node)
			local p = minetest.find_node_near(pos, 1, {"group:igniter"})
			if not p then
				return
			end
			local flammable_node = minetest.get_node(pos)
			local def = minetest.registered_nodes[flammable_node.name]
			if def.on_burn then
				def.on_burn(pos)
			else
				minetest.remove_node(pos)
				minetest.check_for_falling(pos)
			end
		end,
	})

