
local S = chemistry.getter

local corrosion_resistance_level_1 = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "group:choppy"}
local corrosion_resistance_level_2 = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "group:choppy", "group:crumbly", "default:steel_block"}
local corrosion_resistance_level_3 = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "group:choppy", "group:crumbly", "default:steelblock", "default:copperblock", "default:obsidian", "default:obsidian_block", "default:obsidian_brick"}
local corrosion_resistance_level_4 = {"group:soil", "group:sand", "default:gravel", "default:clay", "nether:basalt", "group:leaves", "group:tree", "group:wool", "groups:flora", "groups:flower", "chemistry:aluminium_block", "group:choppy", "group:crumbly", "default:steelblock", "default:copperblock", "default:obsidian", "default:obsidian_block", "default:obsidian_brick", "default:gold_block", "group:lava", "moreores:mithril_block", "moreores:silver_block"}

minetest.register_node("chemistry:corroded_stone", {
	description = S("Corroded Stone"),
	tiles = {"corroded_stone.png"},
	groups = {cracky = 3, oddly_breakable_by_hand = 1},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_craft({
	output = 'basic_materials:silicon',
	recipe = {
		{'chemistry:corroded_stone'},
	}
})

	minetest.register_abm({
		label = "chemistry:stone_reaction",
		nodenames = {"chemistry:impurities_steelblock", "chemistry:impurities_copperblock", "chemistry:impurities_tinblock"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:acid"},
		interval = 5.0,
		chance = 15,
		catch_up = true,
		action = function(pos, node)
	      if node.name == "chemistry:impurities_steelblock" then
		      minetest.set_node(pos, {name = "default:steelblock"})
	      elseif node.name == "chemistry:impurities_copperblock" then
		      minetest.set_node(pos, {name = "default:copperblock"})
	      elseif node.name == "chemistry:impurities_tinblock" then
		      minetest.set_node(pos, {name = "default:tinblock"})
			end	
		end,
	})

local output_node = {name="chemistry:corroded_stone"}
	minetest.register_abm({
		label = "chemistry:stone_reaction",
		nodenames = {"group:stone"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"group:acid"},
		interval = 1.0,
		chance = 7,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.set_node(pos, output_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

local output_node = {name="chemistry:hydrogen"}
	minetest.register_abm({
		label = "chemistry:aluminium_reaction",
		nodenames = {"group:acid"}, -- checking for ignition sources because there will be fewer than there are gas nodes
		neighbors = {"chemistry:aluminium_block", "technic:zinc_block"},
		interval = 1.0,
		chance = 7,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.set_node(pos, output_node)
				if math.random() < 0.01 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry:corrosion normal",
		nodenames = {"group:liquid"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			local nodedef = minetest.registered_nodes[node.name]
			local p = minetest.find_node_near(pos, 1, corrosion_resistance_level_1)
			if p and nodedef.acid == true and nodedef.acid_level >= 0 then
				minetest.set_node(p, output_node)
			end
		end,
	})

minetest.register_abm({
		label = "chemistry:corrosion slightly strong", 
		nodenames = {"group:liquid"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			local nodedef = minetest.registered_nodes[node.name]
			local p = minetest.find_node_near(pos, 1, corrosion_resistance_level_2)
			if p and nodedef.acid == true and nodedef.acid_level >= 1 then
				minetest.set_node(p, output_node)
			end
		end,
	})

local output_node2 = {name="chemistry:nitrogen_dioxide"}
minetest.register_abm({
		label = "chemistry:corrosion nitric",
		nodenames = {"group:liquid"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			local nodedef = minetest.registered_nodes[node.name]
			local p = minetest.find_node_near(pos, 1, corrosion_resistance_level_3)
			if p and nodedef.acid == true and nodedef.acid_level >= 2 and nodedef.acid_flags == "contains_nitrogen" then
				minetest.set_node(p, output_node2)
				if math.random() < 0.75 then
					minetest.set_node(p, output_node)
				end
			end
		end,
	})

local input_node = {name="chemistry:hno_acid"}
minetest.register_abm({
		label = "chemistry:corrosion nitric",
		nodenames = {"default:water_source"}, -- checking for nodes that can be corroded
		neighbors = {"chemistry:nitrogen_dioxide"},
		interval = 5.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			if minetest.find_node_near(pos, 1, "air") then
				minetest.set_node(pos, input_node)
				if math.random() < 0.5 then
					minetest.set_node(pos, {name="air"})
				end
			end	
		end,
	})

minetest.register_abm({
		label = "chemistry:corrosion very strong",
		nodenames = {"group:liquid"},
		interval = 10.0,
		chance = 10,
		catch_up = true,
		action = function(pos, node)
			local nodedef = minetest.registered_nodes[node.name]
			local p = minetest.find_node_near(pos, 1, corrosion_resistance_level_4)
			if p and nodedef.acid == true and nodedef.acid_level >= 3 then
				minetest.set_node(p, output_node)
			end
		end,
	})

minetest.register_abm({
		label = "chemistry:corrosion piranha",
		nodenames = {"group:leaves", "group:flora", "group:tree", "group:wood", "group:sapling", "group:Leafdecay"}, 
		neighbors = {"chemistry:piranha_solution", "chemistry:piranha_solution_flowing"},
		interval = 5.0,
		chance = 5,
		catch_up = true,
		action = function(pos, node)
			local nodedef = minetest.registered_nodes[node.name]
			local p = minetest.find_node_near(pos, 1, corrosion_resistance_level_2)
			if p and nodedef.acid == true and nodedef.acid_level >= 1 and nodedef.acid_flags == "carbon_turns_into_dioxide" then
				minetest.set_node(p, {name="chemistry:carbon_dioxide"})
			end
		end,
	})

