
local S = chemistry.getter

 ---
 --- Ore Register
 ---

minetest.register_node("chemistry:strong_stone_with_gem", {
	description = S("Strong Gem Ore"),
	tiles = {
		{
			name = "strong_stone_gradient.png^strong_gem_mineral_anim.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 4.0
			}
		}
	},
	groups = {cracky = 1, level = 10},
	sounds = default.node_sound_stone_defaults(),
	light_source = 7,
   glow = 7,
	drop = "chemistry:strong_gem"
})

minetest.register_node("chemistry:st_obsidian_with_gem", {
	description = S("Strong Obsidian Gem Ore"),
	tiles = {
		{
			name = "st_obsidian_gradient.png^strong_gem_mineral_anim.png",
			animation = {
				type = "vertical_frames", aspect_w = 16, aspect_h = 16, length = 4.0
			}
		}
	},
	groups = {cracky = 1, level = 10},
	sounds = default.node_sound_stone_defaults(),
	light_source = 7,
   glow = 7,
	drop = "chemistry:strong_gem"
})

minetest.register_node("chemistry:strong_stone_with_anthracite", {
	description = S("Strong Anthracite Ore"),
	tiles = {"strong_stone.png^anthracite_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 1},
	drop = "chemistry:anthracite",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_gold", {
	description = S("Strong Gold Ore"),
	tiles = {"strong_stone.png^default_mineral_gold.png"},
	groups = {cracky = 1, level = 1},
	drop = "default:gold_lump",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_mese", {
	description = S("Strong Mese Ore"),
	tiles = {"strong_stone.png^default_mineral_mese.png"},
	groups = {cracky = 1, level = 2},
	drop = "default:mese_crystal",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_titanium", {
	description = S("Strong Titanium Ore"),
	tiles = {"strong_stone.png^titanium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level=3},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:titanium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:titanium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_cobalt", {
	description = S("Strong Cobalt Ore"),
	tiles = {"strong_stone.png^cobalt_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 4},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:cobalt_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_osmium", {
	description = S("Strong Osmium Ore"),
	tiles = {"strong_stone.png^osmium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 5},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:osmium_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:osmium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:strong_stone_with_tungsten", {
	description = S("Strong Tungsten Ore"),
	tiles = {"strong_stone.png^tungsten_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 6},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:tungsten_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_diamond", {
	description = S("Strong Diamond Ore"),
	tiles = {"strong_stone.png^default_mineral_diamond.png"},
	groups = {cracky = 1, level = 2},
	drop = "default:diamond",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_stone_with_magnesium", {
	description = S("Strong Magnesium Ore"),
	tiles = {"strong_stone.png^magnesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:magnesium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:magnesium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:strong_gas_seep", {
	description = S("Strong Natural Gas Seep"),
	tiles = {"strong_stone.png^[combine:16x80:0,-32=crack_anylength.png"},
	groups = {cracky = 1, pickaxey=1, building_block=1, material_stone=1},
	sounds = default.node_sound_stone_defaults(),
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:methane 1'},    --The 3 drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:stone_cobble'},    --The 1st drops
			},
			{
				items = {'chemistry:butane 1'},    --The 3 other drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:butane 1'},    --The 3 drops with a 1/2 chance
				rarity = 4,
			},
			{
				items = {'chemistry:methane 1'},    --The 3 drops with a 1/2 chance
				rarity = 4,
			},
		}
	},
	is_ground_content = true,
})
minetest.register_node("chemistry:sand_with_lithium", {
	description = S("Sand Lithium Ore"),
	tiles = {"alkaline_sand.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_sodium", {
	description = S("Sand Sodium Ore"),
	tiles = {"alkaline_sand.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_potassium", {
	description = S("Sand Potassium Ore"),
	tiles = {"alkaline_sand.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sand_with_rubidium", {
	description = S("Sand Rubidium Ore"),
	tiles = {"alkaline_sand.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {crumbly = 3, falling_node = 1, alkaline_sand = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_sand_defaults(),
})

minetest.register_node("chemistry:sandstone_with_cesium", {
	description = S("Sandstone Cesium Ore"),
	tiles = {"alkaline_sandstone.png^cesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:cesium_shard 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cesium_shard'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_lithium", {
	description = S("Sandstone Lithium Ore"),
	tiles = {"alkaline_sandstone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_sodium", {
	description = S("Sandstone Sodium Ore"),
	tiles = {"alkaline_sandstone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_potassium", {
	description = S("Sandstone Potassium Ore"),
	tiles = {"alkaline_sandstone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:sandstone_with_rubidium", {
	description = S("Sandstone Rubidium Ore"),
	tiles = {"alkaline_sandstone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_sandstone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_lithium", {
	description = S("Alkaline Stone Lithium Ore"),
	tiles = {"alkaline_stone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_sodium", {
	description = S("Alkaline Stone Sodium Ore"),
	tiles = {"alkaline_stone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_potassium", {
	description = S("Alkaline Stone Potassium Ore"),
	tiles = {"alkaline_stone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_rubidium", {
	description = S("Alkaline Stone Rubidium Ore"),
	tiles = {"alkaline_stone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_cesium", {
	description = S("Alkaline Stone Cesium Ore"),
	tiles = {"alkaline_stone.png^cesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:cesium_shard 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cesium_shard'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:alk_stone_with_francium", {
	description = S("Alkaline Stone Francium Ore"),
	tiles = {"alkaline_stone.png^francium_mineral.png"},
	is_ground_content = true,
	groups = {cracky = 3, falling_node = 0, alkaline_stone = 1, alkaline = 1, radioactive = 2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:francium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:francium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

	minetest.register_node("chemistry:antimony_crystal", {
		description = S("Antimony Crystal Ore"),
		drawtype = "plantlike",
		tiles = {"antimony_mineral.png"},
		inventory_image = "antimony_mineral.png",
		wield_image = "antimony_mineral.png",
		paramtype = "light",
		light_source = 5,
		sunlight_propagates = true,
		walkable = true,
		damage_per_second = 0,
		groups = {cracky = 1, falling_node=1, level=1},
		sounds = default.node_sound_glass_defaults(),
		selection_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		node_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		drop = "chemistry:antimony",
	})

	minetest.register_node("chemistry:uranyl_crystal", {
		description = S("Uranyl Crystal"),
		drawtype = "plantlike",
		tiles = {"uranyl_crystal.png"},
		inventory_image = "uranyl_crystal.png",
		wield_image = "uranyl_crystal.png",
		paramtype = "light",
		light_source = 7,
		sunlight_propagates = true,
		walkable = true,
		damage_per_second = 1,
		groups = {cracky = 1, falling_node=1, level=1, radioactive = 2},
		sounds = default.node_sound_glass_defaults(),
		selection_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		node_box = {
			type = "fixed", fixed = {-5 / 16, -0.5, -5 / 16, 5 / 16, 0, 5 / 16}
		},
		drop = "chemistry:uranyl_nitrate",
	})

minetest.register_node("chemistry:gas_seep", {
	description = S("Natural Gas Seep"),
	tiles = {"default_stone.png^[combine:16x80:0,-16=crack_anylength.png"},
	groups = {cracky = 3, pickaxey=1, building_block=1, material_stone=1},
	sounds = default.node_sound_stone_defaults(),
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:methane 1'},    --The 3 drops with a 1/5 chance
				rarity = 4,
			},
			{
				items = {'default:cobble'},    --The 1st drops
			},
			{
				items = {'chemistry:butane 1'},    --The 3 other drops with a 1/10 chance
				rarity = 4,
			},
			{
				items = {'chemistry:methane 1'},    --The 3 other drops with a 1/10 chance
				rarity = 8,
			},
			{
				items = {'chemistry:butane 1'},    --The 3 other drops with a 1/10 chance
				rarity = 8,
			},
		}
	},
	is_ground_content = true,
})

minetest.register_node("chemistry:sulfide_seep", {
	description = S("Hydrogen Sulfide Seep"),
	tiles = {"default_stone.png^sulfur_mineral.png^[combine:16x80:0,-16=crack_anylength.png"},
	groups = {cracky = 3, pickaxey=1, building_block=1, material_stone=1},
	sounds = default.node_sound_stone_defaults(),
	drop = {
		max_items = 1,
		items = {
			{
				items = {'chemistry:sulfur'},
				rarity = 4,
			},
			{
				items = {'default:cobble'},
			},
		}
	},
	is_ground_content = true,
})

minetest.register_node("chemistry:stone_with_magnesium", {
	description = S("Magnesium Ore"),
	tiles = {"default_stone.png^magnesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:magnesium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:magnesium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:magnesium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_anthracite", {
	description = S("Anthracite Ore"),
	tiles = {"default_stone.png^anthracite_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1},
	drop = "chemistry:anthracite",
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_arsenic", {
	description = S("Arsenic Ore"),
	tiles = {"default_stone.png^arsenic_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:arsenic 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:arsenic'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:arsenic'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:arsenic'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_calcium", {
	description = S("Calcium Ore"),
	tiles = {"default_stone.png^calcium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:calcium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:calcium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:calcium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:calcium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_manganese", {
	description = S("Manganese Ore"),
	tiles = {"default_stone.png^manganese_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 6,
		items = {
			{
				items = {'chemistry:manganese 2'},  
			},
			{
				items = {'chemistry:manganese'},    
				rarity = 5,
			},
			{
				items = {'chemistry:manganese_oxide 2'},    
			},
			{
				items = {'chemistry:manganese_oxide'},
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_titanium", {
	description = S("Titanium Ore"),
	tiles = {"default_stone.png^titanium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level=3},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:titanium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:titanium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:titanium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:stone_with_cobalt", {
	description = S("Cobalt Ore"),
	tiles = {"default_stone.png^cobalt_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 4},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:cobalt_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:cobalt_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:stone_with_osmium", {
	description = S("Osmium Ore"),
	tiles = {"default_stone.png^osmium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 5},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:osmium_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:osmium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:osmium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
minetest.register_node("chemistry:stone_with_tungsten", {
	description = S("Tungsten Ore"),
	tiles = {"default_stone.png^tungsten_mineral.png"},
	is_ground_content = true,
	groups = {cracky=1, level = 6},
	drop = {
		max_items = 4,
		items = {
			{
				items = {'chemistry:tungsten_raw'},  --The first and second drops ever
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 4th drops with a 1/3 chance
				rarity = 8,
			},
			{
				items = {'chemistry:tungsten_raw'},    --The 5th drops with a 1/8 chance
				rarity = 5,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_sulfur", {
	description = S("Sulfur Ore"),
	tiles = {"default_stone.png^sulfur_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sulfur 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sulfur'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sulfur'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sulfur'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_bismuth", {
	description = S("Bismuth Ore"),
	tiles = {"default_stone.png^bismuth_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:bismuth 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:bismuth'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:bismuth'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:bismuth'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_gallium", {
	description = S("Gallium Ore"),
	tiles = {"default_stone.png^gallium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:gallium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:gallium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:gallium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:gallium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_aluminium", {
	description = S("Aluminium Ore"),
	tiles = {"default_stone.png^aluminium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 6,
		items = {
			{
				items = {'chemistry:aluminium_raw 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:aluminium_raw'},    --The 3rd drops with a 1/2 chance
				rarity = 3,
			},
			{
				items = {'chemistry:aluminium_raw'},    --The 4th drops with a 1/3 chance
				rarity = 7,
			},
			{
				items = {'chemistry:aluminium_raw'},    --The 5th drops with a 1/8 chance
				rarity = 12,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

if minetest.get_modpath("technic") then
minetest.register_node("chemistry:thorite", {
	description = S("Thorite"),
	tiles = {"thorite.png"},
	is_ground_content = true,
	groups = {cracky=2, radioactive = 1},
	drop = {
		max_items = 6,
		items = {
			{
				items = {'chemistry:thorium_raw 2'},
			},
			{
				items = {'chemistry:thorium_raw 2'}, 
				rarity = 2,
			},
			{
				items = {'chemistry:thorium_raw 2'}, 
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:uraninite", {
	description = S("Uraninite"),
	tiles = {"uraninite.png"},
	is_ground_content = true,
	groups = {cracky=2, radioactive = 1},
	drop = {
		max_items = 15,
		items = {
			{
				items = {'chemistry:radium_raw'},
            rarity = 10,
			},
			{
				items = {'chemistry:polonium'}, 
				rarity = 10,
			},
			{
				items = {'chemistry:plutonium_raw'}, 
				rarity = 20,
			},
			{
				items = {'technic:uranium_lump'}, 
			},
         {
            items = {'chemistry:radium_raw'},
            rarity = 10
         },
		}
	},
	sounds = default.node_sound_stone_defaults(),
})
end
minetest.register_node("chemistry:stone_with_lithium", {
	description = S("Lithium Ore"),
	tiles = {"default_stone.png^lithium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:lithium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:lithium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:lithium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_sodium", {
	description = S("Sodium Ore"),
	tiles = {"default_stone.png^sodium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:sodium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:sodium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:sodium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_potassium", {
	description = S("Potassium Ore"),
	tiles = {"default_stone.png^potassium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:potassium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:potassium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:potassium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_rubidium", {
	description = S("Rubidium Ore"),
	tiles = {"default_stone.png^rubidium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:rubidium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:rubidium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:rubidium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_cesium", {
	description = S("Cesium Ore"),
	tiles = {"default_stone.png^cesium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:cesium_shard 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:cesium_shard'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:cesium_shard'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("chemistry:stone_with_francium", {
	description = S("Francium Ore"),
	tiles = {"default_stone.png^francium_mineral.png"},
	is_ground_content = true,
	groups = {cracky=2, radioactive = 2, alkaline = 1},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'chemistry:francium 2'},  --The first and second drops ever
			},
			{
				items = {'chemistry:francium'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'chemistry:francium'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

 --
 ---- Ore Generation (spawns the ores at the default node "default:stone")
 --
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_lithium",
	wherein        = "default:stone",
	clust_scarcity = 6 * 6 * 6,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 100,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_lithium",
	wherein        = "default:stone",
	clust_scarcity = 5 * 5 * 5,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -2290,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sodium",
	wherein        = "default:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -1,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sodium",
	wherein        = "default:stone",
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 4,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -1000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_potassium",
	wherein        = "default:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -89,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_potassium",
	wherein        = "default:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 5,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_rubidium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -129,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_rubidium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 3,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cesium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 1,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -199,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cesium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 5,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_francium",
	wherein        = "default:stone",
	clust_scarcity = 29 * 29 * 29,
	clust_num_ores = 1,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -289,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_francium",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:iodine_block",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -1,
})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:mineral_oil",
		wherein         = {"default:stone"},
		clust_scarcity  = 56 * 56 * 56,
		clust_size      = 7,
		y_max           = 100,
		y_min           = -30010,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:limestone",
		wherein         = {"default:stone"},
		clust_scarcity  = 26 * 26 * 26,
		clust_size      = 5,
		y_max           = 100,
		y_min           = -30010,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:petroleum",
		wherein         = {"default:stone"},
		clust_scarcity  = 76 * 76 * 76,
		clust_size      = 10,
		y_max           = 100,
		y_min           = -30010,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})


	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:bleach",
		wherein         = {"default:dirt"},
		clust_scarcity  = 26 * 26 * 26,
		clust_size      = 2,
		y_max           = 100,
		y_min           = -20,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:glycerin",
		wherein         = {"default:dirt"},
		clust_scarcity  = 26 * 26 * 26,
		clust_size      = 3,
		y_max           = 1000,
		y_min           = -30,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:vinegar",
		wherein         = {"default:dirt"},
		clust_scarcity  = 26 * 26 * 26,
		clust_size      = 3,
		y_max           = 1000,
		y_min           = -30,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:hcl_acid",
		wherein         = {"default:stone"},
		clust_scarcity  = 46 * 46 * 46,
		clust_size      = 3,
		y_max           = 0,
		y_min           = -30000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:hso_acid",
		wherein         = {"default:stone"},
		clust_scarcity  = 66 * 66 * 66,
		clust_size      = 3,
		y_max           = -10,
		y_min           = -30000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})


	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:hno_acid",
		wherein         = {"chemistry:stone"},
		clust_scarcity  = 66 * 66 * 66,
		clust_size      = 3,
		y_max           = -11000,
		y_min           = -30000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	})

if minetest.get_modpath("technic") then
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uraninite",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 2,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uraninite",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 2,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 2,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 3,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:uraninite",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 2,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:thorite",
	wherein        = "chemistry:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 3,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -20000,
})
end

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_aluminium",
	wherein        = "default:stone",
	clust_scarcity = 14 * 14 * 14,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = 100,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_aluminium",
	wherein        = "default:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -50,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_gallium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -20,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_gallium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -300,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_bismuth",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -20,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_bismuth",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -300,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sulfur",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -5,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_sulfur",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -50,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_calcium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 0,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_calcium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 26 * 26 * 26,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -550,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -1000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cobalt",
	wherein        = "default:stone",
	clust_scarcity = 24 * 24 * 24,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -1000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_cobalt",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20 * 20,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -1500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_osmium",
	wherein        = "default:stone",
	clust_scarcity = 26 * 26 * 26,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -1500,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_osmium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -2000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_tungsten",
	wherein        = "default:stone",
	clust_scarcity = 31 * 31 * 31,
	clust_num_ores = 2,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -2000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_tungsten",
	wherein        = "default:stone",
	clust_scarcity = 24 * 24 * 24,
	clust_num_ores = 4,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -3500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_magnesium",
	wherein        = "default:stone",
	clust_scarcity = 29 * 29 * 29,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 120,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_magnesium",
	wherein        = "default:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_anthracite",
	wherein        = "default:stone",
	clust_scarcity = 32 * 32 * 32,
	clust_num_ores = 20,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = 120,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_anthracite",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 15,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_manganese",
	wherein        = "default:stone",
	clust_scarcity = 46 * 46 * 46,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 120,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_manganese",
	wherein        = "default:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 0,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 25 * 25 * 25,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 1,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:red_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:red_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 11 * 11 * 11,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:purple_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 6,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:purple_phosphorus",
	wherein        = "default:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_arsenic",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 6,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = 10,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:stone_with_arsenic",
	wherein        = "default:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 7,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -689,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:anthracite_block",
	wherein        = "chemistry:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 1,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:anthracite_block",
	wherein        = "chemistry:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -15500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:anthracite_block",
	wherein        = "chemistry:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 3,
	clust_size     = 2,
	biomes = {"strong_stone_forest"},
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:anthracite_block",
	wherein        = "chemistry:stone",
	clust_scarcity = 17 * 17 * 17,
	clust_num_ores = 6,
	clust_size     = 4,
	biomes = {"strong_stone_forest"},
	height_min     = -31000,
	height_max     = -15500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:lithium_block",
	wherein        = "default:stone",
	clust_scarcity = 20 * 20* 20,
	clust_num_ores = 1,
	clust_size     = 1,
	height_min     = -31000,
	height_max     = -10,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sulfide_seep",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -50,
	biomes = {"acid_caves"},
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sulfide_seep",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 7,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = -5000,
	biomes = {"acid_caves"},
})

	minetest.register_ore({
		ore_type        = "blob",
		ore             = "chemistry:alkaline_stone",
		wherein         = {"default:stone"},
		clust_scarcity  = 21 * 21 * 21,
		clust_size      = 5,
		y_max           = -100,
		y_min           = -5000,
		noise_threshold = 0.0,
		noise_params    = {
			offset = 0.5,
			scale = 0.2,
			spread = {x = 5, y = 5, z = 5},
			seed = -316,
			octaves = 1,
			persist = 0.0
		},
	biomes = {"alkaline_caves"},
	})

	minetest.register_decoration({
		name = "chemistry:antimony_crystal",
		deco_type = "simple",
		place_on = {"default:stone"},
		sidelen = 16,
		flags = "force_placement, all_floors",
	    fill_ratio = 0.001,
		y_max = 0,
		y_min = -31000,
		decoration = "chemistry:antimony_crystal",
	})

	minetest.register_decoration({
		name = "chemistry:uranyl_crystal",
		deco_type = "simple",
		place_on = {"chemistry:uranium_dioxide"},
		sidelen = 16,
		flags = "all_floors",
	    fill_ratio = 0.008,
		y_max = 100,
		y_min = -31000,
		decoration = "chemistry:uranyl_crystal",
	})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_lithium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_sodium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_potassium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sand_with_rubidium",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:cesium_block",
	wherein        = {"chemistry:alkaline_sand"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})




minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_lithium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_lithium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_sodium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_sodium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_potassium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_potassium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_rubidium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_rubidium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_cesium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:sandstone_with_cesium",
	wherein        = {"chemistry:alkaline_sandstone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})





minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_lithium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_lithium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 9,
	clust_size     = 3,
	height_min     = -3100,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_sodium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3000,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_sodium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_potassium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_potassium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 7,
	clust_size     = 2,
	height_min     = -9000,
	height_max     = 3100,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_rubidium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_rubidium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 6,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_cesium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_cesium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -10000,
	height_max     = 3100,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_francium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 2,
	clust_size     = 1,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:alk_stone_with_francium",
	wherein        = {"chemistry:alkaline_stone"},
	clust_scarcity = 8 * 8 * 8,
	clust_num_ores = 2,
	clust_size     = 1,
	height_min     = -10000,
	height_max     = 3100,
})
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_magnesium",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_magnesium",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_diamond",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_diamond",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_mese",
	wherein        = "chemistry:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_mese",
	wherein        = "chemistry:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_gold",
	wherein        = "chemistry:stone",
	clust_scarcity = 19 * 19 * 19,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_gold",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -11500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 12,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 15,
	clust_size     = 6,
	height_min     = -31000,
	height_max     = -16000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 22 * 22 * 22,
	clust_num_ores = 24,
	clust_size     = 10,
	biomes = {"strong_stone_forest"},
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_anthracite",
	wherein        = "chemistry:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 30,
	clust_size     = 10,
	biomes = {"strong_stone_forest"},
	height_min     = -31000,
	height_max     = -16000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_gas_seep",
	wherein        = "default:stone",
	clust_scarcity = 30 * 30 * 30,
	clust_num_ores = 1,
	clust_size     = 5,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_gas_seep",
	wherein        = "chemistry:stone",
	clust_scarcity = 20 * 20 * 20,
	clust_num_ores = 3,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -16000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_titanium",
	wherein        = "chemistry:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 3,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_titanium",
	wherein        = "chemistry:stone",
	clust_scarcity = 9 * 9 * 9,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -16500,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_cobalt",
	wherein        = "chemistry:stone",
	clust_scarcity = 18 * 18 * 18,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_cobalt",
	wherein        = "chemistry:stone",
	clust_scarcity = 10 * 10 * 10,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -18000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_osmium",
	wherein        = "chemistry:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -11000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_osmium",
	wherein        = "chemistry:stone",
	clust_scarcity = 12 * 12 * 12,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -19000,
})


minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_tungsten",
	wherein        = "chemistry:stone",
	clust_scarcity = 21 * 21 * 21,
	clust_num_ores = 3,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -11000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_tungsten",
	wherein        = "chemistry:stone",
	clust_scarcity = 14 * 14 * 14,
	clust_num_ores = 6,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -21000,
})

minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_gem",
	wherein        = "chemistry:stone",
	clust_scarcity = 31 * 31 * 31,
	clust_num_ores = 2,
	clust_size     = 2,
	height_min     = -31000,
	height_max     = -21000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "chemistry:strong_stone_with_gem",
	wherein        = "chemistry:stone",
	clust_scarcity = 31 * 31 * 31,
	clust_num_ores = 4,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -27500,
})

