
local S = chemistry.getter

minetest.register_craftitem("chemistry:arsenic", {
	description = S("Arsenic Rock"),
	inventory_image = "arsenic.png",
})

minetest.register_node("chemistry:arsenic_water", {
	description = S("Arsenic Water"),
	drawtype = "liquid",
	waving = 3,
	tiles = {
		{
			name = "liquid_source_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
		{
			name = "liquid_source_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 2.0,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
   damage_per_second = 7,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "chemistry:arsenic_water_flowing",
	liquid_alternative_source = "chemistry:arsenic_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 155, r = 0, g = 0, b = 0},
	groups = {liquid = 3, cools_lava = 1, toxic=1, water = 1},
	sounds = default.node_sound_water_defaults(),
})

minetest.register_node("chemistry:arsenic_water_flowing", {
	description = S("Flowing Arsenic Water"),
	drawtype = "flowingliquid",
	waving = 3,
	tiles = {"liquid.png^[opacity:150^[colorize:black:150"},
	special_tiles = {
		{
			name = "liquid_flowing_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = false,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
		{
			name = "liquid_flowing_animated.png^[opacity:150^[colorize:black:150",
			backface_culling = true,
			animation = {
				type = "vertical_frames",
				aspect_w = 16,
				aspect_h = 16,
				length = 0.5,
			},
		},
	},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	is_ground_content = false,
	drop = "",
   damage_per_second = 7,
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "chemistry:arsenic_water_flowing",
	liquid_alternative_source = "chemistry:arsenic_water",
	liquid_viscosity = 1,
	post_effect_color = {a = 155, r = 0, g = 0, b = 0},
	groups = {liquid = 3, not_in_creative_inventory = 1,
		cools_lava = 1, toxic=1, water = 1},
	sounds = default.node_sound_water_defaults(),
})

bucket.register_liquid(
	"chemistry:arsenic_water",
	"chemistry:arsenic_water_flowing",
	"chemistry:arsenic_water_bucket",
	"arsenic_wt_bucket.png",
	S("Arsenic Water Bucket"),
	{tool = 1, toxic = 1}
)

plastic_bucket.register_liquid(
	"chemistry:arsenic_water",
	"chemistry:arsenic_water_flowing",
	"chemistry:arsenic_water_bucket_plastic",
	"acid_bucket.png",
	S("Arsenic Water Bucket"),
	{tool = 1, toxic = 1}
)

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:arsenic_water_bucket',
	recipe = {
		'bucket:bucket_water', 'chemistry:arsenic',
	}
})

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:arsenic_water_bucket_plastic',
	recipe = {
		'plastic_bucket:bucket_water', 'chemistry:arsenic',
	}
})

minetest.register_craft({
   type = "shapeless",
	output = 'chemistry:osmium_tetroxide',
	recipe = {
		'group:water_bucket', 'chemistry:osmium_dust',
	}
})

minetest.register_craftitem("chemistry:osmium_tetroxide", {
	description = S("Osmium Tetroxide Crystals"),
	inventory_image = "osmium_tetroxide.png",
})

