local path = minetest.get_modpath(minetest.get_current_modname()) .. "/"

chemistry = rawget(_G, "chemistry") or {version = 20250214}
chemistry.allow_corrosion = minetest.settings:get_bool("chemistry.allow_corrosion", true)
chemistry.tool_intoxicate = minetest.settings:get_bool("chemistry.tool_intoxicate", true)
chemistry.allow_alkali_reaction = minetest.settings:get_bool("chemistry.allow_alkali_reaction", true)
chemistry.enable_nuke = minetest.settings:get_bool("chemistry.enable_nuke", true)
chemistry.allow_node_melt = minetest.settings:get_bool("chemistry.allow_st_lava_melt", true)
chemistry.allow_explosive_nodes = minetest.settings:get_bool("chemistry.allow_explosive_nodes", true)
chemistry.dilute_gases = minetest.settings:get_bool("chemistry.dilute_gases", true)
chemistry.node_particles = minetest.settings:get_bool("chemistry.node_particles") or "All"
chemistry.stalac_height = tonumber(minetest.settings:get("stalac_height") or 10)
chemistry.stalag_height = tonumber(minetest.settings:get("stalag_height") or 10)
chemistry.enable_corrosion_protection = minetest.settings:get_bool("chemistry.enable_corrosion_protection", true)


if rawget(_G, "intllib") then
	chemistry.getter = intllib.Getter()
else
	-- Intllib copypasta: TODO replace with the client-side translation API
	chemistry.getter = function(s,a,...)
		if a==nil then return s end
		a={a,...}
		return s:gsub("(@?)@(%(?)(%d+)(%)?)", function(e,o,n,c)
			if e==""then
				return a[tonumber(n)]..(o==""and c or"")
			end
			return "@"..o..n..c
		end)
	end
end

dofile(path .. "sounds.lua")
dofile(path .. "halogens.lua")
dofile(path .. "alkali_metals.lua")
dofile(path .. "gases.lua")
dofile(path .. "others.lua")
dofile(path .. "thermite.lua")
if chemistry.allow_corrosion then
   dofile(path .. "corrosion.lua")
end
if chemistry.dilute_gases then
   dofile(path .. "gas_removal.lua")
end
dofile(path .. "acids.lua")
dofile(path .. "glow_water.lua")
dofile(path .. "hydrocarbons.lua")
dofile(path .. "fuel_flammability.lua")
dofile(path .. "mapgen.lua")
dofile(path .. "minerals.lua")
if chemistry.node_particles ~= "None" then
   dofile(path .. "particle_gen.lua")
end
dofile(path .. "explosives.lua")
dofile(path .. "freezing.lua")
dofile(path .. "torches.lua")
dofile(path .. "alternate_tools.lua")
dofile(path .. "tools.lua")
dofile(path .. "molten_metals.lua")
dofile(path .. "schems.lua")
dofile(path .. "strong_lava.lua")
if minetest.get_modpath("3d_armor") then
   dofile(path .. "armor.lua")
end
if minetest.get_modpath("bonemeal") then
   dofile(path .. "bonemeal.lua")
end
dofile(path .. "toxic_elements.lua")
if minetest.get_modpath("technic") then
   dofile(path .. "half-life.lua")
   dofile(path .. "radioactive.lua")
   if chemistry.enable_nuke then
      dofile(path .. "nuke.lua")
   end
   dofile(path .. "detectors.lua")
   dofile(path.."machines/init.lua")
   dofile(path.."technic_exclusive.lua")
end
dofile(path.."weather.lua")
dofile(path .. "death_functions.lua")