-- bring/init.lua
-- A simple command that brings another user to your spot
-- Copyright (c) 2026  1F616EMO
-- SPDX-License-Identifier: LGPL-2.1-or-later

local S = core.get_translator("bring")
local DS = core.get_translator("__builtin")

core.register_chatcommand("bring", {
    description = S("Bring another player to your spot"),
    params = S("<player name>"),
    privs = { teleport = true, bring = true },
    func = function(name, param)
        local bring_name = param:trim()
        if bring_name == "" then
            return false
        elseif name == bring_name then
            return false, DS("One does not teleport to oneself.")
        end

        local myself_player = core.get_player_by_name(name)
        if not myself_player then
            return false, S("You must be online to use this command.")
        end

        local bring_player = core.get_player_by_name(bring_name)
        if not bring_player then
            return false, DS("Cannot get player with name @1.", bring_name)
        end

        if bring_player:get_attach() then
            return false, DS("Cannot teleport, @1 " ..
                "is attached to an object!", bring_name)
        end

        local pos = myself_player:get_pos()
        bring_player:set_pos(pos)
        return true, DS("Teleporting @1 to @2 at @3.", bring_name, name, core.pos_to_string(pos, 1))
    end,
})
