-- directions/init.lua
-- Lines laying on the ground to guide directions
-- Copyright (C) 2025  1F616EMO
-- SPDX-License-Identifier: LGPL-3.0-or-later

local S = core.get_translator("directions")

local function generate_textures(color)
    return {
        "directions_base_straight.png^[makealpha:0,0,0^[colorize:" .. color,   -- straight
        "directions_base_curved.png^[makealpha:0,0,0^[colorize:" .. color,     -- curved
        "directions_base_t_junction.png^[makealpha:0,0,0^[colorize:" .. color, -- t-junction
        "directions_base_crossing.png^[makealpha:0,0,0^[colorize:" .. color,   -- crossing
    }
end

local definitions = {
    -- color_name, display name, color (from wool texture, averaged)
    { "black",      S("Black Direction Line"),      "#1D1D1D" },
    { "blue",       S("Blue Direction Line"),       "#004891" },
    { "brown",      S("Brown Direction Line"),      "#562B00" },
    { "cyan",       S("Cyan Direction Line"),       "#00838B" },
    { "dark_green", S("Dark_green Direction Line"), "#206700" },
    { "dark_grey",  S("Dark_grey Direction Line"),  "#3B3B3B" },
    { "green",      S("Green Direction Line"),      "#5CD81C" },
    { "grey",       S("Grey Direction Line"),       "#838383" },
    { "magenta",    S("Magenta Direction Line"),    "#C9036D" },
    { "orange",     S("Orange Direction Line"),     "#D65215" },
    { "pink",       S("Pink Direction Line"),       "#FF8484" },
    { "red",        S("Red Direction Line"),        "#A81111" },
    { "violet",     S("Violet Direction Line"),     "#5D03A9" },
    { "white",      S("White Direction Line"),      "#DCDCDC" },
    { "yellow",     S("Yellow Direction Line"),     "#FEE110" },
}

local materials = xcompat.materials

for _, data in ipairs(definitions) do
    core.register_node("directions:line_" .. data[1], {
        description = data[2],
        drawtype = "raillike",
        paramtype = "light",
        sunlight_propagates = true,
		is_ground_content = false,
        light_source = 5,
        walkable = false,
        selection_box = {
			type = "fixed",
			fixed = {-1/2, -1/2, -1/2, 1/2, -1/2+1/16, 1/2},
		},
        tiles = generate_textures(data[3]),
        groups = {
            snappy = 2,
            choppy = 2,
            oddly_breakable_by_hand = 3,
            direction_line = 1,
            connect_to_raillike = 10,
        },
        sounds = xcompat.sounds.node_sound_wool_defaults(),
    })

    core.register_craft({
        type = "shapeless",
        output = "directions:line_" .. data[1],
        recipe = {
            "group:direction_line",
            materials["dye_" .. data[1]],
        },
    })

    if materials["wool_" .. data[1]] or core.registered_items["wool:" .. data[1]] then
        core.register_craft({
            output = "directions:line_" .. data[1] .. " 4",
            recipe = {
                { materials.string },
                { materials["wool_" .. data[1]] or ("wool:" .. data[1]) },
                { materials.string },
            },
        })
    end
end
