# Echo API Reference

## Terminology

* An **event** is the object that is stored in the database. It is a table with a `type` field and other optional data.
* A **notification** is the object generated by a event handler by passing in an event. It is responsible for displaying the event in the GUI.

## Register event type

```lua
echo.register_event_type("echo:test_more", {
    -- The title of the event, used for filtering
    title = S("Test event: Show more"),

    -- Takes an event and return a notification
    handle_event = function(event)
        return {
            -- Display title of the notification
            title = S("Test event: Show more"),

            -- Short description of the notification
            description = S("Description: @1", event.description),

            -- Image showed alongside the notification. Should be square.
            image = "air.png",

            -- Callback called when clicking on the notification
            onclick = echo.onclick.show_more,

            -- for onclick = echo.onclick.show_more: The text shown after clicking
            more = S("This is the raw data of the event:") .. "\n\n" .. dump(event),
        }
    end,
})
```

### `onclick` handler in notifications

The `onclick` handler takes three arguments, `notifictaion`, `player`, and `ctx`. If the handler returns a function, it should be a function accepting the same set of arguments and will be executed before any other things happen. If the latter function returns a non-`nil` value (which should be a valid Flow element), it will replace the GUI.

In the replaced GUI, you can set the `on_event` field of a button (or any elements that would trigger an event) to `echo.on_event_reset_after_click`. When that button is clicked (or otherwise triggered an event), the GUI returns to its initial state.

## Send notifications

```lua
echo.send_event_to(player_name, {
    -- The event type ID
    type = "echo:test_simple",

    -- Any paarmeters `handle_event` requires to construct the notification
    description = param,
})
```

## Callbacks

* `echo.register_on_send_event(function(event, notification))`: Called when an event is sent
  * You can get the target player in `event.to`.
* `echo.register_on_read_message(function(event, notification))`: Called when an notification is read
* `echo.register_on_delete_message(function(event, notification))`: Called when an notification is deleted
