# Guider

API for creating waypoints that fire callbacks on player approach. Useful for quests management, etc.

## API

* `guider.add_waypoint(player, def)`: Create a waypoint for a player. Returns a handler.
* `guider.destroy_waypoint(player, handler)`: Destructs a waypoint by the player object and the handler.

## Waypoint definition

```lua
{
    name = "Display Name", -- string, optional, default: stringified position
    image = "guider_marker_default.png", -- string, optional, default: guider_marker_default.png
    suffix = " m", -- string, optional, default: none
    percision = 10, -- integer >= 0, optional, default: 10 (1 d.p.)
    text_color = 0xffffff, -- integer of color, optional, default: 0xffffff (white)
    scale = { x = 2, y = 2 }, -- image scale in table (x, y) or number, optional, default: 2
    image_height = 16, -- image height in pixel, optional, default: 16
    pos = vector.new(0, 0, 0), -- posiiton of waypoint, mandantory
    on_approach = function(player, handler) end, -- Called on approach, optional
    approach_distance = 5, -- Maximum distance to be considered approaching, optional
    max_age = 60, -- Maximum age in seconds, optional, default: infinity
}
```

Both `on_approach` and `approach_distance` must be set for approach detection to work.
